/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

public class LocalCacheDirectoryManager {
    private final int perDirectoryFileLimit;
    public static final int DIRECTORIES_PER_LEVEL = 36;
    private Queue<Directory> nonFullDirectories;
    private HashMap<String, Directory> knownDirectories;
    private int totalSubDirectories = 0;

    public LocalCacheDirectoryManager(Configuration conf) {
        Directory rootDir = new Directory(this.totalSubDirectories);
        this.nonFullDirectories = new LinkedList<Directory>();
        this.knownDirectories = new HashMap();
        this.knownDirectories.put("", rootDir);
        this.nonFullDirectories.add(rootDir);
        this.perDirectoryFileLimit = conf.getInt("yarn.nodemanager.local-cache.max-files-per-directory", 8192) - 36;
    }

    public synchronized String getRelativePathForLocalization() {
        Directory subDir;
        if (this.nonFullDirectories.isEmpty()) {
            ++this.totalSubDirectories;
            Directory newDir = new Directory(this.totalSubDirectories);
            this.nonFullDirectories.add(newDir);
            this.knownDirectories.put(newDir.getRelativePath(), newDir);
        }
        if ((subDir = this.nonFullDirectories.peek()).incrementAndGetCount() >= this.perDirectoryFileLimit) {
            this.nonFullDirectories.remove();
        }
        return subDir.getRelativePath();
    }

    public synchronized void decrementFileCountForPath(String relPath) {
        relPath = relPath == null ? "" : relPath.trim();
        Directory subDir = this.knownDirectories.get(relPath);
        int oldCount = subDir.getCount();
        if (subDir.decrementAndGetCount() < this.perDirectoryFileLimit && oldCount >= this.perDirectoryFileLimit) {
            this.nonFullDirectories.add(subDir);
        }
    }

    public synchronized void incrementFileCountForPath(String relPath) {
        Directory subDir = this.knownDirectories.get(relPath = relPath == null ? "" : relPath.trim());
        if (subDir == null) {
            int dirnum = Directory.getDirectoryNumber(relPath);
            this.totalSubDirectories = Math.max(dirnum, this.totalSubDirectories);
            subDir = new Directory(dirnum);
            this.nonFullDirectories.add(subDir);
            this.knownDirectories.put(subDir.getRelativePath(), subDir);
        }
        if (subDir.incrementAndGetCount() >= this.perDirectoryFileLimit) {
            this.nonFullDirectories.remove(subDir);
        }
    }

    public static Path getCacheDirectoryRoot(Path path) {
        while (path != null) {
            String name = path.getName();
            if (name.length() != 1) {
                return path;
            }
            int dirnum = 36;
            try {
                dirnum = Integer.parseInt(name, 36);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dirnum >= 36) {
                return path;
            }
            path = path.getParent();
        }
        return path;
    }

    @VisibleForTesting
    synchronized Directory getDirectory(String relPath) {
        return this.knownDirectories.get(relPath);
    }

    static class Directory {
        private final String relativePath;
        private int fileCount = 0;

        static String getRelativePath(int directoryNo) {
            String relativePath = "";
            if (directoryNo > 0) {
                String tPath = Integer.toString(directoryNo - 1, 36);
                StringBuffer sb = new StringBuffer();
                if (tPath.length() == 1) {
                    sb.append(tPath.charAt(0));
                } else {
                    sb.append(Integer.toString(Integer.parseInt(tPath.substring(0, 1), 36) - 1, 36));
                }
                for (int i = 1; i < tPath.length(); ++i) {
                    sb.append("/").append(tPath.charAt(i));
                }
                relativePath = sb.toString();
            }
            return relativePath;
        }

        static int getDirectoryNumber(String relativePath) {
            String numStr = relativePath.replace("/", "");
            if (relativePath.isEmpty()) {
                return 0;
            }
            if (numStr.length() > 1) {
                String firstChar = Integer.toString(Integer.parseInt(numStr.substring(0, 1), 36) + 1, 36);
                numStr = firstChar + numStr.substring(1);
            }
            return Integer.parseInt(numStr, 36) + 1;
        }

        public Directory(int directoryNo) {
            this.relativePath = Directory.getRelativePath(directoryNo);
        }

        public int incrementAndGetCount() {
            return ++this.fileCount;
        }

        public int decrementAndGetCount() {
            return --this.fileCount;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public int getCount() {
            return this.fileCount;
        }
    }
}

