/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;

public class UserGroupMappingPlacementRule
extends PlacementRule {
    private static final Log LOG = LogFactory.getLog(UserGroupMappingPlacementRule.class);
    public static final String CURRENT_USER_MAPPING = "%user";
    public static final String PRIMARY_GROUP_MAPPING = "%primary_group";
    private boolean overrideWithQueueMappings = false;
    private List<QueueMapping> mappings = null;
    private Groups groups;

    public UserGroupMappingPlacementRule() {
        this(false, null, null);
    }

    public UserGroupMappingPlacementRule(boolean overrideWithQueueMappings, List<QueueMapping> newMappings, Groups groups) {
        this.mappings = newMappings;
        this.overrideWithQueueMappings = overrideWithQueueMappings;
        this.groups = groups;
    }

    private ApplicationPlacementContext getPlacementForUser(String user) throws IOException {
        for (QueueMapping mapping : this.mappings) {
            if (mapping.type == QueueMapping.MappingType.USER) {
                if (mapping.source.equals(CURRENT_USER_MAPPING)) {
                    if (mapping.queue.equals(CURRENT_USER_MAPPING)) {
                        return this.getPlacementContext(mapping, user);
                    }
                    if (mapping.queue.equals(PRIMARY_GROUP_MAPPING)) {
                        return this.getPlacementContext(mapping, (String)this.groups.getGroups(user).get(0));
                    }
                    return this.getPlacementContext(mapping);
                }
                if (user.equals(mapping.source)) {
                    return this.getPlacementContext(mapping);
                }
            }
            if (mapping.type != QueueMapping.MappingType.GROUP) continue;
            for (String userGroups : this.groups.getGroups(user)) {
                if (!userGroups.equals(mapping.source)) continue;
                if (mapping.queue.equals(CURRENT_USER_MAPPING)) {
                    return this.getPlacementContext(mapping, user);
                }
                return this.getPlacementContext(mapping);
            }
        }
        return null;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName = asc.getQueue();
        ApplicationId applicationId = asc.getApplicationId();
        if (this.mappings != null && this.mappings.size() > 0) {
            try {
                ApplicationPlacementContext mappedQueue = this.getPlacementForUser(user);
                if (mappedQueue != null && (queueName.equals("default") || queueName.equals(mappedQueue.getQueue()) || this.overrideWithQueueMappings)) {
                    LOG.info((Object)("Application " + applicationId + " user " + user + " mapping [" + queueName + "] to [" + mappedQueue + "] override " + this.overrideWithQueueMappings));
                    return mappedQueue;
                }
            }
            catch (IOException ioex) {
                String message = "Failed to submit application " + applicationId + " submitted by user " + user + " reason: " + ioex.getMessage();
                throw new YarnException(message);
            }
        }
        return null;
    }

    private ApplicationPlacementContext getPlacementContext(QueueMapping mapping) {
        return this.getPlacementContext(mapping, mapping.getQueue());
    }

    private ApplicationPlacementContext getPlacementContext(QueueMapping mapping, String leafQueueName) {
        if (!StringUtils.isEmpty((CharSequence)mapping.parentQueue)) {
            return new ApplicationPlacementContext(leafQueueName, mapping.getParentQueue());
        }
        return new ApplicationPlacementContext(leafQueueName);
    }

    @Override
    @VisibleForTesting
    public boolean initialize(CapacitySchedulerContext schedulerContext) throws IOException {
        CapacitySchedulerConfiguration conf = schedulerContext.getConfiguration();
        boolean overrideWithQueueMappings = conf.getOverrideWithQueueMappings();
        LOG.info((Object)("Initialized queue mappings, override: " + overrideWithQueueMappings));
        List<QueueMapping> queueMappings = conf.getQueueMappings();
        ArrayList<QueueMapping> newMappings = new ArrayList<QueueMapping>();
        CapacitySchedulerQueueManager queueManager = schedulerContext.getCapacitySchedulerQueueManager();
        for (QueueMapping mapping : queueMappings) {
            QueuePath queuePath = UserGroupMappingPlacementRule.extractQueuePath(mapping.getQueue());
            if (UserGroupMappingPlacementRule.isStaticQueueMapping(mapping)) {
                QueueMapping newMapping;
                CSQueue queue = queueManager.getQueue(mapping.getQueue());
                if (UserGroupMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                    queue = queueManager.getQueue(queuePath.getLeafQueue());
                    if (UserGroupMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                        newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
                        if (newMapping == null) {
                            throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
                        }
                        newMappings.add(newMapping);
                        continue;
                    }
                    newMapping = UserGroupMappingPlacementRule.validateAndGetQueueMapping(queueManager, queue, mapping, queuePath);
                    newMappings.add(newMapping);
                    continue;
                }
                newMapping = UserGroupMappingPlacementRule.validateAndGetQueueMapping(queueManager, queue, mapping, queuePath);
                newMappings.add(newMapping);
                continue;
            }
            QueueMapping newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping != null) {
                newMappings.add(newMapping);
                continue;
            }
            newMappings.add(mapping);
        }
        if (newMappings.size() > 0) {
            Groups groups = new Groups((Configuration)conf);
            this.mappings = newMappings;
            this.groups = groups;
            this.overrideWithQueueMappings = overrideWithQueueMappings;
            return true;
        }
        return false;
    }

    private static QueueMapping validateAndGetQueueMapping(CapacitySchedulerQueueManager queueManager, CSQueue queue, QueueMapping mapping, QueuePath queuePath) throws IOException {
        if (!(queue instanceof LeafQueue)) {
            throw new IOException("mapping contains invalid or non-leaf queue : " + mapping.getQueue());
        }
        if (queue instanceof AutoCreatedLeafQueue && queue.getParent() instanceof ManagedParentQueue) {
            QueueMapping newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping == null) {
                throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
            }
            return newMapping;
        }
        return mapping;
    }

    private static boolean ifQueueDoesNotExist(CSQueue queue) {
        return queue == null;
    }

    private static QueueMapping validateAndGetAutoCreatedQueueMapping(CapacitySchedulerQueueManager queueManager, QueueMapping mapping, QueuePath queuePath) throws IOException {
        if (queuePath.hasParentQueue()) {
            UserGroupMappingPlacementRule.validateParentQueue(queueManager.getQueue(queuePath.getParentQueue()), queuePath.getParentQueue(), queuePath.getLeafQueue());
            return new QueueMapping(mapping.getType(), mapping.getSource(), queuePath.getLeafQueue(), queuePath.getParentQueue());
        }
        return null;
    }

    private static boolean isStaticQueueMapping(QueueMapping mapping) {
        return !mapping.getQueue().contains(CURRENT_USER_MAPPING) && !mapping.getQueue().contains(PRIMARY_GROUP_MAPPING);
    }

    private static QueuePath extractQueuePath(String queueName) throws IOException {
        int parentQueueNameEndIndex = queueName.lastIndexOf(".");
        if (parentQueueNameEndIndex > -1) {
            String parentQueue = queueName.substring(0, parentQueueNameEndIndex).trim();
            String leafQueue = queueName.substring(parentQueueNameEndIndex + 1).trim();
            return new QueuePath(parentQueue, leafQueue);
        }
        return new QueuePath(queueName);
    }

    private static void validateParentQueue(CSQueue parentQueue, String parentQueueName, String leafQueueName) throws IOException {
        if (parentQueue == null) {
            throw new IOException("mapping contains invalid or non-leaf queue [" + leafQueueName + "] and invalid parent queue [" + parentQueueName + "]");
        }
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IOException("mapping contains leaf queue [" + leafQueueName + "] and invalid parent queue which does not have auto creation of leaf queues enabled [" + parentQueueName + "]");
        }
        if (!parentQueue.getQueueName().equals(parentQueueName)) {
            throw new IOException("mapping contains invalid or non-leaf queue [" + leafQueueName + "] and invalid parent queue which does not match existing leaf queue's parent : [" + parentQueueName + "] does not match [ " + parentQueue.getQueueName() + "]");
        }
    }

    @VisibleForTesting
    public List<QueueMapping> getQueueMappings() {
        return this.mappings;
    }

    private static class QueuePath {
        public String parentQueue;
        public String leafQueue;

        public QueuePath(String leafQueue) {
            this.leafQueue = leafQueue;
        }

        public QueuePath(String parentQueue, String leafQueue) {
            this.parentQueue = parentQueue;
            this.leafQueue = leafQueue;
        }

        public String getParentQueue() {
            return this.parentQueue;
        }

        public String getLeafQueue() {
            return this.leafQueue;
        }

        public boolean hasParentQueue() {
            return this.parentQueue != null;
        }

        public String toString() {
            return this.parentQueue + "." + this.leafQueue;
        }
    }

    @InterfaceAudience.Private
    public static class QueueMapping {
        MappingType type;
        String source;
        String queue;
        String parentQueue;
        public static final String DELIMITER = ":";

        public QueueMapping(MappingType type, String source, String queue) {
            this.type = type;
            this.source = source;
            this.queue = queue;
            this.parentQueue = null;
        }

        public QueueMapping(MappingType type, String source, String queue, String parentQueue) {
            this.type = type;
            this.source = source;
            this.queue = queue;
            this.parentQueue = parentQueue;
        }

        public String getQueue() {
            return this.queue;
        }

        public String getParentQueue() {
            return this.parentQueue;
        }

        public boolean hasParentQueue() {
            return this.parentQueue != null;
        }

        public MappingType getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueueMapping) {
                QueueMapping other = (QueueMapping)obj;
                return other.type.equals((Object)this.type) && other.source.equals(this.source) && other.queue.equals(this.queue);
            }
            return false;
        }

        public String toString() {
            return this.type.toString() + DELIMITER + this.source + DELIMITER + (this.parentQueue != null ? this.parentQueue + "." + this.queue : this.queue);
        }

        public static enum MappingType {
            USER("u"),
            GROUP("g");

            private final String type;

            private MappingType(String type) {
                this.type = type;
            }

            public String toString() {
                return this.type;
            }
        }
    }
}

