/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryRMStateStore
extends RMStateStore {
    RMStateStore.RMState state = new RMStateStore.RMState();
    private long epoch = 0L;

    @VisibleForTesting
    public RMStateStore.RMState getState() {
        return this.state;
    }

    @Override
    public void checkVersion() throws Exception {
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        long currentEpoch = this.epoch;
        this.epoch = this.nextEpoch(this.epoch);
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState returnState = new RMStateStore.RMState();
        returnState.appState.putAll(this.state.appState);
        returnState.rmSecretManagerState.getMasterKeyState().addAll(this.state.rmSecretManagerState.getMasterKeyState());
        returnState.rmSecretManagerState.getTokenState().putAll(this.state.rmSecretManagerState.getTokenState());
        returnState.rmSecretManagerState.dtSequenceNumber = this.state.rmSecretManagerState.dtSequenceNumber;
        returnState.amrmTokenSecretManagerState = this.state.amrmTokenSecretManagerState == null ? null : AMRMTokenSecretManagerState.newInstance(this.state.amrmTokenSecretManagerState);
        return returnState;
    }

    @Override
    public synchronized void initInternal(Configuration conf) {
        this.epoch = this.baseEpoch;
    }

    @Override
    protected synchronized void startInternal() throws Exception {
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appState) throws Exception {
        this.state.appState.put(appId, appState);
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appState) throws Exception {
        LOG.info((Object)("Updating final state " + (Object)((Object)appState.getState()) + " for app: " + appId));
        if (this.state.appState.get(appId) != null) {
            appState.attempts.putAll(this.state.appState.get((Object)appId).attempts);
        }
        this.state.appState.put(appId, appState);
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptState) throws Exception {
        ApplicationStateData appState = this.state.getApplicationState().get(attemptState.getAttemptId().getApplicationId());
        if (appState == null) {
            throw new YarnRuntimeException("Application doesn't exist");
        }
        appState.attempts.put(attemptState.getAttemptId(), attemptState);
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptState) throws Exception {
        ApplicationStateData appState = this.state.getApplicationState().get(appAttemptId.getApplicationId());
        if (appState == null) {
            throw new YarnRuntimeException("Application doesn't exist");
        }
        LOG.info((Object)("Updating final state " + (Object)((Object)attemptState.getState()) + " for attempt: " + attemptState.getAttemptId()));
        appState.attempts.put(attemptState.getAttemptId(), attemptState);
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId appAttemptId) throws Exception {
        ApplicationStateData appState = this.state.getApplicationState().get(appAttemptId.getApplicationId());
        ApplicationAttemptStateData attemptState = appState.attempts.remove(appAttemptId);
        LOG.info((Object)("Removing state for attempt: " + appAttemptId));
        if (attemptState == null) {
            throw new YarnRuntimeException("Application doesn't exist");
        }
    }

    @Override
    public synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        ApplicationStateData removed = this.state.appState.remove(appId);
        if (removed == null) {
            throw new YarnRuntimeException("Removing non-existing application state");
        }
    }

    private void storeOrUpdateRMDT(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, boolean isUpdate) throws Exception {
        Map<RMDelegationTokenIdentifier, Long> rmDTState = this.state.rmSecretManagerState.getTokenState();
        if (rmDTState.containsKey(rmDTIdentifier)) {
            IOException e = new IOException("RMDelegationToken: " + rmDTIdentifier + "is already stored.");
            LOG.info((Object)("Error storing info for RMDelegationToken: " + rmDTIdentifier), (Throwable)e);
            throw e;
        }
        rmDTState.put(rmDTIdentifier, renewDate);
        if (!isUpdate) {
            this.state.rmSecretManagerState.dtSequenceNumber = rmDTIdentifier.getSequenceNumber();
        }
        LOG.info((Object)("Store RMDT with sequence number " + rmDTIdentifier.getSequenceNumber()));
    }

    @Override
    public synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDT(rmDTIdentifier, renewDate, false);
    }

    @Override
    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        Map<RMDelegationTokenIdentifier, Long> rmDTState = this.state.rmSecretManagerState.getTokenState();
        rmDTState.remove(rmDTIdentifier);
        LOG.info((Object)("Remove RMDT with sequence number " + rmDTIdentifier.getSequenceNumber()));
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.removeRMDelegationTokenState(rmDTIdentifier);
        this.storeOrUpdateRMDT(rmDTIdentifier, renewDate, true);
        LOG.info((Object)("Update RMDT with sequence number " + rmDTIdentifier.getSequenceNumber()));
    }

    @Override
    public synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        Set<DelegationKey> rmDTMasterKeyState = this.state.rmSecretManagerState.getMasterKeyState();
        if (rmDTMasterKeyState.contains(delegationKey)) {
            IOException e = new IOException("RMDTMasterKey with keyID: " + delegationKey.getKeyId() + " is already stored");
            LOG.info((Object)("Error storing info for RMDTMasterKey with keyID: " + delegationKey.getKeyId()), (Throwable)e);
            throw e;
        }
        this.state.getRMDTSecretManagerState().getMasterKeyState().add(delegationKey);
        LOG.info((Object)("Store RMDT master key with key id: " + delegationKey.getKeyId() + ". Currently rmDTMasterKeyState size: " + rmDTMasterKeyState.size()));
    }

    @Override
    public synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        LOG.info((Object)("Remove RMDT master key with key id: " + delegationKey.getKeyId()));
        Set<DelegationKey> rmDTMasterKeyState = this.state.rmSecretManagerState.getMasterKeyState();
        rmDTMasterKeyState.remove(delegationKey);
    }

    @Override
    protected synchronized void storeReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName) throws Exception {
        LOG.info((Object)("Storing reservationallocation for " + reservationIdName + " for plan " + planName));
        Map<ReservationId, YarnProtos.ReservationAllocationStateProto> planState = this.state.getReservationState().get(planName);
        if (planState == null) {
            planState = new HashMap<ReservationId, YarnProtos.ReservationAllocationStateProto>();
            this.state.getReservationState().put(planName, planState);
        }
        ReservationId reservationId = ReservationId.parseReservationId((String)reservationIdName);
        planState.put(reservationId, reservationAllocation);
    }

    @Override
    protected synchronized void removeReservationState(String planName, String reservationIdName) throws Exception {
        LOG.info((Object)("Removing reservationallocation " + reservationIdName + " for plan " + planName));
        Map<ReservationId, YarnProtos.ReservationAllocationStateProto> planState = this.state.getReservationState().get(planName);
        if (planState == null) {
            throw new YarnRuntimeException("State for plan " + planName + " does not exist");
        }
        ReservationId reservationId = ReservationId.parseReservationId((String)reservationIdName);
        planState.remove(reservationId);
        if (planState.isEmpty()) {
            this.state.getReservationState().remove(planName);
        }
    }

    @Override
    protected Version loadVersion() throws Exception {
        return null;
    }

    @Override
    protected void storeVersion() throws Exception {
    }

    @Override
    protected Version getCurrentVersion() {
        return null;
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) {
        if (amrmTokenSecretManagerState != null) {
            this.state.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        }
    }

    @Override
    public void deleteStore() throws Exception {
    }

    @Override
    public void removeApplication(ApplicationId removeAppId) throws Exception {
    }
}

