/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeOpCode;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraintTransformations;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class PlacementConstraintsUtil {
    private static final Log LOG = LogFactory.getLog(PlacementConstraintsUtil.class);

    private PlacementConstraintsUtil() {
    }

    private static boolean canSatisfySingleConstraintExpression(ApplicationId targetApplicationId, PlacementConstraint.SingleConstraint sc, PlacementConstraint.TargetExpression te, SchedulerNode node, AllocationTagsManager tm) throws InvalidAllocationTagsQueryException {
        boolean checkMaxCardinality;
        AllocationTags allocationTags = AllocationTags.createAllocationTags(targetApplicationId, te.getTargetKey(), te.getTargetValues());
        long minScopeCardinality = 0L;
        long maxScopeCardinality = 0L;
        int desiredMinCardinality = sc.getMinCardinality();
        int desiredMaxCardinality = sc.getMaxCardinality();
        boolean checkMinCardinality = desiredMinCardinality > 0;
        boolean bl = checkMaxCardinality = desiredMaxCardinality < Integer.MAX_VALUE;
        if (sc.getScope().equals("node")) {
            if (checkMinCardinality) {
                minScopeCardinality = tm.getNodeCardinalityByOp(node.getNodeID(), allocationTags, Long::min);
            }
            if (checkMaxCardinality) {
                maxScopeCardinality = tm.getNodeCardinalityByOp(node.getNodeID(), allocationTags, Long::max);
            }
        } else if (sc.getScope().equals("rack")) {
            if (checkMinCardinality) {
                minScopeCardinality = tm.getRackCardinalityByOp(node.getRackName(), allocationTags, Long::min);
            }
            if (checkMaxCardinality) {
                maxScopeCardinality = tm.getRackCardinalityByOp(node.getRackName(), allocationTags, Long::max);
            }
        }
        return !(desiredMinCardinality > 0 && minScopeCardinality < (long)desiredMinCardinality || desiredMaxCardinality != Integer.MAX_VALUE && maxScopeCardinality > (long)desiredMaxCardinality);
    }

    private static boolean canSatisfyNodeConstraintExpression(PlacementConstraint.SingleConstraint sc, PlacementConstraint.TargetExpression targetExpression, SchedulerNode schedulerNode) {
        Set values = targetExpression.getTargetValues();
        if (targetExpression.getTargetKey().equals("yarn_node_partition/")) {
            if (values == null || values.isEmpty()) {
                return schedulerNode.getPartition().equals("");
            }
            String nodePartition = (String)values.iterator().next();
            return nodePartition.equals(schedulerNode.getPartition());
        }
        NodeAttributeOpCode opCode = sc.getNodeAttributeOpCode();
        String inputAttribute = (String)values.iterator().next();
        NodeAttribute requestAttribute = PlacementConstraintsUtil.getNodeConstraintFromRequest(targetExpression.getTargetKey(), inputAttribute);
        if (requestAttribute == null) {
            return true;
        }
        return PlacementConstraintsUtil.getNodeConstraintEvaluatedResult(schedulerNode, opCode, requestAttribute);
    }

    private static boolean getNodeConstraintEvaluatedResult(SchedulerNode schedulerNode, NodeAttributeOpCode opCode, NodeAttribute requestAttribute) {
        if (schedulerNode.getNodeAttributes() == null || !schedulerNode.getNodeAttributes().contains(requestAttribute)) {
            if (opCode == NodeAttributeOpCode.NE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Incoming requestAttribute:" + requestAttribute + "is not present in " + schedulerNode.getNodeID() + ", however opcode is NE. Hence accept this node."));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Incoming requestAttribute:" + requestAttribute + "is not present in " + schedulerNode.getNodeID() + ", skip such node."));
            }
            return false;
        }
        boolean found = false;
        for (NodeAttribute nodeAttribute : schedulerNode.getNodeAttributes()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Starting to compare Incoming requestAttribute :" + requestAttribute + " with requestAttribute value= " + requestAttribute.getAttributeValue() + ", stored nodeAttribute value=" + nodeAttribute.getAttributeValue()));
            }
            if (!requestAttribute.equals(nodeAttribute) || !PlacementConstraintsUtil.isOpCodeMatches(requestAttribute, nodeAttribute, opCode)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Incoming requestAttribute:" + requestAttribute + " matches with node:" + schedulerNode.getNodeID()));
            }
            found = true;
            return found;
        }
        if (!found) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("skip this node:" + schedulerNode.getNodeID() + " for requestAttribute:" + requestAttribute));
            }
            return false;
        }
        return true;
    }

    private static boolean isOpCodeMatches(NodeAttribute requestAttribute, NodeAttribute nodeAttribute, NodeAttributeOpCode opCode) {
        boolean retCode = false;
        switch (opCode) {
            case EQ: {
                retCode = requestAttribute.getAttributeValue().equals(nodeAttribute.getAttributeValue());
                break;
            }
            case NE: {
                retCode = !requestAttribute.getAttributeValue().equals(nodeAttribute.getAttributeValue());
                break;
            }
        }
        return retCode;
    }

    private static boolean canSatisfySingleConstraint(ApplicationId applicationId, PlacementConstraint.SingleConstraint singleConstraint, SchedulerNode schedulerNode, AllocationTagsManager tagsManager) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.TargetExpression currentExp : singleConstraint.getTargetExpressions()) {
            if (!(currentExp.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG) ? !PlacementConstraintsUtil.canSatisfySingleConstraintExpression(applicationId, singleConstraint, currentExp, schedulerNode, tagsManager) : currentExp.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE) && !PlacementConstraintsUtil.canSatisfyNodeConstraintExpression(singleConstraint, currentExp, schedulerNode))) continue;
            return false;
        }
        return true;
    }

    private static boolean canSatisfyAndConstraint(ApplicationId appId, PlacementConstraint.And constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.AbstractConstraint child : constraint.getChildren()) {
            if (PlacementConstraintsUtil.canSatisfyConstraints(appId, child.build(), node, atm)) continue;
            return false;
        }
        return true;
    }

    private static boolean canSatisfyOrConstraint(ApplicationId appId, PlacementConstraint.Or constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.AbstractConstraint child : constraint.getChildren()) {
            if (!PlacementConstraintsUtil.canSatisfyConstraints(appId, child.build(), node, atm)) continue;
            return true;
        }
        return false;
    }

    private static boolean canSatisfyConstraints(ApplicationId appId, PlacementConstraint constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        if (constraint == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Constraint is found empty during constraint validation for app:" + appId));
            }
            return true;
        }
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(constraint);
        PlacementConstraint.AbstractConstraint sConstraintExpr = (constraint = singleTransformer.transform()).getConstraintExpr();
        if (sConstraintExpr instanceof PlacementConstraint.SingleConstraint) {
            PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfySingleConstraint(appId, single, node, atm);
        }
        if (sConstraintExpr instanceof PlacementConstraint.And) {
            PlacementConstraint.And and = (PlacementConstraint.And)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfyAndConstraint(appId, and, node, atm);
        }
        if (sConstraintExpr instanceof PlacementConstraint.Or) {
            PlacementConstraint.Or or = (PlacementConstraint.Or)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfyOrConstraint(appId, or, node, atm);
        }
        throw new InvalidAllocationTagsQueryException("Unsupported type of constraint: " + sConstraintExpr.getClass().getSimpleName());
    }

    public static boolean canSatisfyConstraints(ApplicationId applicationId, SchedulingRequest request, SchedulerNode schedulerNode, PlacementConstraintManager pcm, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        Set sourceTags = null;
        PlacementConstraint pc = null;
        if (request != null) {
            sourceTags = request.getAllocationTags();
            pc = request.getPlacementConstraint();
        }
        return PlacementConstraintsUtil.canSatisfyConstraints(applicationId, pcm.getMultilevelConstraint(applicationId, sourceTags, pc), schedulerNode, atm);
    }

    private static NodeAttribute getNodeConstraintFromRequest(String attrKey, String attrString) {
        String[] name;
        NodeAttribute nodeAttribute = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Incoming node attribute: " + attrKey + "=" + attrString));
        }
        nodeAttribute = (name = attrKey.split("/")) == null || name.length == 1 ? NodeAttribute.newInstance((String)attrKey, (NodeAttributeType)NodeAttributeType.STRING, (String)attrString) : NodeAttribute.newInstance((String)name[0], (String)name[1], (NodeAttributeType)NodeAttributeType.STRING, (String)attrString);
        return nodeAttribute;
    }
}

