/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandlerException;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.UniformInterfaceException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.ws.rs.WebApplicationException;
import org.apache.hadoop.shaded.javax.ws.rs.core.GenericEntity;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.javax.ws.rs.core.StreamingOutput;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.util.YarnWebServiceUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class LogWebServiceUtils {
    private static final Joiner DOT_JOINER = Joiner.on((String)". ");

    private LogWebServiceUtils() {
    }

    public static Response getContainerLogMeta(LogAggregationFileControllerFactory factory, ApplicationId appId, String appOwner, String nodeId, String containerIdStr, boolean emptyLocalContainerLogMeta) {
        try {
            ContainerLogsRequest request = new ContainerLogsRequest();
            request.setAppId(appId);
            request.setAppOwner(appOwner);
            request.setContainerId(containerIdStr);
            request.setNodeId(nodeId);
            List containerLogMeta = factory.getFileControllerForRead(appId, appOwner).readAggregatedLogsMeta(request);
            if (containerLogMeta.isEmpty()) {
                throw new NotFoundException("Can not get log meta for container: " + containerIdStr);
            }
            ArrayList<ContainerLogsInfo> containersLogsInfo = new ArrayList<ContainerLogsInfo>();
            for (ContainerLogMeta meta : containerLogMeta) {
                ContainerLogsInfo logInfo = new ContainerLogsInfo(meta, ContainerLogAggregationType.AGGREGATED);
                containersLogsInfo.add(logInfo);
            }
            if (emptyLocalContainerLogMeta) {
                ContainerLogMeta emptyMeta = new ContainerLogMeta(containerIdStr, "N/A");
                ContainerLogsInfo empty = new ContainerLogsInfo(emptyMeta, ContainerLogAggregationType.LOCAL);
                containersLogsInfo.add(empty);
            }
            GenericEntity<List<ContainerLogsInfo>> meta = new GenericEntity<List<ContainerLogsInfo>>(containersLogsInfo){};
            Response.ResponseBuilder response = Response.ok((Object)meta);
            response.header("X-Content-Type-Options", (Object)"nosniff");
            return response.build();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public static Response sendStreamOutputResponse(LogAggregationFileControllerFactory factory, ApplicationId appId, String appOwner, String nodeId, String containerIdStr, String fileName, String format, long bytes, boolean printEmptyLocalContainerLog) {
        String contentType = WebAppUtils.getDefaultLogContentType();
        if (format != null && !format.isEmpty() && (contentType = WebAppUtils.getSupportedLogContentType((String)format)) == null) {
            String errorMessage = "The valid values for the parameter : format are " + WebAppUtils.listSupportedLogContentType();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        StreamingOutput stream = null;
        try {
            stream = LogWebServiceUtils.getStreamingOutput(factory, appId, appOwner, nodeId, containerIdStr, fileName, bytes, printEmptyLocalContainerLog);
        }
        catch (Exception ex) {
            return LogWebServiceUtils.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
        Response.ResponseBuilder response = Response.ok((Object)stream);
        response.header("Content-Type", (Object)contentType);
        response.header("X-Content-Type-Options", (Object)"nosniff");
        return response.build();
    }

    private static StreamingOutput getStreamingOutput(final LogAggregationFileControllerFactory factory, final ApplicationId appId, final String appOwner, final String nodeId, final String containerIdStr, final String logFile, final long bytes, final boolean printEmptyLocalContainerLog) throws IOException {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                ContainerLogsRequest request = new ContainerLogsRequest();
                request.setAppId(appId);
                request.setAppOwner(appOwner);
                request.setContainerId(containerIdStr);
                request.setBytes(bytes);
                request.setNodeId(nodeId);
                HashSet<String> logTypes = new HashSet<String>();
                logTypes.add(logFile);
                request.setLogTypes(logTypes);
                boolean findLogs = factory.getFileControllerForRead(appId, appOwner).readAggregatedLogs(request, os);
                if (!findLogs) {
                    os.write(("Can not find logs for container:" + containerIdStr).getBytes(Charset.forName("UTF-8")));
                } else if (printEmptyLocalContainerLog) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(containerIdStr + "\n");
                    sb.append("LogAggregationType: " + ContainerLogAggregationType.LOCAL + "\n");
                    sb.append("LogContents:\n");
                    sb.append(LogWebServiceUtils.getNoRedirectWarning() + "\n");
                    os.write(sb.toString().getBytes(Charset.forName("UTF-8")));
                }
            }
        };
        return stream;
    }

    public static String getNoRedirectWarning() {
        return "We do not have NodeManager web address, so we can not re-direct the request to related NodeManager for local container logs.";
    }

    public static void rewrapAndThrowException(Exception e) {
        if (e instanceof UndeclaredThrowableException) {
            LogWebServiceUtils.rewrapAndThrowThrowable(e.getCause());
        } else {
            LogWebServiceUtils.rewrapAndThrowThrowable(e);
        }
    }

    public static void rewrapAndThrowThrowable(Throwable t) {
        if (t instanceof AuthorizationException) {
            throw new ForbiddenException(t);
        }
        throw new WebApplicationException(t);
    }

    public static long parseLongParam(String bytes) {
        if (bytes == null || bytes.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(bytes);
    }

    public static Response createBadResponse(Response.Status status, String errMessage) {
        Response response = Response.status((Response.Status)status).entity((Object)DOT_JOINER.join((Object)status.toString(), (Object)errMessage, new Object[0])).build();
        return response;
    }

    public static boolean isRunningState(YarnApplicationState appState) {
        return appState == YarnApplicationState.RUNNING;
    }

    public static boolean isFinishedState(YarnApplicationState appState) {
        return appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.FAILED || appState == YarnApplicationState.KILLED;
    }

    protected static UserGroupInformation getUser(HttpServletRequest req) {
        String remoteUser = req.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }

    public static String getNMWebAddressFromRM(Configuration yarnConf, String nodeId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        JSONObject nodeInfo = YarnWebServiceUtils.getNodeInfoFromRMWebService((Configuration)yarnConf, (String)nodeId).getJSONObject("node");
        return nodeInfo.has("nodeHTTPAddress") ? nodeInfo.getString("nodeHTTPAddress") : null;
    }

    public static String getAbsoluteNMWebAddress(Configuration yarnConf, String nmWebAddress) {
        if (nmWebAddress.contains("http://") || nmWebAddress.contains("https://")) {
            return nmWebAddress;
        }
        return WebAppUtils.getHttpSchemePrefix((Configuration)yarnConf) + nmWebAddress;
    }
}

