/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.DecayRpcScheduler;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDecayRpcScheduler {
    private DecayRpcScheduler scheduler;

    private Schedulable mockCall(String id) {
        Schedulable mockCall = (Schedulable)Mockito.mock(Schedulable.class);
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)id);
        Mockito.when((Object)mockCall.getUserGroupInformation()).thenReturn((Object)ugi);
        return mockCall;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeScheduler() {
        this.scheduler = new DecayRpcScheduler(-1, "", new Configuration());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroScheduler() {
        this.scheduler = new DecayRpcScheduler(0, "", new Configuration());
    }

    @Test
    public void testParsePeriod() {
        this.scheduler = new DecayRpcScheduler(1, "", new Configuration());
        Assert.assertEquals((long)5000L, (long)this.scheduler.getDecayPeriodMillis());
        Configuration conf = new Configuration();
        conf.setLong("ns.faircallqueue.decay-scheduler.period-ms", 1058L);
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)1058L, (long)this.scheduler.getDecayPeriodMillis());
    }

    @Test
    public void testParseFactor() {
        this.scheduler = new DecayRpcScheduler(1, "", new Configuration());
        Assert.assertEquals((double)0.5, (double)this.scheduler.getDecayFactor(), (double)1.0E-5);
        Configuration conf = new Configuration();
        conf.set("prefix.faircallqueue.decay-scheduler.decay-factor", "0.125");
        this.scheduler = new DecayRpcScheduler(1, "prefix", conf);
        Assert.assertEquals((double)0.125, (double)this.scheduler.getDecayFactor(), (double)1.0E-5);
    }

    public void assertEqualDecimalArrays(double[] a, double[] b) {
        Assert.assertEquals((long)a.length, (long)b.length);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((double)a[i], (double)b[i], (double)1.0E-5);
        }
    }

    @Test
    public void testParseThresholds() {
        Configuration conf = new Configuration();
        this.scheduler = new DecayRpcScheduler(1, "", conf);
        this.assertEqualDecimalArrays(new double[0], this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(2, "", conf);
        this.assertEqualDecimalArrays(new double[]{0.5}, this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(3, "", conf);
        this.assertEqualDecimalArrays(new double[]{0.25, 0.5}, this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(4, "", conf);
        this.assertEqualDecimalArrays(new double[]{0.125, 0.25, 0.5}, this.scheduler.getThresholds());
        conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.thresholds", "1, 10, 20, 50, 85");
        this.scheduler = new DecayRpcScheduler(6, "ns", conf);
        this.assertEqualDecimalArrays(new double[]{0.01, 0.1, 0.2, 0.5, 0.85}, this.scheduler.getThresholds());
    }

    @Test
    public void testAccumulate() {
        Configuration conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.period-ms", "99999999");
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)0L, (long)this.scheduler.getCallCountSnapshot().size());
        this.scheduler.getPriorityLevel(this.mockCall("A"));
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCountSnapshot().get("A")));
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCountSnapshot().get("A")));
        this.scheduler.getPriorityLevel(this.mockCall("A"));
        this.scheduler.getPriorityLevel(this.mockCall("B"));
        this.scheduler.getPriorityLevel(this.mockCall("A"));
        Assert.assertEquals((long)3L, (long)((Long)this.scheduler.getCallCountSnapshot().get("A")));
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCountSnapshot().get("B")));
    }

    @Test
    public void testDecay() {
        int i;
        Configuration conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.period-ms", "999999999");
        conf.set("ns.faircallqueue.decay-scheduler.decay-factor", "0.5");
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        for (i = 0; i < 4; ++i) {
            this.scheduler.getPriorityLevel(this.mockCall("A"));
        }
        for (i = 0; i < 8; ++i) {
            this.scheduler.getPriorityLevel(this.mockCall("B"));
        }
        Assert.assertEquals((long)12L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals((long)4L, (long)((Long)this.scheduler.getCallCountSnapshot().get("A")));
        Assert.assertEquals((long)8L, (long)((Long)this.scheduler.getCallCountSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)6L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals((long)2L, (long)((Long)this.scheduler.getCallCountSnapshot().get("A")));
        Assert.assertEquals((long)4L, (long)((Long)this.scheduler.getCallCountSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)3L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCountSnapshot().get("A")));
        Assert.assertEquals((long)2L, (long)((Long)this.scheduler.getCallCountSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals(null, this.scheduler.getCallCountSnapshot().get("A"));
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCountSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals(null, this.scheduler.getCallCountSnapshot().get("A"));
        Assert.assertEquals(null, this.scheduler.getCallCountSnapshot().get("B"));
    }

    @Test
    public void testPriority() {
        Configuration conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.period-ms", "99999999");
        conf.set("ns.faircallqueue.decay-scheduler.thresholds", "25, 50, 75");
        this.scheduler = new DecayRpcScheduler(4, "ns", conf);
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("A")));
        Assert.assertEquals((long)2L, (long)this.scheduler.getPriorityLevel(this.mockCall("A")));
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("B")));
        Assert.assertEquals((long)1L, (long)this.scheduler.getPriorityLevel(this.mockCall("B")));
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("C")));
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("C")));
        Assert.assertEquals((long)1L, (long)this.scheduler.getPriorityLevel(this.mockCall("A")));
        Assert.assertEquals((long)1L, (long)this.scheduler.getPriorityLevel(this.mockCall("A")));
        Assert.assertEquals((long)1L, (long)this.scheduler.getPriorityLevel(this.mockCall("A")));
        Assert.assertEquals((long)2L, (long)this.scheduler.getPriorityLevel(this.mockCall("A")));
    }

    @Test(timeout=2000L)
    public void testPeriodic() throws InterruptedException {
        Configuration conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.period-ms", "10");
        conf.set("ns.faircallqueue.decay-scheduler.decay-factor", "0.5");
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)10L, (long)this.scheduler.getDecayPeriodMillis());
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        for (int i = 0; i < 64; ++i) {
            this.scheduler.getPriorityLevel(this.mockCall("A"));
        }
        while (this.scheduler.getTotalCallSnapshot() > 0L) {
            Thread.sleep(10L);
        }
    }
}

