/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.NativeLibraryChecker;
import org.apache.hadoop.util.Shell;
import org.junit.Test;

public class TestNativeLibraryChecker
extends TestCase {
    private void expectExit(String[] args) {
        try {
            NativeLibraryChecker.main((String[])args);
            TestNativeLibraryChecker.fail((String)"should call exit");
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.resetFirstExitException();
        }
    }

    @Test
    public void testNativeLibraryChecker() {
        ExitUtil.disableSystemExit();
        NativeLibraryChecker.main((String[])new String[]{"-h"});
        this.expectExit(new String[]{"-a", "-h"});
        this.expectExit(new String[]{"aaa"});
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            NativeLibraryChecker.main((String[])new String[0]);
        } else {
            this.expectExit(new String[0]);
        }
    }

    @Test
    public void testNativeLibraryCheckerOutput() {
        this.expectOutput(new String[]{"-a"});
        this.expectOutput(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expectOutput(String[] args) {
        PrintStream originalPs;
        ByteArrayOutputStream outContent;
        block8: {
            ExitUtil.disableSystemExit();
            outContent = new ByteArrayOutputStream();
            originalPs = System.out;
            System.setOut(new PrintStream(outContent));
            try {
                NativeLibraryChecker.main((String[])args);
                if (!Shell.WINDOWS) break block8;
                TestNativeLibraryChecker.assertEquals((outContent.toString().indexOf("winutils: true") != -1 ? 1 : 0) != 0, (boolean)true);
            }
            catch (ExitUtil.ExitException e) {
                block9: {
                    try {
                        ExitUtil.resetFirstExitException();
                        if (!Shell.WINDOWS) break block9;
                        TestNativeLibraryChecker.assertEquals((outContent.toString().indexOf("winutils: true") != -1 ? 1 : 0) != 0, (boolean)true);
                    }
                    catch (Throwable throwable) {
                        if (Shell.WINDOWS) {
                            TestNativeLibraryChecker.assertEquals((outContent.toString().indexOf("winutils: true") != -1 ? 1 : 0) != 0, (boolean)true);
                        }
                        if (NativeCodeLoader.isNativeCodeLoaded()) {
                            TestNativeLibraryChecker.assertEquals((outContent.toString().indexOf("hadoop:  true") != -1 ? 1 : 0) != 0, (boolean)true);
                        }
                        System.setOut(originalPs);
                        throw throwable;
                    }
                }
                if (NativeCodeLoader.isNativeCodeLoaded()) {
                    TestNativeLibraryChecker.assertEquals((outContent.toString().indexOf("hadoop:  true") != -1 ? 1 : 0) != 0, (boolean)true);
                }
                System.setOut(originalPs);
            }
        }
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            TestNativeLibraryChecker.assertEquals((outContent.toString().indexOf("hadoop:  true") != -1 ? 1 : 0) != 0, (boolean)true);
        }
        System.setOut(originalPs);
    }
}

