/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class LocalDirAllocator {
    private static Map<String, AllocatorPerContext> contexts = new TreeMap<String, AllocatorPerContext>();
    private String contextCfgItemName;
    public static final int SIZE_UNKNOWN = -1;

    public LocalDirAllocator(String contextCfgItemName) {
        this.contextCfgItemName = contextCfgItemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocatorPerContext obtainContext(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            AllocatorPerContext l = contexts.get(contextCfgItemName);
            if (l == null) {
                l = new AllocatorPerContext(contextCfgItemName);
                contexts.put(contextCfgItemName, l);
            }
            return l;
        }
    }

    public Path getLocalPathForWrite(String pathStr, Configuration conf) throws IOException {
        return this.getLocalPathForWrite(pathStr, -1L, conf);
    }

    public Path getLocalPathForWrite(String pathStr, long size, Configuration conf) throws IOException {
        return this.getLocalPathForWrite(pathStr, size, conf, true);
    }

    public Path getLocalPathForWrite(String pathStr, long size, Configuration conf, boolean checkWrite) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathForWrite(pathStr, size, conf, checkWrite);
    }

    public Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathToRead(pathStr, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Path> getAllLocalPathsToRead(String pathStr, Configuration conf) throws IOException {
        AllocatorPerContext context;
        LocalDirAllocator localDirAllocator = this;
        synchronized (localDirAllocator) {
            context = this.obtainContext(this.contextCfgItemName);
        }
        return context.getAllLocalPathsToRead(pathStr, conf);
    }

    public File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.createTmpFileForWrite(pathStr, size, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContextValid(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            return contexts.containsKey(contextCfgItemName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @InterfaceAudience.LimitedPrivate(value={"MapReduce"})
    public static void removeContext(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            contexts.remove(contextCfgItemName);
        }
    }

    public boolean ifExists(String pathStr, Configuration conf) {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.ifExists(pathStr, conf);
    }

    int getCurrentDirectoryIndex() {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getCurrentDirectoryIndex();
    }

    private static class AllocatorPerContext {
        private final Log LOG = LogFactory.getLog(AllocatorPerContext.class);
        private int dirNumLastAccessed;
        private Random dirIndexRandomizer = new Random();
        private FileSystem localFS;
        private DF[] dirDF;
        private String contextCfgItemName;
        private String[] localDirs;
        private String savedLocalDirs = "";

        public AllocatorPerContext(String contextCfgItemName) {
            this.contextCfgItemName = contextCfgItemName;
        }

        private synchronized void confChanged(Configuration conf) throws IOException {
            String newLocalDirs = conf.get(this.contextCfgItemName);
            if (!newLocalDirs.equals(this.savedLocalDirs)) {
                this.localDirs = StringUtils.getTrimmedStrings(newLocalDirs);
                this.localFS = FileSystem.getLocal(conf);
                int numDirs = this.localDirs.length;
                ArrayList<String> dirs = new ArrayList<String>(numDirs);
                ArrayList<DF> dfList = new ArrayList<DF>(numDirs);
                for (int i = 0; i < numDirs; ++i) {
                    try {
                        Path tmpDir = new Path(this.localDirs[i]);
                        if (this.localFS.mkdirs(tmpDir) || this.localFS.exists(tmpDir)) {
                            try {
                                File tmpFile = tmpDir.isAbsolute() ? new File(this.localFS.makeQualified(tmpDir).toUri()) : new File(this.localDirs[i]);
                                DiskChecker.checkDir(tmpFile);
                                dirs.add(tmpFile.getPath());
                                dfList.add(new DF(tmpFile, 30000L));
                            }
                            catch (DiskChecker.DiskErrorException de) {
                                this.LOG.warn((Object)(this.localDirs[i] + " is not writable\n"), (Throwable)de);
                            }
                            continue;
                        }
                        this.LOG.warn((Object)("Failed to create " + this.localDirs[i]));
                        continue;
                    }
                    catch (IOException ie) {
                        this.LOG.warn((Object)("Failed to create " + this.localDirs[i] + ": " + ie.getMessage() + "\n"), (Throwable)ie);
                    }
                }
                this.localDirs = dirs.toArray(new String[dirs.size()]);
                this.dirDF = dfList.toArray(new DF[dirs.size()]);
                this.savedLocalDirs = newLocalDirs;
                this.dirNumLastAccessed = this.dirIndexRandomizer.nextInt(dirs.size());
            }
        }

        private Path createPath(String path, boolean checkWrite) throws IOException {
            Path file = new Path(new Path(this.localDirs[this.dirNumLastAccessed]), path);
            if (checkWrite) {
                try {
                    DiskChecker.checkDir(new File(file.getParent().toUri().getPath()));
                    return file;
                }
                catch (DiskChecker.DiskErrorException d) {
                    this.LOG.warn((Object)"Disk Error Exception: ", (Throwable)d);
                    return null;
                }
            }
            return file;
        }

        int getCurrentDirectoryIndex() {
            return this.dirNumLastAccessed;
        }

        public synchronized Path getLocalPathForWrite(String pathStr, long size, Configuration conf, boolean checkWrite) throws IOException {
            this.confChanged(conf);
            int numDirs = this.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            Path returnPath = null;
            if (size == -1L) {
                long[] availableOnDisk = new long[this.dirDF.length];
                long totalAvailable = 0L;
                for (int i = 0; i < this.dirDF.length; ++i) {
                    availableOnDisk[i] = this.dirDF[i].getAvailable();
                    totalAvailable += availableOnDisk[i];
                }
                if (totalAvailable == 0L) {
                    throw new DiskChecker.DiskErrorException("No space available in any of the local directories.");
                }
                Random r = new Random();
                while (numDirsSearched < numDirs && returnPath == null) {
                    long randomPosition = (r.nextLong() >>> 1) % totalAvailable;
                    int dir = 0;
                    while (randomPosition > availableOnDisk[dir]) {
                        randomPosition -= availableOnDisk[dir];
                        ++dir;
                    }
                    this.dirNumLastAccessed = dir;
                    returnPath = this.createPath(pathStr, checkWrite);
                    if (returnPath != null) continue;
                    totalAvailable -= availableOnDisk[dir];
                    availableOnDisk[dir] = 0L;
                    ++numDirsSearched;
                }
            } else {
                while (numDirsSearched < numDirs && returnPath == null) {
                    long capacity = this.dirDF[this.dirNumLastAccessed].getAvailable();
                    if (capacity > size) {
                        returnPath = this.createPath(pathStr, checkWrite);
                    }
                    ++this.dirNumLastAccessed;
                    this.dirNumLastAccessed %= numDirs;
                    ++numDirsSearched;
                }
            }
            if (returnPath != null) {
                return returnPath;
            }
            throw new DiskChecker.DiskErrorException("Could not find any valid local directory for " + pathStr);
        }

        public File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
            Path path = this.getLocalPathForWrite(pathStr, size, conf, true);
            File dir = new File(path.getParent().toUri().getPath());
            String prefix = path.getName();
            File result = File.createTempFile(prefix, null, dir);
            result.deleteOnExit();
            return result;
        }

        public synchronized Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
            this.confChanged(conf);
            int numDirs = this.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            while (numDirsSearched < numDirs) {
                Path file = new Path(this.localDirs[numDirsSearched], pathStr);
                if (this.localFS.exists(file)) {
                    return file;
                }
                ++numDirsSearched;
            }
            throw new DiskChecker.DiskErrorException("Could not find " + pathStr + " in any of the configured local directories");
        }

        synchronized Iterable<Path> getAllLocalPathsToRead(String pathStr, Configuration conf) throws IOException {
            this.confChanged(conf);
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            return new PathIterator(this.localFS, pathStr, this.localDirs);
        }

        public synchronized boolean ifExists(String pathStr, Configuration conf) {
            try {
                int numDirs = this.localDirs.length;
                int numDirsSearched = 0;
                if (pathStr.startsWith("/")) {
                    pathStr = pathStr.substring(1);
                }
                while (numDirsSearched < numDirs) {
                    Path file = new Path(this.localDirs[numDirsSearched], pathStr);
                    if (this.localFS.exists(file)) {
                        return true;
                    }
                    ++numDirsSearched;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private static class PathIterator
        implements Iterator<Path>,
        Iterable<Path> {
            private final FileSystem fs;
            private final String pathStr;
            private int i = 0;
            private final String[] rootDirs;
            private Path next = null;

            private PathIterator(FileSystem fs, String pathStr, String[] rootDirs) throws IOException {
                this.fs = fs;
                this.pathStr = pathStr;
                this.rootDirs = rootDirs;
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            private void advance() throws IOException {
                while (this.i < this.rootDirs.length) {
                    this.next = new Path(this.rootDirs[this.i++], this.pathStr);
                    if (!this.fs.exists(this.next)) continue;
                    return;
                }
                this.next = null;
            }

            @Override
            public Path next() {
                Path result = this.next;
                try {
                    this.advance();
                }
                catch (IOException ie) {
                    throw new RuntimeException("Can't check existance of " + this.next, ie);
                }
                if (result == null) {
                    throw new NoSuchElementException();
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read only iterator");
            }

            @Override
            public Iterator<Path> iterator() {
                return this;
            }
        }
    }
}

