/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.ClassLoaderCheckMain;
import org.apache.hadoop.util.ClassLoaderCheckThird;
import org.apache.hadoop.util.RunJar;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRunJar
extends TestCase {
    private File TEST_ROOT_DIR;
    private static final String TEST_JAR_NAME = "test-runjar.jar";
    private static final String TEST_JAR_2_NAME = "test-runjar2.jar";

    @Before
    protected void setUp() throws Exception {
        this.TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp"), ((Object)((Object)this)).getClass().getSimpleName());
        if (!this.TEST_ROOT_DIR.exists()) {
            this.TEST_ROOT_DIR.mkdirs();
        }
        this.makeTestJar();
    }

    @After
    protected void tearDown() {
        FileUtil.fullyDelete((File)this.TEST_ROOT_DIR);
    }

    private void makeTestJar() throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        jstream.putNextEntry(new ZipEntry("foobar.txt"));
        jstream.closeEntry();
        jstream.putNextEntry(new ZipEntry("foobaz.txt"));
        jstream.closeEntry();
        jstream.close();
    }

    @Test
    public void testUnJar() throws Exception {
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-all");
        TestRunJar.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, "foobar.txt").exists());
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir);
        TestRunJar.assertTrue((String)"foobar unpacked", (boolean)new File(unjarDir, "foobar.txt").exists());
        TestRunJar.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, "foobaz.txt").exists());
    }

    public void testUnJarWithPattern() throws Exception {
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-pattern");
        TestRunJar.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, "foobar.txt").exists());
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir, (Pattern)Pattern.compile(".*baz.*"));
        TestRunJar.assertFalse((String)"foobar not unpacked", (boolean)new File(unjarDir, "foobar.txt").exists());
        TestRunJar.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, "foobaz.txt").exists());
    }

    @Test
    public void testClientClassLoader() throws Throwable {
        RunJar runJar = (RunJar)Mockito.spy((Object)new RunJar());
        Mockito.when((Object)runJar.useClientClassLoader()).thenReturn((Object)true);
        String mainCls = ClassLoaderCheckMain.class.getName();
        String thirdCls = ClassLoaderCheckThird.class.getName();
        String systemClasses = "-" + mainCls + ",-" + thirdCls + "," + ApplicationClassLoader.SYSTEM_CLASSES_DEFAULT;
        Mockito.when((Object)runJar.getSystemClasses()).thenReturn((Object)systemClasses);
        File testJar = this.makeClassLoaderTestJar(mainCls, thirdCls);
        String[] args = new String[3];
        args[0] = testJar.getAbsolutePath();
        args[1] = mainCls;
        runJar.run(args);
    }

    private File makeClassLoaderTestJar(String ... clsNames) throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_2_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        for (String clsName : clsNames) {
            int count;
            String name = clsName.replace('.', '/') + ".class";
            InputStream entryInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + name);
            ZipEntry entry = new ZipEntry(name);
            jstream.putNextEntry(entry);
            BufferedInputStream bufInputStream = new BufferedInputStream(entryInputStream, 2048);
            byte[] data = new byte[2048];
            while ((count = bufInputStream.read(data, 0, 2048)) != -1) {
                jstream.write(data, 0, count);
            }
            jstream.closeEntry();
        }
        jstream.close();
        return jarFile;
    }
}

