/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractConcatTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractConcatTest.class);
    private Path testPath;
    private Path srcFile;
    private Path zeroByteFile;
    private Path target;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.skipIfUnsupported("supports-concat");
        this.testPath = this.path("test");
        this.srcFile = new Path(this.testPath, "small.txt");
        this.zeroByteFile = new Path(this.testPath, "zero.txt");
        this.target = new Path(this.testPath, "target");
        byte[] block = ContractTestUtils.dataset(1024, 0, 255);
        ContractTestUtils.createFile(this.getFileSystem(), this.srcFile, false, block);
        ContractTestUtils.touch(this.getFileSystem(), this.zeroByteFile);
    }

    @Test
    public void testConcatEmptyFiles() throws Throwable {
        ContractTestUtils.touch(this.getFileSystem(), this.target);
        try {
            this.getFileSystem().concat(this.target, new Path[0]);
            AbstractContractConcatTest.fail((String)"expected a failure");
        }
        catch (Exception e) {
            this.handleExpectedException(e);
        }
    }

    @Test
    public void testConcatMissingTarget() throws Throwable {
        try {
            this.getFileSystem().concat(this.target, new Path[]{this.zeroByteFile});
            AbstractContractConcatTest.fail((String)"expected a failure");
        }
        catch (Exception e) {
            this.handleExpectedException(e);
        }
    }

    @Test
    public void testConcatFileOnFile() throws Throwable {
        byte[] block = ContractTestUtils.dataset(1024, 0, 255);
        ContractTestUtils.createFile(this.getFileSystem(), this.target, false, block);
        this.getFileSystem().concat(this.target, new Path[]{this.srcFile});
        ContractTestUtils.assertFileHasLength(this.getFileSystem(), this.target, 2048);
        ContractTestUtils.validateFileContent(ContractTestUtils.readDataset(this.getFileSystem(), this.target, 2048), new byte[][]{block, block});
    }

    @Test
    public void testConcatOnSelf() throws Throwable {
        byte[] block = ContractTestUtils.dataset(1024, 0, 255);
        ContractTestUtils.createFile(this.getFileSystem(), this.target, false, block);
        try {
            this.getFileSystem().concat(this.target, new Path[]{this.target});
        }
        catch (Exception e) {
            this.handleExpectedException(e);
        }
    }
}

