/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TrashPolicyDefault
extends TrashPolicy {
    private static final Log LOG = LogFactory.getLog(TrashPolicyDefault.class);
    private static final Path CURRENT = new Path("Current");
    private static final Path TRASH = new Path(".Trash/");
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private static final DateFormat CHECKPOINT = new SimpleDateFormat("yyMMddHHmmss");
    private static final DateFormat OLD_CHECKPOINT = new SimpleDateFormat("yyMMddHHmm");
    private static final int MSECS_PER_MINUTE = 60000;
    private Path current;
    private Path homesParent;
    private long emptierInterval;

    public TrashPolicyDefault() {
    }

    private TrashPolicyDefault(FileSystem fs, Path home, Configuration conf) throws IOException {
        this.initialize(conf, fs, home);
    }

    @Override
    public void initialize(Configuration conf, FileSystem fs, Path home) {
        this.fs = fs;
        this.trash = new Path(home, TRASH);
        this.homesParent = home.getParent();
        this.current = new Path(this.trash, CURRENT);
        this.deletionInterval = (long)(conf.getFloat("fs.trash.interval", 0.0f) * 60000.0f);
        this.emptierInterval = (long)(conf.getFloat("fs.trash.checkpoint.interval", 0.0f) * 60000.0f);
        LOG.info((Object)("Namenode trash configuration: Deletion interval = " + this.deletionInterval / 60000L + " minutes, Emptier interval = " + this.emptierInterval / 60000L + " minutes."));
    }

    private Path makeTrashRelativePath(Path basePath, Path rmFilePath) {
        return Path.mergePaths(basePath, rmFilePath);
    }

    @Override
    public boolean isEnabled() {
        return this.deletionInterval != 0L;
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        if (!this.isEnabled()) {
            return false;
        }
        if (!path.isAbsolute()) {
            path = new Path(this.fs.getWorkingDirectory(), path);
        }
        if (!this.fs.exists(path)) {
            throw new FileNotFoundException(path.toString());
        }
        String qpath = this.fs.makeQualified(path).toString();
        if (qpath.startsWith(this.trash.toString())) {
            return false;
        }
        if (this.trash.getParent().toString().startsWith(qpath)) {
            throw new IOException("Cannot move \"" + path + "\" to the trash, as it contains the trash");
        }
        Path trashPath = this.makeTrashRelativePath(this.current, path);
        Path baseTrashPath = this.makeTrashRelativePath(this.current, path.getParent());
        IOException cause = null;
        for (int i = 0; i < 2; ++i) {
            try {
                if (!this.fs.mkdirs(baseTrashPath, PERMISSION)) {
                    LOG.warn((Object)("Can't create(mkdir) trash directory: " + baseTrashPath));
                    return false;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Can't create trash directory: " + baseTrashPath), (Throwable)e);
                cause = e;
                break;
            }
            try {
                String orig = trashPath.toString();
                while (this.fs.exists(trashPath)) {
                    trashPath = new Path(orig + Time.now());
                }
                this.fs.rename(path, trashPath, Options.Rename.TO_TRASH);
                LOG.info((Object)("Moved: '" + path + "' to trash at: " + trashPath));
                return true;
            }
            catch (IOException e) {
                cause = e;
                continue;
            }
        }
        throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCheckpoint() throws IOException {
        Path checkpointBase;
        if (!this.fs.exists(this.current)) {
            return;
        }
        DateFormat dateFormat = CHECKPOINT;
        synchronized (dateFormat) {
            checkpointBase = new Path(this.trash, CHECKPOINT.format(new Date()));
        }
        Path checkpoint = checkpointBase;
        int attempt = 0;
        while (true) {
            try {
                this.fs.rename(this.current, checkpoint, Options.Rename.NONE);
            }
            catch (FileAlreadyExistsException e) {
                if (++attempt > 1000) {
                    throw new IOException("Failed to checkpoint trash: " + checkpoint);
                }
                checkpoint = checkpointBase.suffix("-" + attempt);
                continue;
            }
            break;
        }
        LOG.info((Object)("Created trash checkpoint: " + checkpoint.toUri().getPath()));
    }

    @Override
    public void deleteCheckpoint() throws IOException {
        FileStatus[] dirs = null;
        try {
            dirs = this.fs.listStatus(this.trash);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        long now = Time.now();
        for (int i = 0; i < dirs.length; ++i) {
            long time;
            Path path = dirs[i].getPath();
            String dir = path.toUri().getPath();
            String name = path.getName();
            if (name.equals(CURRENT.getName())) continue;
            try {
                time = this.getTimeFromCheckpoint(name);
            }
            catch (ParseException e) {
                LOG.warn((Object)("Unexpected item in trash: " + dir + ". Ignoring."));
                continue;
            }
            if (now - this.deletionInterval <= time) continue;
            if (this.fs.delete(path, true)) {
                LOG.info((Object)("Deleted trash checkpoint: " + dir));
                continue;
            }
            LOG.warn((Object)("Couldn't delete checkpoint: " + dir + " Ignoring."));
        }
    }

    @Override
    public Path getCurrentTrashDir() {
        return this.current;
    }

    @Override
    public Runnable getEmptier() throws IOException {
        return new Emptier(this.getConf(), this.emptierInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeFromCheckpoint(String name) throws ParseException {
        long time;
        try {
            DateFormat dateFormat = CHECKPOINT;
            synchronized (dateFormat) {
                time = CHECKPOINT.parse(name).getTime();
            }
        }
        catch (ParseException pe) {
            DateFormat dateFormat = OLD_CHECKPOINT;
            synchronized (dateFormat) {
                time = OLD_CHECKPOINT.parse(name).getTime();
            }
        }
        return time;
    }

    private class Emptier
    implements Runnable {
        private Configuration conf;
        private long emptierInterval;

        Emptier(Configuration conf, long emptierInterval) throws IOException {
            this.conf = conf;
            this.emptierInterval = emptierInterval;
            if (emptierInterval > TrashPolicyDefault.this.deletionInterval || emptierInterval == 0L) {
                LOG.info((Object)("The configured checkpoint interval is " + emptierInterval / 60000L + " minutes. Using an interval of " + TrashPolicyDefault.this.deletionInterval / 60000L + " minutes that is used for deletion instead"));
                this.emptierInterval = TrashPolicyDefault.this.deletionInterval;
            }
        }

        @Override
        public void run() {
            if (this.emptierInterval == 0L) {
                return;
            }
            long now = Time.now();
            block10: while (true) {
                long end = this.ceiling(now, this.emptierInterval);
                try {
                    Thread.sleep(end - now);
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    now = Time.now();
                    if (now < end) continue;
                    FileStatus[] homes = null;
                    try {
                        homes = TrashPolicyDefault.this.fs.listStatus(TrashPolicyDefault.this.homesParent);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Trash can't list homes: " + e + " Sleeping."));
                        continue;
                    }
                    FileStatus[] fileStatusArray = homes;
                    int n = fileStatusArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block10;
                        FileStatus home = fileStatusArray[n2];
                        if (home.isDirectory()) {
                            try {
                                TrashPolicyDefault trash = new TrashPolicyDefault(TrashPolicyDefault.this.fs, home.getPath(), this.conf);
                                trash.deleteCheckpoint();
                                trash.createCheckpoint();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Trash caught: " + e + ". Skipping " + home.getPath() + "."));
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"RuntimeException during Trash.Emptier.run(): ", (Throwable)e);
                    continue;
                }
                break;
            }
            try {
                TrashPolicyDefault.this.fs.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Trash cannot close FileSystem: ", (Throwable)e);
            }
        }

        private long ceiling(long time, long interval) {
            return this.floor(time, interval) + interval;
        }

        private long floor(long time, long interval) {
            return time / interval * interval;
        }
    }
}

