/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputOutputStream;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ClientCache;
import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.ipc.RpcNoSuchProtocolException;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.protobuf.ProtobufRpcEngineProtos;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ProtoUtil;
import org.apache.hadoop.util.Time;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

@InterfaceStability.Evolving
public class ProtobufRpcEngine
implements RpcEngine {
    public static final Log LOG = LogFactory.getLog(ProtobufRpcEngine.class);
    private static final ClientCache CLIENTS;

    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, null);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy) throws IOException {
        return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, null);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Invoker invoker = new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, fallbackToSimpleAuth);
        return new ProtocolProxy<Object>(protocol, Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)invoker), false);
    }

    @Override
    public ProtocolProxy<ProtocolMetaInfoPB> getProtocolMetaInfoProxy(Client.ConnectionId connId, Configuration conf, SocketFactory factory) throws IOException {
        Class<ProtocolMetaInfoPB> protocol = ProtocolMetaInfoPB.class;
        return new ProtocolProxy<ProtocolMetaInfoPB>(protocol, (ProtocolMetaInfoPB)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, connId, conf, factory)), false);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    static Client getClient(Configuration conf) {
        return CLIENTS.getClient(conf, SocketFactory.getDefault(), RpcResponseWrapper.class);
    }

    @Override
    public RPC.Server getServer(Class<?> protocol, Object protocolImpl, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
        return new Server(protocol, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, portRangeConfig);
    }

    static {
        org.apache.hadoop.ipc.Server.registerProtocolEngine(RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcRequestWrapper.class, new Server.ProtoBufRpcInvoker());
        CLIENTS = new ClientCache();
    }

    public static class Server
    extends RPC.Server {
        public Server(Class<?> protocolClass, Object protocolImpl, Configuration conf, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
            super(bindAddress, port, null, numHandlers, numReaders, queueSizePerHandler, conf, Server.classNameBase(protocolImpl.getClass().getName()), secretManager, portRangeConfig);
            this.verbose = verbose;
            this.registerProtocolAndImpl(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocolClass, protocolImpl);
        }

        static class ProtoBufRpcInvoker
        implements RPC.RpcInvoker {
            ProtoBufRpcInvoker() {
            }

            private static RPC.Server.ProtoClassProtoImpl getProtocolImpl(RPC.Server server, String protoName, long clientVersion) throws RpcServerException {
                RPC.Server.ProtoNameVer pv = new RPC.Server.ProtoNameVer(protoName, clientVersion);
                RPC.Server.ProtoClassProtoImpl impl = server.getProtocolImplMap(RPC.RpcKind.RPC_PROTOCOL_BUFFER).get(pv);
                if (impl == null) {
                    RPC.Server.VerProtocolImpl highest = server.getHighestSupportedProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protoName);
                    if (highest == null) {
                        throw new RpcNoSuchProtocolException("Unknown protocol: " + protoName);
                    }
                    throw new RPC.VersionMismatch(protoName, clientVersion, highest.version);
                }
                return impl;
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Writable call(RPC.Server server, String protocol, Writable writableRequest, long receiveTime) throws Exception {
                Message result;
                RpcRequestWrapper request = (RpcRequestWrapper)writableRequest;
                ProtobufRpcEngineProtos.RequestHeaderProto rpcRequest = (ProtobufRpcEngineProtos.RequestHeaderProto)request.requestHeader;
                String methodName = rpcRequest.getMethodName();
                String protoName = rpcRequest.getDeclaringClassProtocolName();
                long clientVersion = rpcRequest.getClientProtocolVersion();
                if (server.verbose) {
                    org.apache.hadoop.ipc.Server.LOG.info((Object)("Call: protocol=" + protocol + ", method=" + methodName));
                }
                RPC.Server.ProtoClassProtoImpl protocolImpl = ProtoBufRpcInvoker.getProtocolImpl(server, protoName, clientVersion);
                BlockingService service = (BlockingService)protocolImpl.protocolImpl;
                Descriptors.MethodDescriptor methodDescriptor = service.getDescriptorForType().findMethodByName(methodName);
                if (methodDescriptor == null) {
                    String msg = "Unknown method " + methodName + " called on " + protocol + " protocol.";
                    org.apache.hadoop.ipc.Server.LOG.warn((Object)msg);
                    throw new RpcNoSuchMethodException(msg);
                }
                Message prototype = service.getRequestPrototype(methodDescriptor);
                Message param = prototype.newBuilderForType().mergeFrom(request.theRequestRead).build();
                long startTime = Time.now();
                int qTime = (int)(startTime - receiveTime);
                Exception exception = null;
                try {
                    server.rpcDetailedMetrics.init(protocolImpl.protocolClass);
                    result = service.callBlockingMethod(methodDescriptor, null, param);
                }
                catch (ServiceException e) {
                    try {
                        exception = (Exception)e.getCause();
                        throw (Exception)e.getCause();
                        catch (Exception e2) {
                            exception = e2;
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        int processingTime = (int)(Time.now() - startTime);
                        if (org.apache.hadoop.ipc.Server.LOG.isDebugEnabled()) {
                            String msg = "Served: " + methodName + " queueTime= " + qTime + " procesingTime= " + processingTime;
                            if (exception != null) {
                                msg = msg + " exception= " + exception.getClass().getSimpleName();
                            }
                            org.apache.hadoop.ipc.Server.LOG.debug((Object)msg);
                        }
                        String detailedMetricsName = exception == null ? methodName : exception.getClass().getSimpleName();
                        server.rpcMetrics.addRpcQueueTime(qTime);
                        server.rpcMetrics.addRpcProcessingTime(processingTime);
                        server.rpcDetailedMetrics.addProcessingTime(detailedMetricsName, processingTime);
                        if (!server.isLogSlowRPC()) throw throwable;
                        server.logSlowRpcCalls(methodName, processingTime);
                        throw throwable;
                    }
                }
                int processingTime = (int)(Time.now() - startTime);
                if (org.apache.hadoop.ipc.Server.LOG.isDebugEnabled()) {
                    String msg = "Served: " + methodName + " queueTime= " + qTime + " procesingTime= " + processingTime;
                    if (exception != null) {
                        msg = msg + " exception= " + exception.getClass().getSimpleName();
                    }
                    org.apache.hadoop.ipc.Server.LOG.debug((Object)msg);
                }
                String detailedMetricsName = exception == null ? methodName : exception.getClass().getSimpleName();
                server.rpcMetrics.addRpcQueueTime(qTime);
                server.rpcMetrics.addRpcProcessingTime(processingTime);
                server.rpcDetailedMetrics.addProcessingTime(detailedMetricsName, processingTime);
                if (!server.isLogSlowRPC()) return new RpcResponseWrapper(result);
                server.logSlowRpcCalls(methodName, processingTime);
                return new RpcResponseWrapper(result);
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"RPC"})
    public static class RpcResponseWrapper
    implements RpcWrapper {
        Message theResponse;
        byte[] theResponseRead;

        public RpcResponseWrapper() {
        }

        public RpcResponseWrapper(Message message) {
            this.theResponse = message;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            OutputStream os = DataOutputOutputStream.constructOutputStream(out);
            this.theResponse.writeDelimitedTo(os);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            int length = ProtoUtil.readRawVarint32(in);
            this.theResponseRead = new byte[length];
            in.readFully(this.theResponseRead);
        }

        @Override
        public int getLength() {
            int resLen;
            if (this.theResponse != null) {
                resLen = this.theResponse.getSerializedSize();
            } else if (this.theResponseRead != null) {
                resLen = this.theResponseRead.length;
            } else {
                throw new IllegalArgumentException("getLength on uninitialized RpcWrapper");
            }
            return CodedOutputStream.computeRawVarint32Size((int)resLen) + resLen;
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"RPC"})
    public static class RpcResponseMessageWrapper
    extends RpcMessageWithHeader<RpcHeaderProtos.RpcResponseHeaderProto> {
        public RpcResponseMessageWrapper() {
        }

        public RpcResponseMessageWrapper(RpcHeaderProtos.RpcResponseHeaderProto responseHeader, Message theRequest) {
            super(responseHeader, theRequest);
        }

        @Override
        byte[] readMessageRequest(DataInput in) throws IOException {
            switch (((RpcHeaderProtos.RpcResponseHeaderProto)this.requestHeader).getStatus()) {
                case ERROR: 
                case FATAL: {
                    return null;
                }
            }
            return super.readMessageRequest(in);
        }

        @Override
        RpcHeaderProtos.RpcResponseHeaderProto parseHeaderFrom(byte[] bytes) throws IOException {
            return RpcHeaderProtos.RpcResponseHeaderProto.parseFrom(bytes);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"RPC"})
    public static class RpcRequestMessageWrapper
    extends RpcMessageWithHeader<RpcHeaderProtos.RpcRequestHeaderProto> {
        public RpcRequestMessageWrapper() {
        }

        public RpcRequestMessageWrapper(RpcHeaderProtos.RpcRequestHeaderProto requestHeader, Message theRequest) {
            super(requestHeader, theRequest);
        }

        @Override
        RpcHeaderProtos.RpcRequestHeaderProto parseHeaderFrom(byte[] bytes) throws IOException {
            return RpcHeaderProtos.RpcRequestHeaderProto.parseFrom(bytes);
        }
    }

    private static class RpcRequestWrapper
    extends RpcMessageWithHeader<ProtobufRpcEngineProtos.RequestHeaderProto> {
        public RpcRequestWrapper() {
        }

        public RpcRequestWrapper(ProtobufRpcEngineProtos.RequestHeaderProto requestHeader, Message theRequest) {
            super(requestHeader, theRequest);
        }

        @Override
        ProtobufRpcEngineProtos.RequestHeaderProto parseHeaderFrom(byte[] bytes) throws IOException {
            return ProtobufRpcEngineProtos.RequestHeaderProto.parseFrom(bytes);
        }

        public String toString() {
            return ((ProtobufRpcEngineProtos.RequestHeaderProto)this.requestHeader).getDeclaringClassProtocolName() + "." + ((ProtobufRpcEngineProtos.RequestHeaderProto)this.requestHeader).getMethodName();
        }
    }

    private static abstract class RpcMessageWithHeader<T extends GeneratedMessage>
    implements RpcWrapper {
        T requestHeader;
        Message theRequest;
        byte[] theRequestRead;

        public RpcMessageWithHeader() {
        }

        public RpcMessageWithHeader(T requestHeader, Message theRequest) {
            this.requestHeader = requestHeader;
            this.theRequest = theRequest;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            OutputStream os = DataOutputOutputStream.constructOutputStream(out);
            this.requestHeader.writeDelimitedTo(os);
            this.theRequest.writeDelimitedTo(os);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.requestHeader = this.parseHeaderFrom(RpcMessageWithHeader.readVarintBytes(in));
            this.theRequestRead = this.readMessageRequest(in);
        }

        abstract T parseHeaderFrom(byte[] var1) throws IOException;

        byte[] readMessageRequest(DataInput in) throws IOException {
            return RpcMessageWithHeader.readVarintBytes(in);
        }

        private static byte[] readVarintBytes(DataInput in) throws IOException {
            int length = ProtoUtil.readRawVarint32(in);
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return bytes;
        }

        public T getMessageHeader() {
            return this.requestHeader;
        }

        public byte[] getMessageBytes() {
            return this.theRequestRead;
        }

        @Override
        public int getLength() {
            int reqLen;
            int headerLen = this.requestHeader.getSerializedSize();
            if (this.theRequest != null) {
                reqLen = this.theRequest.getSerializedSize();
            } else if (this.theRequestRead != null) {
                reqLen = this.theRequestRead.length;
            } else {
                throw new IllegalArgumentException("getLength on uninitialized RpcWrapper");
            }
            return CodedOutputStream.computeRawVarint32Size((int)headerLen) + headerLen + CodedOutputStream.computeRawVarint32Size((int)reqLen) + reqLen;
        }
    }

    static interface RpcWrapper
    extends Writable {
        public int getLength();
    }

    private static class Invoker
    implements RpcInvocationHandler {
        private final Map<String, Message> returnTypes = new ConcurrentHashMap<String, Message>();
        private boolean isClosed = false;
        private final Client.ConnectionId remoteId;
        private final Client client;
        private final long clientProtocolVersion;
        private final String protocolName;
        private AtomicBoolean fallbackToSimpleAuth;

        private Invoker(Class<?> protocol, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth) throws IOException {
            this(protocol, Client.ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, connectionRetryPolicy, conf), conf, factory);
            this.fallbackToSimpleAuth = fallbackToSimpleAuth;
        }

        private Invoker(Class<?> protocol, Client.ConnectionId connId, Configuration conf, SocketFactory factory) {
            this.remoteId = connId;
            this.client = CLIENTS.getClient(conf, factory, RpcResponseWrapper.class);
            this.protocolName = RPC.getProtocolName(protocol);
            this.clientProtocolVersion = RPC.getProtocolVersion(protocol);
        }

        private ProtobufRpcEngineProtos.RequestHeaderProto constructRpcRequestHeader(Method method) {
            ProtobufRpcEngineProtos.RequestHeaderProto.Builder builder = ProtobufRpcEngineProtos.RequestHeaderProto.newBuilder();
            builder.setMethodName(method.getName());
            builder.setDeclaringClassProtocolName(this.protocolName);
            builder.setClientProtocolVersion(this.clientProtocolVersion);
            return builder.build();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ServiceException {
            Message returnMessage;
            RpcResponseWrapper val;
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                startTime = Time.now();
            }
            if (args.length != 2) {
                throw new ServiceException("Too many parameters for request. Method: [" + method.getName() + "], Expected: 2, Actual: " + args.length);
            }
            if (args[1] == null) {
                throw new ServiceException("null param while calling Method: [" + method.getName() + "]");
            }
            TraceScope traceScope = null;
            if (Trace.isTracing()) {
                traceScope = Trace.startSpan((String)RpcClientUtil.methodToTraceString(method));
            }
            ProtobufRpcEngineProtos.RequestHeaderProto rpcRequestHeader = this.constructRpcRequestHeader(method);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(Thread.currentThread().getId() + ": Call -> " + this.remoteId + ": " + method.getName() + " {" + TextFormat.shortDebugString((MessageOrBuilder)((Message)args[1])) + "}"));
            }
            Message theRequest = (Message)args[1];
            try {
                val = (RpcResponseWrapper)this.client.call(RPC.RpcKind.RPC_PROTOCOL_BUFFER, (Writable)new RpcRequestWrapper(rpcRequestHeader, theRequest), this.remoteId, this.fallbackToSimpleAuth);
            }
            catch (Throwable e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(Thread.currentThread().getId() + ": Exception <- " + this.remoteId + ": " + method.getName() + " {" + e + "}"));
                }
                if (Trace.isTracing()) {
                    traceScope.getSpan().addTimelineAnnotation("Call got exception: " + e.getMessage());
                }
                throw new ServiceException(e);
            }
            finally {
                if (traceScope != null) {
                    traceScope.close();
                }
            }
            if (LOG.isDebugEnabled()) {
                long callTime = Time.now() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " took " + callTime + "ms"));
            }
            Message prototype = null;
            try {
                prototype = this.getReturnProtoType(method);
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
            try {
                returnMessage = prototype.newBuilderForType().mergeFrom(val.theResponseRead).build();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(Thread.currentThread().getId() + ": Response <- " + this.remoteId + ": " + method.getName() + " {" + TextFormat.shortDebugString((MessageOrBuilder)returnMessage) + "}"));
                }
            }
            catch (Throwable e) {
                throw new ServiceException(e);
            }
            return returnMessage;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }

        private Message getReturnProtoType(Method method) throws Exception {
            if (this.returnTypes.containsKey(method.getName())) {
                return this.returnTypes.get(method.getName());
            }
            Class<?> returnType = method.getReturnType();
            Method newInstMethod = returnType.getMethod("getDefaultInstance", new Class[0]);
            newInstMethod.setAccessible(true);
            Message prototype = (Message)newInstMethod.invoke(null, (Object[])null);
            this.returnTypes.put(method.getName(), prototype);
            return prototype;
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return this.remoteId;
        }
    }
}

