/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.DistCpV1;
import org.apache.hadoop.tools.TestCopyFiles;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCopyFiles
extends TestCase {
    static final URI LOCAL_FS = URI.create("file:///");
    private static final Random RAN = new Random();
    private static final int NFILES = 20;
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
    static final long now = System.currentTimeMillis();

    public TestCopyFiles() {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange")).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)DistCpV1.LOG).getLogger().setLevel(Level.ALL);
    }

    private static MyFile[] createFiles(URI fsname, String topdir) throws IOException {
        return TestCopyFiles.createFiles((FileSystem)FileSystem.get((URI)fsname, (Configuration)new Configuration()), (String)topdir);
    }

    private static MyFile[] createFiles(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        MyFile[] files = new MyFile[20];
        for (int i = 0; i < 20; ++i) {
            files[i] = TestCopyFiles.createFile((Path)root, (FileSystem)fs);
        }
        return files;
    }

    static MyFile createFile(Path root, FileSystem fs, int levels) throws IOException {
        MyFile f = levels < 0 ? new MyFile() : new MyFile(levels);
        Path p = new Path(root, f.getName());
        FSDataOutputStream out = fs.create(p);
        byte[] toWrite = new byte[f.getSize()];
        new Random(f.getSeed()).nextBytes(toWrite);
        out.write(toWrite);
        out.close();
        FileSystem.LOG.info((Object)("created: " + p + ", size=" + f.getSize()));
        return f;
    }

    static MyFile createFile(Path root, FileSystem fs) throws IOException {
        return TestCopyFiles.createFile((Path)root, (FileSystem)fs, (int)-1);
    }

    private static boolean checkFiles(FileSystem fs, String topdir, MyFile[] files) throws IOException {
        return TestCopyFiles.checkFiles((FileSystem)fs, (String)topdir, (MyFile[])files, (boolean)false);
    }

    private static boolean checkFiles(FileSystem fs, String topdir, MyFile[] files, boolean existingOnly) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < files.length; ++idx) {
            Path fPath = new Path(root, files[idx].getName());
            try {
                fs.getFileStatus(fPath);
                FSDataInputStream in = fs.open(fPath);
                byte[] toRead = new byte[files[idx].getSize()];
                byte[] toCompare = new byte[files[idx].getSize()];
                Random rb = new Random(files[idx].getSeed());
                rb.nextBytes(toCompare);
                TestCopyFiles.assertEquals((String)"Cannnot read file.", (int)toRead.length, (int)in.read(toRead));
                in.close();
                for (int i = 0; i < toRead.length; ++i) {
                    if (toRead[i] == toCompare[i]) continue;
                    return false;
                }
                toRead = null;
                toCompare = null;
                continue;
            }
            catch (FileNotFoundException fnfe) {
                if (existingOnly) continue;
                throw fnfe;
            }
        }
        return true;
    }

    private static void updateFiles(FileSystem fs, String topdir, MyFile[] files, int nupdate) throws IOException {
        assert (nupdate <= 20);
        Path root = new Path(topdir);
        for (int idx = 0; idx < nupdate; ++idx) {
            Path fPath = new Path(root, files[idx].getName());
            TestCopyFiles.assertTrue((String)(fPath.toString() + " does not exist"), (boolean)fs.exists(fPath));
            FSDataOutputStream out = fs.create(fPath);
            files[idx].reset();
            byte[] toWrite = new byte[files[idx].getSize()];
            Random rb = new Random(files[idx].getSeed());
            rb.nextBytes(toWrite);
            out.write(toWrite);
            out.close();
        }
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, MyFile[] files) throws IOException {
        return TestCopyFiles.getFileStatus((FileSystem)fs, (String)topdir, (MyFile[])files, (boolean)false);
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, MyFile[] files, boolean existingOnly) throws IOException {
        Path root = new Path(topdir);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (int idx = 0; idx < 20; ++idx) {
            try {
                statuses.add(fs.getFileStatus(new Path(root, files[idx].getName())));
                continue;
            }
            catch (FileNotFoundException fnfe) {
                if (existingOnly) continue;
                throw fnfe;
            }
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    private static boolean checkUpdate(FileSystem fs, FileStatus[] old, String topdir, MyFile[] upd, int nupdate) throws IOException {
        FileStatus stat;
        int idx;
        Path root = new Path(topdir);
        for (idx = 0; idx < nupdate; ++idx) {
            stat = fs.getFileStatus(new Path(root, upd[idx].getName()));
            if (stat.getModificationTime() > old[idx].getModificationTime()) continue;
            return false;
        }
        for (idx = nupdate; idx < 20; ++idx) {
            stat = fs.getFileStatus(new Path(root, upd[idx].getName()));
            if (stat.getModificationTime() == old[idx].getModificationTime()) continue;
            return false;
        }
        return true;
    }

    private static void deldir(FileSystem fs, String topdir) throws IOException {
        fs.delete(new Path(topdir), true);
    }

    public void testCopyFromLocalToLocal() throws Exception {
        Configuration conf = new Configuration();
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)conf);
        MyFile[] files = TestCopyFiles.createFiles((URI)LOCAL_FS, (String)(TEST_ROOT_DIR + "/srcdat"));
        ToolRunner.run((Tool)new DistCpV1(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"});
        TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/destdat"), (MyFile[])files));
        TestCopyFiles.deldir((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/destdat"));
        TestCopyFiles.deldir((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/srcdat"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromDfsToDfs() throws Exception {
        String namenode = null;
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(namenode), (String)"/srcdat");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, (String)"/destdat", (MyFile[])files));
                FileSystem fs = FileSystem.get((URI)URI.create(namenode + "/logs"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)fs.exists(new Path(namenode + "/logs")));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/srcdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyDir() throws Exception {
        String namenode = null;
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                FileSystem fs = FileSystem.get((URI)URI.create(namenode), (Configuration)new Configuration());
                fs.mkdirs(new Path("/empty"));
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-log", namenode + "/logs", namenode + "/empty", namenode + "/dest"});
                fs = FileSystem.get((URI)URI.create(namenode + "/destdat"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Destination directory does not exist.", (boolean)fs.exists(new Path(namenode + "/dest")));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/dest");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/empty");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromLocalToDfs() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles((URI)LOCAL_FS, (String)(TEST_ROOT_DIR + "/srcdat"));
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-log", namenode + "/logs", "file:///" + TEST_ROOT_DIR + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)cluster.getFileSystem(), (String)"/destdat", (MyFile[])files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path(namenode + "/logs")));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
                TestCopyFiles.deldir((FileSystem)FileSystem.get((URI)LOCAL_FS, (Configuration)conf), (String)(TEST_ROOT_DIR + "/srcdat"));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromDfsToLocal() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            FileSystem localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)conf);
            cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(namenode), (String)"/srcdat");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-log", "/logs", namenode + "/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/destdat"), (MyFile[])files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path("/logs")));
                TestCopyFiles.deldir((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/destdat"));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/srcdat");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyDfsToDfsUpdateOverwrite() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(namenode), (String)"/srcdat");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-p", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, (String)"/destdat", (MyFile[])files));
                FileSystem fs = FileSystem.get((URI)URI.create(namenode + "/logs"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)fs.exists(new Path(namenode + "/logs")));
                FileStatus[] dchkpoint = TestCopyFiles.getFileStatus((FileSystem)hdfs, (String)"/destdat", (MyFile[])files);
                int nupdate = 5;
                TestCopyFiles.updateFiles((FileSystem)cluster.getFileSystem(), (String)"/srcdat", (MyFile[])files, (int)5);
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-prbugp", "-update", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, (String)"/destdat", (MyFile[])files));
                TestCopyFiles.assertTrue((String)"Update failed to replicate all changes in src", (boolean)TestCopyFiles.checkUpdate((FileSystem)hdfs, (FileStatus[])dchkpoint, (String)"/destdat", (MyFile[])files, (int)5));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-prbugp", "-overwrite", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, (String)"/destdat", (MyFile[])files));
                TestCopyFiles.assertTrue((String)"-overwrite didn't.", (boolean)TestCopyFiles.checkUpdate((FileSystem)hdfs, (FileStatus[])dchkpoint, (String)"/destdat", (MyFile[])files, (int)20));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/srcdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyDfsToDfsUpdateWithSkipCRC() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            FileSystem fs = FileSystem.get((URI)URI.create(namenode), (Configuration)new Configuration());
            String testfilename = "test";
            String srcData = "act act act";
            String destData = "cat cat cat";
            if (namenode.startsWith("hdfs://")) {
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
                Path srcPath = new Path("/srcdat", "test");
                Path destPath = new Path("/destdat", "test");
                FSDataOutputStream out = fs.create(srcPath, true);
                out.writeUTF("act act act");
                out.close();
                out = fs.create(destPath, true);
                out.writeUTF("cat cat cat");
                out.close();
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-p", "-update", "-skipcrccheck", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                FSDataInputStream in = hdfs.open(destPath);
                String s = in.readUTF();
                System.out.println("Dest had: " + s);
                TestCopyFiles.assertTrue((String)"Dest got over written even with skip crc", (boolean)s.equalsIgnoreCase("cat cat cat"));
                in.close();
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-p", "-update", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
                in = hdfs.open(destPath);
                s = in.readUTF();
                System.out.println("Dest had: " + s);
                TestCopyFiles.assertTrue((String)"Dest did not get overwritten without skip crc", (boolean)s.equalsIgnoreCase("act act act"));
                in.close();
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/srcdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCopyDuplication() throws Exception {
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)new Configuration());
        try {
            MyFile[] files = TestCopyFiles.createFiles((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/srcdat"));
            ToolRunner.run((Tool)new DistCpV1(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/src2/srcdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/src2/srcdat"), (MyFile[])files));
            TestCopyFiles.assertEquals((int)-2, (int)ToolRunner.run((Tool)new DistCpV1(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/src2/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"}));
        }
        finally {
            TestCopyFiles.deldir((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/destdat"));
            TestCopyFiles.deldir((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/srcdat"));
            TestCopyFiles.deldir((FileSystem)localfs, (String)(TEST_ROOT_DIR + "/src2"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySingleFile() throws Exception {
        FileSystem fs = FileSystem.get((URI)LOCAL_FS, (Configuration)new Configuration());
        Path root = new Path(TEST_ROOT_DIR + "/srcdat");
        try {
            MyFile[] files = new MyFile[]{TestCopyFiles.createFile((Path)root, (FileSystem)fs)};
            ToolRunner.run((Tool)new DistCpV1(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)(TEST_ROOT_DIR + "/destdat"), (MyFile[])files));
            String fname = files[0].getName();
            Path p = new Path(root, fname);
            FileSystem.LOG.info((Object)("fname=" + fname + ", exists? " + fs.exists(p)));
            ToolRunner.run((Tool)new DistCpV1(new Configuration()), (String[])new String[]{"file:///" + TEST_ROOT_DIR + "/srcdat/" + fname, "file:///" + TEST_ROOT_DIR + "/dest2/" + fname});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)(TEST_ROOT_DIR + "/dest2"), (MyFile[])files));
            String[] args = new String[]{"-update", "file:///" + TEST_ROOT_DIR + "/srcdat/" + fname, "file:///" + TEST_ROOT_DIR + "/dest2/" + fname};
            Configuration conf = new Configuration();
            JobConf job = new JobConf(conf, DistCpV1.class);
            DistCpV1.Arguments distcpArgs = DistCpV1.Arguments.valueOf((String[])args, (Configuration)conf);
            TestCopyFiles.assertFalse((String)"Single file update failed to skip copying even though the file exists at destination.", (boolean)DistCpV1.setup((Configuration)conf, (JobConf)job, (DistCpV1.Arguments)distcpArgs));
            TestCopyFiles.deldir((FileSystem)fs, (String)(TEST_ROOT_DIR + "/dest2"));
            fs.mkdirs(new Path(TEST_ROOT_DIR + "/dest2"));
            MyFile[] files2 = new MyFile[]{TestCopyFiles.createFile((Path)root, (FileSystem)fs, (int)0)};
            String sname = files2[0].getName();
            ToolRunner.run((Tool)new DistCpV1(new Configuration()), (String[])new String[]{"-update", "file:///" + TEST_ROOT_DIR + "/srcdat/" + sname, "file:///" + TEST_ROOT_DIR + "/dest2/"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)(TEST_ROOT_DIR + "/dest2"), (MyFile[])files2));
            TestCopyFiles.updateFiles((FileSystem)fs, (String)(TEST_ROOT_DIR + "/srcdat"), (MyFile[])files2, (int)1);
            ToolRunner.run((Tool)new DistCpV1(new Configuration()), (String[])new String[]{"-update", "file:///" + TEST_ROOT_DIR + "/srcdat/" + sname, "file:///" + TEST_ROOT_DIR + "/dest2/"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)(TEST_ROOT_DIR + "/dest2"), (MyFile[])files2));
        }
        finally {
            TestCopyFiles.deldir((FileSystem)fs, (String)(TEST_ROOT_DIR + "/destdat"));
            TestCopyFiles.deldir((FileSystem)fs, (String)(TEST_ROOT_DIR + "/dest2"));
            TestCopyFiles.deldir((FileSystem)fs, (String)(TEST_ROOT_DIR + "/srcdat"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasedir() throws Exception {
        String namenode = null;
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(namenode), (String)"/basedir/middle/srcdat");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-basedir", "/basedir", namenode + "/basedir/middle/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, (String)"/destdat/middle/srcdat", (MyFile[])files));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/basedir");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreserveOption() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            int i;
            int i2;
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(nnUri), (String)"/srcdat");
            FileStatus[] srcstat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/srcdat", (MyFile[])files);
            for (int i3 = 0; i3 < srcstat.length; ++i3) {
                fs.setOwner(srcstat[i3].getPath(), "u" + i3, null);
            }
            ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-pu", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)"/destdat", (MyFile[])files));
            FileStatus[] dststat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/destdat", (MyFile[])files);
            for (i2 = 0; i2 < dststat.length; ++i2) {
                TestCopyFiles.assertEquals((String)("i=" + i2), (String)("u" + i2), (String)dststat[i2].getOwner());
            }
            TestCopyFiles.deldir((FileSystem)fs, (String)"/destdat");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/srcdat");
            files = TestCopyFiles.createFiles((URI)URI.create(nnUri), (String)"/srcdat");
            srcstat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/srcdat", (MyFile[])files);
            for (int i4 = 0; i4 < srcstat.length; ++i4) {
                fs.setOwner(srcstat[i4].getPath(), null, "g" + i4);
            }
            ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-pg", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)"/destdat", (MyFile[])files));
            dststat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/destdat", (MyFile[])files);
            for (i2 = 0; i2 < dststat.length; ++i2) {
                TestCopyFiles.assertEquals((String)("i=" + i2), (String)("g" + i2), (String)dststat[i2].getGroup());
            }
            TestCopyFiles.deldir((FileSystem)fs, (String)"/destdat");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/srcdat");
            files = TestCopyFiles.createFiles((URI)URI.create(nnUri), (String)"/srcdat");
            srcstat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/srcdat", (MyFile[])files);
            FsPermission[] permissions = new FsPermission[srcstat.length];
            for (i2 = 0; i2 < srcstat.length; ++i2) {
                permissions[i2] = new FsPermission((short)(i2 & 0x1B6));
                fs.setPermission(srcstat[i2].getPath(), permissions[i2]);
            }
            ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-pp", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)"/destdat", (MyFile[])files));
            FileStatus[] dststat2 = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/destdat", (MyFile[])files);
            for (i = 0; i < dststat2.length; ++i) {
                TestCopyFiles.assertEquals((String)("i=" + i), (Object)permissions[i], (Object)dststat2[i].getPermission());
            }
            TestCopyFiles.deldir((FileSystem)fs, (String)"/destdat");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/srcdat");
            files = TestCopyFiles.createFiles((URI)URI.create(nnUri), (String)"/srcdat");
            fs.mkdirs(new Path("/srcdat/tmpf1"));
            fs.mkdirs(new Path("/srcdat/tmpf2"));
            srcstat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/srcdat", (MyFile[])files);
            permissions = new FsPermission[srcstat.length];
            for (int i5 = 0; i5 < srcstat.length; ++i5) {
                fs.setTimes(srcstat[i5].getPath(), 40L, 50L);
            }
            ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-pt", nnUri + "/srcdat", nnUri + "/destdat"});
            dststat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/destdat", (MyFile[])files);
            for (i = 0; i < dststat.length; ++i) {
                TestCopyFiles.assertEquals((String)("Modif. Time i=" + i), (long)40L, (long)dststat[i].getModificationTime());
                TestCopyFiles.assertEquals((String)("Access Time i=" + i + srcstat[i].getPath() + "-" + dststat[i].getPath()), (long)50L, (long)dststat[i].getAccessTime());
            }
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)"/destdat", (MyFile[])files));
            TestCopyFiles.deldir((FileSystem)fs, (String)"/destdat");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapCount() throws Exception {
        String namenode = null;
        MiniDFSCluster dfs = null;
        Object mr = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).build();
            DistributedFileSystem fs = dfs.getFileSystem();
            FsShell shell = new FsShell(conf);
            namenode = fs.getUri().toString();
            MyFile[] files = TestCopyFiles.createFiles((URI)fs.getUri(), (String)"/srcdat");
            long totsize = 0L;
            for (MyFile f : files) {
                totsize += (long)f.getSize();
            }
            JobConf job = new JobConf(conf);
            job.setLong("distcp.bytes.per.map", totsize / 3L);
            ToolRunner.run((Tool)new DistCpV1((Configuration)job), (String[])new String[]{"-m", "100", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)"/destdat", (MyFile[])files));
            String logdir = namenode + "/logs";
            System.out.println(TestCopyFiles.execCmd((FsShell)shell, (String[])new String[]{"-lsr", logdir}));
            FileStatus[] logs = fs.listStatus(new Path(logdir));
            TestCopyFiles.assertTrue((logs.length == 2 ? 1 : 0) != 0);
            TestCopyFiles.deldir((FileSystem)fs, (String)"/destdat");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/logs");
            ToolRunner.run((Tool)new DistCpV1((Configuration)job), (String[])new String[]{"-m", "1", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
            System.out.println(TestCopyFiles.execCmd((FsShell)shell, (String[])new String[]{"-lsr", logdir}));
            logs = fs.globStatus(new Path(namenode + "/logs/part*"));
            TestCopyFiles.assertTrue((String)("Unexpected map count, logs.length=" + logs.length), (logs.length == 1 ? 1 : 0) != 0);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLimits() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            DistCpV1 distcp = new DistCpV1(conf);
            FsShell shell = new FsShell(conf);
            String srcrootdir = "/src_root";
            Path srcrootpath = new Path("/src_root");
            String dstrootdir = "/dst_root";
            Path dstrootpath = new Path("/dst_root");
            MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(nnUri), (String)"/src_root");
            int filelimit = files.length / 2;
            System.out.println("filelimit=" + filelimit);
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-filelimit", "" + filelimit, nnUri + "/src_root", nnUri + "/dst_root"});
            String results = TestCopyFiles.execCmd((FsShell)shell, (String[])new String[]{"-lsr", "/dst_root"});
            results = TestCopyFiles.removePrefix((String)results, (String)"/dst_root");
            System.out.println("results=" + results);
            FileStatus[] dststat = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/dst_root", (MyFile[])files, (boolean)true);
            TestCopyFiles.assertEquals((int)filelimit, (int)dststat.length);
            TestCopyFiles.deldir((FileSystem)fs, (String)"/dst_root");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/src_root");
            TestCopyFiles.createFiles((URI)URI.create(nnUri), (String)"/src_root");
            long sizelimit = fs.getContentSummary(srcrootpath).getLength() / 2L;
            System.out.println("sizelimit=" + sizelimit);
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-sizelimit", "" + sizelimit, nnUri + "/src_root", nnUri + "/dst_root"});
            ContentSummary summary = fs.getContentSummary(dstrootpath);
            System.out.println("summary=" + summary);
            TestCopyFiles.assertTrue((summary.getLength() <= sizelimit ? 1 : 0) != 0);
            TestCopyFiles.deldir((FileSystem)fs, (String)"/dst_root");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/src_root");
            MyFile[] srcs = TestCopyFiles.createFiles((URI)URI.create(nnUri), (String)"/src_root");
            long totalsize = fs.getContentSummary(srcrootpath).getLength();
            System.out.println("src.length=" + srcs.length);
            System.out.println("totalsize =" + totalsize);
            fs.mkdirs(dstrootpath);
            int parts = RAN.nextInt(5) + 2;
            int filelimit2 = srcs.length / parts;
            long sizelimit2 = totalsize / (long)parts;
            System.out.println("filelimit=" + filelimit2);
            System.out.println("sizelimit=" + sizelimit2);
            System.out.println("parts    =" + parts);
            String[] args = new String[]{"-filelimit", "" + filelimit2, "-sizelimit", "" + sizelimit2, "-update", nnUri + "/src_root", nnUri + "/dst_root"};
            int dstfilecount = 0;
            long dstsize = 0L;
            for (int i = 0; i <= parts; ++i) {
                ToolRunner.run((Tool)distcp, (String[])args);
                FileStatus[] dststat2 = TestCopyFiles.getFileStatus((FileSystem)fs, (String)"/dst_root", (MyFile[])srcs, (boolean)true);
                System.out.println(i + ") dststat.length=" + dststat2.length);
                TestCopyFiles.assertTrue((dststat2.length - dstfilecount <= filelimit2 ? 1 : 0) != 0);
                ContentSummary summary2 = fs.getContentSummary(dstrootpath);
                System.out.println(i + ") summary.getLength()=" + summary2.getLength());
                TestCopyFiles.assertTrue((summary2.getLength() - dstsize <= sizelimit2 ? 1 : 0) != 0);
                TestCopyFiles.assertTrue((boolean)TestCopyFiles.checkFiles((FileSystem)fs, (String)"/dst_root", (MyFile[])srcs, (boolean)true));
                dstfilecount = dststat2.length;
                dstsize = summary2.getLength();
            }
            TestCopyFiles.deldir((FileSystem)fs, (String)"/dst_root");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/src_root");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static UserGroupInformation createUGI(String name, boolean issuper) {
        String username = name + now;
        String group = issuper ? "supergroup" : username;
        return UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{group});
    }

    static Path createHomeDirectory(FileSystem fs, UserGroupInformation ugi) throws IOException {
        Path home = new Path("/user/" + ugi.getUserName());
        fs.mkdirs(home);
        fs.setOwner(home, ugi.getUserName(), ugi.getGroupNames()[0]);
        fs.setPermission(home, new FsPermission(448));
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHftpAccessControl() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            UserGroupInformation DFS_UGI = TestCopyFiles.createUGI((String)"dfs", (boolean)true);
            UserGroupInformation USER_UGI = TestCopyFiles.createUGI((String)"user", (boolean)false);
            Configuration dfsConf = new Configuration();
            cluster = new MiniDFSCluster.Builder(dfsConf).numDataNodes(2).build();
            cluster.waitActive();
            String httpAdd = dfsConf.get("dfs.http.address");
            URI nnURI = FileSystem.getDefaultUri((Configuration)dfsConf);
            String nnUri = nnURI.toString();
            FileSystem fs1 = (FileSystem)DFS_UGI.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            Path home = TestCopyFiles.createHomeDirectory((FileSystem)fs1, (UserGroupInformation)USER_UGI);
            Configuration userConf = new Configuration();
            FileSystem fs = (FileSystem)USER_UGI.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            Path srcrootpath = new Path(home, "src_root");
            String srcrootdir = srcrootpath.toString();
            Path dstrootpath = new Path(home, "dst_root");
            String dstrootdir = dstrootpath.toString();
            DistCpV1 distcp = (DistCpV1)USER_UGI.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            FileSystem.mkdirs((FileSystem)fs, (Path)srcrootpath, (FsPermission)new FsPermission(448));
            String[] args = new String[]{"hftp://" + httpAdd + srcrootdir, nnUri + dstrootdir};
            fs.setPermission(srcrootpath, new FsPermission(0));
            USER_UGI.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("fs.trash.interval", 60);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            URI nnURI = FileSystem.getDefaultUri((Configuration)conf);
            String nnUri = nnURI.toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            DistCpV1 distcp = new DistCpV1(conf);
            FsShell shell = new FsShell(conf);
            String srcrootdir = "/src_root";
            String dstrootdir = "/dst_root";
            TestCopyFiles.createFiles((URI)nnURI, (String)"/src_root");
            String srcresults = TestCopyFiles.execCmd((FsShell)shell, (String[])new String[]{"-lsr", "/src_root"});
            srcresults = TestCopyFiles.removePrefix((String)srcresults, (String)"/src_root");
            System.out.println("srcresults=" + srcresults);
            TestCopyFiles.createFiles((URI)nnURI, (String)"/dst_root");
            System.out.println("dstrootdir=/dst_root");
            shell.run(new String[]{"-lsr", "/dst_root"});
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-delete", "-update", "-log", "/log", nnUri + "/src_root", nnUri + "/dst_root"});
            String dstresults = TestCopyFiles.execCmd((FsShell)shell, (String[])new String[]{"-lsr", "/dst_root"});
            dstresults = TestCopyFiles.removePrefix((String)dstresults, (String)"/dst_root");
            System.out.println("first dstresults=" + dstresults);
            TestCopyFiles.assertEquals((String)srcresults, (String)dstresults);
            TestCopyFiles.create((FileSystem)fs, (Path)new Path("/dst_root", "foo"));
            TestCopyFiles.create((FileSystem)fs, (Path)new Path("/dst_root", "foobar"));
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-delete", "-update", "-log", "/log2", nnUri + "/src_root", nnUri + "/dst_root"});
            dstresults = TestCopyFiles.execCmd((FsShell)shell, (String[])new String[]{"-lsr", "/dst_root"});
            dstresults = TestCopyFiles.removePrefix((String)dstresults, (String)"/dst_root");
            System.out.println("second dstresults=" + dstresults);
            TestCopyFiles.assertEquals((String)srcresults, (String)dstresults);
            TestCopyFiles.assertTrue((boolean)fs.exists(new Path(fs.getHomeDirectory(), ".Trash/Current/dst_root/foo")));
            TestCopyFiles.assertTrue((boolean)fs.exists(new Path(fs.getHomeDirectory(), ".Trash/Current/dst_root/foobar")));
            TestCopyFiles.deldir((FileSystem)fs, (String)"/dst_root");
            TestCopyFiles.deldir((FileSystem)fs, (String)"/src_root");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteLocal() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            FileSystem localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)conf);
            cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(namenode), (String)"/srcdat");
                String destdir = TEST_ROOT_DIR + "/destdat";
                MyFile[] localFiles = TestCopyFiles.createFiles((FileSystem)localfs, (String)destdir);
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-delete", "-update", "-log", "/logs", namenode + "/srcdat", "file:///" + TEST_ROOT_DIR + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)localfs, (String)destdir, (MyFile[])files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path("/logs")));
                TestCopyFiles.deldir((FileSystem)localfs, (String)destdir);
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/srcdat");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGlobbing() throws Exception {
        String namenode = null;
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles((URI)URI.create(namenode), (String)"/srcdat");
                ToolRunner.run((Tool)new DistCpV1(conf), (String[])new String[]{"-log", namenode + "/logs", namenode + "/srcdat/*", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, (String)"/destdat", (MyFile[])files));
                FileSystem fs = FileSystem.get((URI)URI.create(namenode + "/logs"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)fs.exists(new Path(namenode + "/logs")));
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/srcdat");
                TestCopyFiles.deldir((FileSystem)hdfs, (String)"/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void create(FileSystem fs, Path f) throws IOException {
        try (FSDataOutputStream out = fs.create(f);){
            byte[] b = new byte[1024 + RAN.nextInt(1024)];
            RAN.nextBytes(b);
            out.write(b);
        }
    }

    static String execCmd(FsShell shell, String ... args) throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baout, true);
        PrintStream old = System.out;
        System.setOut(out);
        shell.run(args);
        out.close();
        System.setOut(old);
        return baout.toString();
    }

    private static String removePrefix(String lines, String prefix) {
        int prefixlen = prefix.length();
        StringTokenizer t = new StringTokenizer(lines, "\n");
        StringBuffer results = new StringBuffer();
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            results.append(s.substring(s.indexOf(prefix) + prefixlen) + "\n");
        }
        return results.toString();
    }
}

