/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.DistCh;
import org.apache.hadoop.tools.DistTool;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistCh
extends DistTool {
    static final String NAME = "distch";
    static final String JOB_DIR_LABEL = "distch.job.dir";
    static final String OP_LIST_LABEL = "distch.op.list";
    static final String OP_COUNT_LABEL = "distch.op.count";
    static final String USAGE = "java " + DistCh.class.getName() + " [OPTIONS] <path:owner:group:permission>+ \n\nThe values of owner, group and permission can be empty.\nPermission is a octal number.\n\nOPTIONS:\n-f <urilist_uri>       Use list at <urilist_uri> as src list\n-i                     Ignore failures\n-log <logdir>          Write logs to <logdir>";
    private static final long OP_PER_MAP = 1000L;
    private static final int MAX_MAPS_PER_NODE = 20;
    private static final int SYNC_FILE_MAX = 10;

    DistCh(Configuration conf) {
        super((Configuration)DistCh.createJobConf((Configuration)conf));
    }

    private static JobConf createJobConf(Configuration conf) {
        JobConf jobconf = new JobConf(conf, DistCh.class);
        jobconf.setJobName("distch");
        jobconf.setMapSpeculativeExecution(false);
        jobconf.setInputFormat(ChangeInputFormat.class);
        jobconf.setOutputKeyClass(Text.class);
        jobconf.setOutputValueClass(Text.class);
        jobconf.setMapperClass(ChangeFilesMapper.class);
        jobconf.setNumReduceTasks(0);
        return jobconf;
    }

    private static void check(Configuration conf, List<FileOperation> ops) throws InvalidInputException {
        ArrayList<Path> srcs = new ArrayList<Path>();
        for (FileOperation op : ops) {
            srcs.add(FileOperation.access$000((FileOperation)op));
        }
        DistTool.checkSource((Configuration)conf, srcs);
    }

    private static List<FileOperation> fetchList(Configuration conf, Path inputfile) throws IOException {
        ArrayList<FileOperation> result = new ArrayList<FileOperation>();
        for (String line : DistCh.readFile((Configuration)conf, (Path)inputfile)) {
            result.add(new FileOperation(line));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        ArrayList<FileOperation> ops = new ArrayList<FileOperation>();
        Path logpath = null;
        boolean isIgnoreFailures = false;
        try {
            for (int idx = 0; idx < args.length; ++idx) {
                if ("-f".equals(args[idx])) {
                    if (++idx == args.length) {
                        System.out.println("urilist_uri not specified");
                        System.out.println(USAGE);
                        return -1;
                    }
                    ops.addAll(DistCh.fetchList((Configuration)this.jobconf, (Path)new Path(args[idx])));
                    continue;
                }
                if (Option.IGNORE_FAILURES.cmd.equals(args[idx])) {
                    isIgnoreFailures = true;
                    continue;
                }
                if ("-log".equals(args[idx])) {
                    if (++idx == args.length) {
                        System.out.println("logdir not specified");
                        System.out.println(USAGE);
                        return -1;
                    }
                    logpath = new Path(args[idx]);
                    continue;
                }
                if (45 == args[idx].codePointAt(0)) {
                    System.out.println("Invalid switch " + args[idx]);
                    System.out.println(USAGE);
                    ToolRunner.printGenericCommandUsage((PrintStream)System.out);
                    return -1;
                }
                ops.add(new FileOperation(args[idx]));
            }
            if (ops.isEmpty()) {
                throw new IllegalStateException("Operation is empty");
            }
            LOG.info((Object)("ops=" + ops));
            LOG.info((Object)("isIgnoreFailures=" + isIgnoreFailures));
            this.jobconf.setBoolean(Option.IGNORE_FAILURES.propertyname, isIgnoreFailures);
            DistCh.check((Configuration)this.jobconf, ops);
            try {
                if (this.setup(ops, logpath)) {
                    JobClient.runJob((JobConf)this.jobconf);
                }
            }
            finally {
                try {
                    Path logdir;
                    if (logpath == null && (logdir = FileOutputFormat.getOutputPath((JobConf)this.jobconf)) != null) {
                        logdir.getFileSystem((Configuration)this.jobconf).delete(logdir, true);
                    }
                }
                finally {
                    String jobdir = this.jobconf.get("distch.job.dir");
                    if (jobdir != null) {
                        Path jobpath = new Path(jobdir);
                        jobpath.getFileSystem((Configuration)this.jobconf).delete(jobpath, true);
                    }
                }
            }
        }
        catch (DistTool.DuplicationException e) {
            LOG.error((Object)"Input error:", (Throwable)e);
            return -2;
        }
        catch (Exception e) {
            LOG.error((Object)"distch failed: ", (Throwable)e);
            System.out.println(USAGE);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        return 0;
    }

    private static int getMapCount(int srcCount, int numNodes) {
        int numMaps = (int)((long)srcCount / 1000L);
        numMaps = Math.min(numMaps, numNodes * 20);
        return Math.max(numMaps, 1);
    }

    private boolean setup(List<FileOperation> ops, Path log) throws IOException {
        Path stagingArea;
        String randomId = DistCh.getRandomId();
        JobClient jClient = new JobClient(this.jobconf);
        try {
            stagingArea = JobSubmissionFiles.getStagingDir((Cluster)jClient.getClusterHandle(), (Configuration)this.jobconf);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        Path jobdir = new Path(stagingArea + "distch" + "_" + randomId);
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs((FileSystem)jClient.getFs(), (Path)jobdir, (FsPermission)mapredSysPerms);
        LOG.info((Object)("distch.job.dir=" + jobdir));
        if (log == null) {
            log = new Path(jobdir, "_logs");
        }
        FileOutputFormat.setOutputPath((JobConf)this.jobconf, (Path)log);
        LOG.info((Object)("log=" + log));
        FileSystem fs = jobdir.getFileSystem((Configuration)this.jobconf);
        Path opList = new Path(jobdir, "_distch.op.list");
        this.jobconf.set("distch.op.list", opList.toString());
        int opCount = 0;
        int synCount = 0;
        try (SequenceFile.Writer opWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.jobconf, (Path)opList, Text.class, FileOperation.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            for (FileOperation op : ops) {
                FileStatus srcstat = fs.getFileStatus(FileOperation.access$000((FileOperation)op));
                if (srcstat.isDirectory() && FileOperation.access$100((FileOperation)op, (FileStatus)srcstat)) {
                    ++opCount;
                    opWriter.append((Writable)new Text(FileOperation.access$000((FileOperation)op).toString()), (Writable)op);
                }
                Stack<Path> pathstack = new Stack<Path>();
                pathstack.push(FileOperation.access$000((FileOperation)op));
                while (!pathstack.empty()) {
                    for (FileStatus stat : fs.listStatus((Path)pathstack.pop())) {
                        if (stat.isDirectory()) {
                            pathstack.push(stat.getPath());
                        }
                        if (!FileOperation.access$100((FileOperation)op, (FileStatus)stat)) continue;
                        ++opCount;
                        if (++synCount > 10) {
                            opWriter.sync();
                            synCount = 0;
                        }
                        Path f = stat.getPath();
                        opWriter.append((Writable)new Text(f.toString()), (Writable)new FileOperation(f, op));
                    }
                }
            }
        }
        DistCh.checkDuplication((FileSystem)fs, (Path)opList, (Path)new Path(jobdir, "_sorted"), (Configuration)this.jobconf);
        this.jobconf.setInt("distch.op.count", opCount);
        LOG.info((Object)("distch.op.count=" + opCount));
        this.jobconf.setNumMapTasks(DistCh.getMapCount((int)opCount, (int)new JobClient(this.jobconf).getClusterStatus().getTaskTrackers()));
        return opCount != 0;
    }

    private static void checkDuplication(FileSystem fs, Path file, Path sorted, Configuration conf) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, (RawComparator)new Text.Comparator(), Text.class, FileOperation.class, conf);
        sorter.sort(file, sorted);
        try (SequenceFile.Reader in = new SequenceFile.Reader(fs, sorted, conf);){
            FileOperation curop = new FileOperation();
            Text prevsrc = null;
            Text cursrc = new Text();
            while (in.next((Writable)cursrc, (Writable)curop)) {
                if (prevsrc != null && cursrc.equals((Object)prevsrc)) {
                    throw new DistTool.DuplicationException("Invalid input, there are duplicated files in the sources: " + prevsrc + ", " + cursrc);
                }
                prevsrc = cursrc;
                cursrc = new Text();
                curop = new FileOperation();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new DistCh(new Configuration()), (String[])args));
    }
}

