/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Tool;

abstract class DistTool
implements Tool {
    protected static final Log LOG = LogFactory.getLog(DistTool.class);
    protected JobConf jobconf;
    private static final Random RANDOM = new Random();

    public void setConf(Configuration conf) {
        if (this.jobconf != conf) {
            this.jobconf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        }
    }

    public JobConf getConf() {
        return this.jobconf;
    }

    protected DistTool(Configuration conf) {
        this.setConf(conf);
    }

    protected static String getRandomId() {
        return Integer.toString(RANDOM.nextInt(Integer.MAX_VALUE), 36);
    }

    protected static void checkSource(Configuration conf, List<Path> srcs) throws InvalidInputException {
        ArrayList<IOException> ioes = new ArrayList<IOException>();
        for (Path p : srcs) {
            try {
                if (p.getFileSystem(conf).exists(p)) continue;
                ioes.add(new FileNotFoundException("Source " + p + " does not exist."));
            }
            catch (IOException e) {
                ioes.add(e);
            }
        }
        if (!ioes.isEmpty()) {
            throw new InvalidInputException(ioes);
        }
    }

    protected static String readString(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return Text.readString((DataInput)in);
        }
        return null;
    }

    protected static void writeString(DataOutput out, String s) throws IOException {
        boolean b = s != null;
        out.writeBoolean(b);
        if (b) {
            Text.writeString((DataOutput)out, (String)s);
        }
    }

    protected static List<String> readFile(Configuration conf, Path inputfile) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        FileSystem fs = inputfile.getFileSystem(conf);
        try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)fs.open(inputfile), Charset.forName("UTF-8")));){
            String line;
            while ((line = input.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }
}

