/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.InputStriper;
import org.apache.hadoop.mapred.gridmix.TestFilePool;
import org.apache.hadoop.mapred.gridmix.TestFileQueue;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFilePool {
    static final Log LOG = LogFactory.getLog(TestFileQueue.class);
    static final int NFILES = 26;
    static final Path base = TestFilePool.getBaseDir();

    static Path getBaseDir() {
        try {
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
            return new Path(System.getProperty("test.build.data", "/tmp"), "testFilePool").makeQualified(fs);
        }
        catch (IOException e) {
            Assert.fail();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        fs.delete(base, true);
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        LOG.info((Object)("seed: " + seed));
        fs.mkdirs(base);
        for (int i = 0; i < 26; ++i) {
            Path file = base;
            for (double d = 0.6; d > 0.0 && r.nextDouble() < d; d *= 0.8) {
                file = new Path(base, Integer.toString(r.nextInt(3)));
            }
            try (OutputStream out = null;){
                out = fs.create(new Path(file, "" + (char)(65 + i)));
                byte[] b = new byte[1024];
                Arrays.fill(b, (byte)(65 + i));
                for (int len = (i % 13 + 1) * 1024; len > 0; len -= 1024) {
                    out.write(b);
                }
                continue;
            }
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        fs.delete(base, true);
    }

    @Test
    public void testUnsuitable() throws Exception {
        try {
            Configuration conf = new Configuration();
            conf.setLong("gridmix.min.file.size", 14336L);
            FilePool pool = new FilePool(conf, base);
            pool.refresh();
        }
        catch (IOException e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testPool() throws Exception {
        Random r = new Random();
        Configuration conf = new Configuration();
        conf.setLong("gridmix.min.file.size", 3072L);
        FilePool pool = new FilePool(conf, base);
        pool.refresh();
        ArrayList files = new ArrayList();
        int expectedPoolSize = 180224;
        Assert.assertEquals((long)180224L, (long)pool.getInputFiles(Long.MAX_VALUE, files));
        Assert.assertEquals((long)22L, (long)files.size());
        files.clear();
        Assert.assertEquals((long)180224L, (long)pool.getInputFiles(180224L, files));
        files.clear();
        long rand = r.nextInt(180224);
        Assert.assertTrue((String)("Missed: " + rand), (13312L > rand - pool.getInputFiles(rand, files) ? 1 : 0) != 0);
        conf.setLong("gridmix.min.file.size", 0L);
        pool.refresh();
        files.clear();
        Assert.assertEquals((long)186368L, (long)pool.getInputFiles(Long.MAX_VALUE, files));
    }

    void checkSplitEq(FileSystem fs, CombineFileSplit split, long bytes) throws Exception {
        long splitBytes = 0L;
        HashSet<Path> uniq = new HashSet<Path>();
        for (int i = 0; i < split.getNumPaths(); ++i) {
            splitBytes += split.getLength(i);
            Assert.assertTrue((split.getLength(i) <= fs.getFileStatus(split.getPath(i)).getLen() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)uniq.contains(split.getPath(i)));
            uniq.add(split.getPath(i));
        }
        Assert.assertEquals((long)bytes, (long)splitBytes);
    }

    @Test
    public void testStriper() throws Exception {
        Random r = new Random();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        conf.setLong("gridmix.min.file.size", 3072L);
        1 pool = new /* Unavailable Anonymous Inner Class!! */;
        pool.refresh();
        int expectedPoolSize = 180224;
        InputStriper striper = new InputStriper((FilePool)pool, 180224L);
        int last = 0;
        int i = 0;
        while (i < 180224) {
            this.checkSplitEq(fs, striper.splitFor((FilePool)pool, (long)last, 0), (long)last);
            last = Math.min(180224 - (i += last), r.nextInt(180224));
        }
        InputStriper striper2 = new InputStriper((FilePool)pool, 180224L);
        this.checkSplitEq(fs, striper2.splitFor((FilePool)pool, 180224L, 0), 180224L);
    }
}

