/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.DebugJobProducer;
import org.apache.hadoop.mapred.gridmix.TestHighRamJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.tools.rumen.JobStory;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestHighRamJob {
    private static void testHighRamConfig(long jobMapMB, long jobReduceMB, long clusterMapMB, long clusterReduceMB, long simulatedClusterMapMB, long simulatedClusterReduceMB, long expectedMapMB, long expectedReduceMB, Configuration gConf) throws IOException {
        Configuration simulatedJobConf = new Configuration(gConf);
        simulatedJobConf.setLong("mapreduce.cluster.mapmemory.mb", simulatedClusterMapMB);
        simulatedJobConf.setLong("mapreduce.cluster.reducememory.mb", simulatedClusterReduceMB);
        Configuration sourceConf = new Configuration();
        sourceConf.setLong("mapreduce.map.memory.mb", jobMapMB);
        sourceConf.setLong("mapreduce.cluster.mapmemory.mb", clusterMapMB);
        sourceConf.setLong("mapreduce.reduce.memory.mb", jobReduceMB);
        sourceConf.setLong("mapreduce.cluster.reducememory.mb", clusterReduceMB);
        DebugJobProducer.MockJob story = new DebugJobProducer.MockJob(sourceConf);
        DummyGridmixJob job = new DummyGridmixJob(simulatedJobConf, (JobStory)story);
        Job simulatedJob = job.getJob();
        Configuration simulatedConf = simulatedJob.getConfiguration();
        Assert.assertEquals((long)expectedMapMB, (long)simulatedConf.getLong("mapreduce.map.memory.mb", 1024L));
        Assert.assertEquals((long)expectedReduceMB, (long)simulatedConf.getLong("mapreduce.reduce.memory.mb", 1024L));
    }

    @Test
    public void testHighRamFeatureEmulation() throws IOException {
        Configuration gridmixConf = new Configuration();
        gridmixConf.setBoolean("gridmix.highram-emulation.enable", false);
        TestHighRamJob.testHighRamConfig((long)10L, (long)20L, (long)5L, (long)10L, (long)1024L, (long)1024L, (long)1024L, (long)1024L, (Configuration)gridmixConf);
        gridmixConf = new Configuration();
        gridmixConf.setLong("mapred.task.limit.maxvmem", 0x1400000L);
        TestHighRamJob.testHighRamConfig((long)10L, (long)20L, (long)5L, (long)10L, (long)5L, (long)10L, (long)10L, (long)20L, (Configuration)gridmixConf);
        gridmixConf = new Configuration();
        gridmixConf.setLong("mapreduce.jobtracker.maxmapmemory.mb", 100L);
        gridmixConf.setLong("mapreduce.jobtracker.maxreducememory.mb", 300L);
        TestHighRamJob.testHighRamConfig((long)10L, (long)45L, (long)5L, (long)15L, (long)50L, (long)100L, (long)100L, (long)300L, (Configuration)gridmixConf);
        gridmixConf = new Configuration();
        gridmixConf.setLong("mapred.task.limit.maxvmem", 0x4600000L);
        Boolean failed = null;
        try {
            TestHighRamJob.testHighRamConfig((long)10L, (long)45L, (long)5L, (long)15L, (long)50L, (long)100L, (long)100L, (long)300L, (Configuration)gridmixConf);
            failed = false;
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertNotNull((Object)failed);
        Assert.assertTrue((String)"Exception expected for exceeding map memory limit (deprecation)!", (boolean)failed);
        gridmixConf = new Configuration();
        gridmixConf.setLong("mapred.task.limit.maxvmem", 0x9600000L);
        failed = null;
        try {
            TestHighRamJob.testHighRamConfig((long)10L, (long)45L, (long)5L, (long)15L, (long)50L, (long)100L, (long)100L, (long)300L, (Configuration)gridmixConf);
            failed = false;
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertNotNull((Object)failed);
        Assert.assertTrue((String)"Exception expected for exceeding reduce memory limit (deprecation)!", (boolean)failed);
        gridmixConf = new Configuration();
        gridmixConf.setLong("mapreduce.jobtracker.maxmapmemory.mb", 70L);
        failed = null;
        try {
            TestHighRamJob.testHighRamConfig((long)10L, (long)45L, (long)5L, (long)15L, (long)50L, (long)100L, (long)100L, (long)300L, (Configuration)gridmixConf);
            failed = false;
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertNotNull((Object)failed);
        Assert.assertTrue((String)"Exception expected for exceeding map memory limit!", (boolean)failed);
        gridmixConf = new Configuration();
        gridmixConf.setLong("mapreduce.jobtracker.maxreducememory.mb", 200L);
        failed = null;
        try {
            TestHighRamJob.testHighRamConfig((long)10L, (long)45L, (long)5L, (long)15L, (long)50L, (long)100L, (long)100L, (long)300L, (Configuration)gridmixConf);
            failed = false;
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertNotNull((Object)failed);
        Assert.assertTrue((String)"Exception expected for exceeding reduce memory limit!", (boolean)failed);
    }
}

