/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.DistributedCacheEmulator;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.SerialJobFactory;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.tools.rumen.JobStoryProducer;

public class SerialJobFactory
extends JobFactory<Statistics.JobStats> {
    public static final Log LOG = LogFactory.getLog(SerialJobFactory.class);
    private final Condition jobCompleted;

    public SerialJobFactory(JobSubmitter submitter, JobStoryProducer jobProducer, Path scratch, Configuration conf, CountDownLatch startFlag, UserResolver resolver) throws IOException {
        super(submitter, jobProducer, scratch, conf, startFlag, resolver);
        this.jobCompleted = this.lock.newCondition();
    }

    public Thread createReaderThread() {
        return new SerialReaderThread(this, "SerialJobFactory");
    }

    public void update(Statistics.JobStats item) {
        this.lock.lock();
        try {
            this.jobCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() {
        LOG.info((Object)" Starting Serial submission ");
        this.rThread.start();
    }

    void setDistCacheEmulator(DistributedCacheEmulator e) {
        this.jobCreator.setDistCacheEmulator(e);
    }

    static /* synthetic */ Condition access$000(SerialJobFactory x0) {
        return x0.jobCompleted;
    }
}

