/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.FileQueue;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFileQueue {
    static final Log LOG = LogFactory.getLog(TestFileQueue.class);
    static final int NFILES = 4;
    static final int BLOCK = 256;
    static final Path[] paths = new Path[4];
    static final String[] loc = new String[4];
    static final long[] start = new long[4];
    static final long[] len = new long[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path p = new Path(System.getProperty("test.build.data", "/tmp"), "testFileQueue").makeQualified(fs);
        fs.delete(p, true);
        byte[] b = new byte[256];
        for (int i = 0; i < 4; ++i) {
            Arrays.fill(b, (byte)(65 + i));
            TestFileQueue.paths[i] = new Path(p, "" + (char)(65 + i));
            try (FSDataOutputStream f = null;){
                f = fs.create(paths[i]);
                f.write(b);
                continue;
            }
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path p = new Path(System.getProperty("test.build.data", "/tmp"), "testFileQueue").makeQualified(fs);
        fs.delete(p, true);
    }

    static ByteArrayOutputStream fillVerif() throws IOException {
        byte[] b = new byte[256];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < 4; ++i) {
            Arrays.fill(b, (byte)(65 + i));
            out.write(b, 0, (int)len[i]);
        }
        return out;
    }

    @Test
    public void testRepeat() throws Exception {
        Configuration conf = new Configuration();
        Arrays.fill(loc, "");
        Arrays.fill(start, 0L);
        Arrays.fill(len, 256L);
        ByteArrayOutputStream out = TestFileQueue.fillVerif();
        FileQueue q = new FileQueue(new CombineFileSplit(paths, start, len, loc), conf);
        byte[] verif = out.toByteArray();
        byte[] check = new byte[2048];
        q.read(check, 0, 1024);
        Assert.assertArrayEquals((byte[])verif, (byte[])Arrays.copyOf(check, 1024));
        byte[] verif2 = new byte[2048];
        System.arraycopy(verif, 0, verif2, 0, verif.length);
        System.arraycopy(verif, 0, verif2, verif.length, verif.length);
        q.read(check, 0, 2048);
        Assert.assertArrayEquals((byte[])verif2, (byte[])check);
    }

    @Test
    public void testUneven() throws Exception {
        Configuration conf = new Configuration();
        Arrays.fill(loc, "");
        Arrays.fill(start, 0L);
        Arrays.fill(len, 256L);
        int B2 = 128;
        for (int i = 0; i < 4; i += 2) {
            int n = i;
            start[n] = start[n] + 128L;
            int n2 = i;
            len[n2] = len[n2] - 128L;
        }
        FileQueue q = new FileQueue(new CombineFileSplit(paths, start, len, loc), conf);
        ByteArrayOutputStream out = TestFileQueue.fillVerif();
        byte[] verif = out.toByteArray();
        byte[] check = new byte[768];
        q.read(check, 0, verif.length);
        Assert.assertArrayEquals((byte[])verif, (byte[])Arrays.copyOf(check, verif.length));
        q.read(check, 0, verif.length);
        Assert.assertArrayEquals((byte[])verif, (byte[])Arrays.copyOf(check, verif.length));
    }

    @Test
    public void testEmpty() throws Exception {
        Configuration conf = new Configuration();
        FileQueue q = new FileQueue(new CombineFileSplit(new Path[0], new long[0], new long[0], new String[0]), conf);
    }
}

