/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.bkjournal;

import com.google.common.base.Charsets;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.contrib.bkjournal.BKJournalProtos;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

class CurrentInprogress {
    static final Log LOG = LogFactory.getLog(CurrentInprogress.class);
    private final ZooKeeper zkc;
    private final String currentInprogressNode;
    private volatile int versionNumberForPermission = -1;
    private final String hostName = InetAddress.getLocalHost().toString();

    CurrentInprogress(ZooKeeper zkc, String lockpath) throws IOException {
        this.currentInprogressNode = lockpath;
        this.zkc = zkc;
    }

    void init() throws IOException {
        try {
            Stat isCurrentInprogressNodeExists = this.zkc.exists(this.currentInprogressNode, false);
            if (isCurrentInprogressNodeExists == null) {
                try {
                    this.zkc.create(this.currentInprogressNode, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.currentInprogressNode + " already created by other process."), (Throwable)e);
                    }
                }
            }
        }
        catch (KeeperException e) {
            throw new IOException("Exception accessing Zookeeper", e);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted accessing Zookeeper", ie);
        }
    }

    void update(String path) throws IOException {
        BKJournalProtos.CurrentInprogressProto.Builder builder = BKJournalProtos.CurrentInprogressProto.newBuilder();
        builder.setPath(path).setHostname(this.hostName);
        String content = TextFormat.printToString((MessageOrBuilder)builder.build());
        try {
            this.zkc.setData(this.currentInprogressNode, content.getBytes(Charsets.UTF_8), this.versionNumberForPermission);
        }
        catch (KeeperException e) {
            throw new IOException("Exception when setting the data [" + content + "] to CurrentInprogress. ", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while setting the data [" + content + "] to CurrentInprogress", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updated data[" + content + "] to CurrentInprogress"));
        }
    }

    String read() throws IOException {
        Stat stat = new Stat();
        byte[] data = null;
        try {
            data = this.zkc.getData(this.currentInprogressNode, false, stat);
        }
        catch (KeeperException e) {
            throw new IOException("Exception while reading the data from " + this.currentInprogressNode, e);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while reading data from " + this.currentInprogressNode, e);
        }
        this.versionNumberForPermission = stat.getVersion();
        if (data != null) {
            BKJournalProtos.CurrentInprogressProto.Builder builder = BKJournalProtos.CurrentInprogressProto.newBuilder();
            TextFormat.merge((CharSequence)new String(data, Charsets.UTF_8), (Message.Builder)builder);
            if (!builder.isInitialized()) {
                throw new IOException("Invalid/Incomplete data in znode");
            }
            return builder.build().getPath();
        }
        LOG.debug((Object)"No data available in CurrentInprogress");
        return null;
    }

    void clear() throws IOException {
        try {
            this.zkc.setData(this.currentInprogressNode, null, this.versionNumberForPermission);
        }
        catch (KeeperException e) {
            throw new IOException("Exception when setting the data to CurrentInprogress node", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted when setting the data to CurrentInprogress node", e);
        }
        LOG.debug((Object)"Cleared the data from CurrentInprogress");
    }
}

