/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.servlet;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.lib.servlet.HostnameFilter;
import org.apache.hadoop.lib.servlet.MDCFilter;
import org.apache.hadoop.lib.servlet.TestMDCFilter;
import org.apache.hadoop.test.HTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.MDC;

public class TestMDCFilter
extends HTestCase {
    @Test
    public void mdc() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn(null);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"METHOD");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/pathinfo");
        ServletResponse response = (ServletResponse)Mockito.mock(ServletResponse.class);
        AtomicBoolean invoked = new AtomicBoolean();
        1 chain = new /* Unavailable Anonymous Inner Class!! */;
        MDC.clear();
        MDCFilter filter = new MDCFilter();
        filter.init(null);
        filter.doFilter((ServletRequest)request, response, (FilterChain)chain);
        Assert.assertTrue((boolean)invoked.get());
        Assert.assertNull((Object)MDC.get((String)"hostname"));
        Assert.assertNull((Object)MDC.get((String)"user"));
        Assert.assertNull((Object)MDC.get((String)"method"));
        Assert.assertNull((Object)MDC.get((String)"path"));
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        invoked.set(false);
        chain = new /* Unavailable Anonymous Inner Class!! */;
        filter.doFilter((ServletRequest)request, response, (FilterChain)chain);
        Assert.assertTrue((boolean)invoked.get());
        HostnameFilter.HOSTNAME_TL.set("HOST");
        invoked.set(false);
        chain = new /* Unavailable Anonymous Inner Class!! */;
        filter.doFilter((ServletRequest)request, response, (FilterChain)chain);
        Assert.assertTrue((boolean)invoked.get());
        HostnameFilter.HOSTNAME_TL.remove();
        filter.destroy();
    }
}

