/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.BaseTestHttpFSWith;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.TestDirHelper;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHttpFSFileSystemLocalFileSystem
extends BaseTestHttpFSWith {
    private static String PATH_PREFIX;

    public TestHttpFSFileSystemLocalFileSystem(BaseTestHttpFSWith.Operation operation) {
        super(operation);
    }

    protected Path getProxiedFSTestDir() {
        return this.addPrefix(new Path(TestDirHelper.getTestDir().getAbsolutePath()));
    }

    protected String getProxiedFSURI() {
        return "file:///";
    }

    protected Configuration getProxiedFSConf() {
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", this.getProxiedFSURI());
        return conf;
    }

    protected Path addPrefix(Path path) {
        return Path.mergePaths((Path)new Path(PATH_PREFIX), (Path)path);
    }

    protected void testSetPermission() throws Exception {
        if (Path.WINDOWS) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            Path path = new Path(this.getProxiedFSTestDir(), "foodir");
            fs.mkdirs(path);
            fs = this.getHttpFSFileSystem();
            FsPermission permission1 = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE);
            fs.setPermission(path, permission1);
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            FileStatus status1 = fs.getFileStatus(path);
            fs.close();
            FsPermission permission2 = status1.getPermission();
            Assert.assertEquals((Object)permission2, (Object)permission1);
        } else {
            super.testSetPermission();
        }
    }

    static {
        new TestDirHelper();
        String prefix = System.getProperty("test.build.dir", "target/test-dir") + "/local";
        File file = new File(prefix);
        file.mkdirs();
        PATH_PREFIX = file.getAbsolutePath();
    }
}

