/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.server;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.TestBaseService;
import org.apache.hadoop.test.HTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBaseService
extends HTestCase {
    @Test
    public void baseService() throws Exception {
        MyService service = new MyService();
        Assert.assertNull((Object)service.getInterface());
        Assert.assertEquals((Object)service.getPrefix(), (Object)"myservice");
        Assert.assertEquals((long)service.getServiceDependencies().length, (long)0L);
        Server server = (Server)Mockito.mock(Server.class);
        Configuration conf = new Configuration(false);
        conf.set("server.myservice.foo", "FOO");
        conf.set("server.myservice1.bar", "BAR");
        Mockito.when((Object)server.getConfig()).thenReturn((Object)conf);
        Mockito.when((Object)server.getPrefixedName("myservice.foo")).thenReturn((Object)"server.myservice.foo");
        Mockito.when((Object)server.getPrefixedName("myservice.")).thenReturn((Object)"server.myservice.");
        service.init(server);
        Assert.assertEquals((Object)service.getPrefixedName("foo"), (Object)"server.myservice.foo");
        Assert.assertEquals((long)service.getServiceConfig().size(), (long)1L);
        Assert.assertEquals((Object)service.getServiceConfig().get("foo"), (Object)"FOO");
        Assert.assertTrue((boolean)MyService.INIT);
    }
}

