/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.wsrs.Param;

@InterfaceAudience.Private
public abstract class StringParam
extends Param<String> {
    private Pattern pattern;

    public StringParam(String name, String defaultValue) {
        this(name, defaultValue, null);
    }

    public StringParam(String name, String defaultValue, Pattern pattern) {
        super(name, (Object)defaultValue);
        this.pattern = pattern;
        this.parseParam(defaultValue);
    }

    public String parseParam(String str) {
        try {
            if (str != null && (str = str.trim()).length() > 0) {
                this.value = this.parse(str);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter [{0}], invalid value [{1}], value must be [{2}]", this.getName(), str, this.getDomain()));
        }
        return (String)this.value;
    }

    protected String parse(String str) throws Exception {
        if (this.pattern != null && !this.pattern.matcher(str).matches()) {
            throw new IllegalArgumentException("Invalid value");
        }
        return str;
    }

    protected String getDomain() {
        return this.pattern == null ? "a string" : this.pattern.pattern();
    }
}

