/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.nfs.TestOutOfOrderWrite;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.request.CREATE3Request;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.oncrpc.RegistrationClient;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.jboss.netty.channel.Channel;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestOutOfOrderWrite {
    public static final Log LOG = LogFactory.getLog(TestOutOfOrderWrite.class);
    static FileHandle handle = null;
    static Channel channel;
    static byte[] data1;
    static byte[] data2;
    static byte[] data3;

    static XDR create() {
        XDR request = new XDR();
        RpcCall.getInstance((int)-2147483572, (int)100003, (int)3, (int)Nfs3Constant.NFSPROC3.CREATE.getValue(), (Credentials)new CredentialsNone(), (Verifier)new VerifierNone()).write(request);
        SetAttr3 objAttr = new SetAttr3();
        CREATE3Request createReq = new CREATE3Request(new FileHandle("/"), "out-of-order-write" + System.currentTimeMillis(), 0, objAttr, 0L);
        createReq.serialize(request);
        return request;
    }

    static XDR write(FileHandle handle, int xid, long offset, int count, byte[] data) {
        XDR request = new XDR();
        RpcCall.getInstance((int)xid, (int)100003, (int)3, (int)Nfs3Constant.NFSPROC3.CREATE.getValue(), (Credentials)new CredentialsNone(), (Verifier)new VerifierNone()).write(request);
        WRITE3Request write1 = new WRITE3Request(handle, offset, count, Nfs3Constant.WriteStableHow.UNSTABLE, ByteBuffer.wrap(data));
        write1.serialize(request);
        return request;
    }

    static void testRequest(XDR request) {
        RegistrationClient registrationClient = new RegistrationClient("localhost", 111, request);
        registrationClient.run();
    }

    public static void main(String[] args) throws InterruptedException {
        Arrays.fill(data1, (byte)7);
        Arrays.fill(data2, (byte)8);
        Arrays.fill(data3, (byte)9);
        NfsConfiguration conf = new NfsConfiguration();
        WriteClient client = new WriteClient("localhost", conf.getInt("nfs.server.port", 2049), TestOutOfOrderWrite.create(), Boolean.valueOf(false));
        client.run();
        while (handle == null) {
            Thread.sleep(1000L);
            System.out.println("handle is still null...");
        }
        LOG.info((Object)"Send write1 request");
        XDR writeReq = TestOutOfOrderWrite.write((FileHandle)handle, (int)-2147483556, (long)2000L, (int)1000, (byte[])data3);
        Nfs3Utils.writeChannel((Channel)channel, (XDR)writeReq, (int)1);
        writeReq = TestOutOfOrderWrite.write((FileHandle)handle, (int)-2147483555, (long)1000L, (int)1000, (byte[])data2);
        Nfs3Utils.writeChannel((Channel)channel, (XDR)writeReq, (int)2);
        writeReq = TestOutOfOrderWrite.write((FileHandle)handle, (int)-2147483554, (long)0L, (int)1000, (byte[])data1);
        Nfs3Utils.writeChannel((Channel)channel, (XDR)writeReq, (int)3);
    }

    static {
        data1 = new byte[1000];
        data2 = new byte[1000];
        data3 = new byte[1000];
    }
}

