/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.mount.Mountd;
import org.apache.hadoop.hdfs.nfs.mount.RpcProgramMountd;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3;
import org.junit.Assert;
import org.junit.Test;

public class TestExportsTable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportPoint() throws IOException {
        NfsConfiguration config = new NfsConfiguration();
        MiniDFSCluster cluster = null;
        String exportPoint = "/myexport1";
        config.setStrings("nfs.export.point", new String[]{exportPoint});
        config.setInt("nfs3.mountd.port", 0);
        config.setInt("nfs3.server.port", 0);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
            cluster.waitActive();
            Nfs3 nfsServer = new Nfs3(config);
            nfsServer.startServiceInternal(false);
            Mountd mountd = nfsServer.getMountd();
            RpcProgramMountd rpcMount = (RpcProgramMountd)mountd.getRpcProgram();
            Assert.assertTrue((rpcMount.getExports().size() == 1 ? 1 : 0) != 0);
            String exportInMountd = (String)rpcMount.getExports().get(0);
            Assert.assertTrue((boolean)exportInMountd.equals(exportPoint));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

