/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.nfs.nfs3.AsyncDataService;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;

public class AsyncDataService {
    static final Log LOG = LogFactory.getLog(AsyncDataService.class);
    private static final int CORE_THREADS_PER_VOLUME = 1;
    private static final int MAXIMUM_THREADS_PER_VOLUME = 4;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private final ThreadGroup threadGroup = new ThreadGroup("async data service");
    private ThreadFactory threadFactory = new /* Unavailable Anonymous Inner Class!! */;
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.threadFactory);

    public AsyncDataService() {
        this.executor.allowCoreThreadTimeOut(true);
    }

    synchronized void execute(Runnable task) {
        if (this.executor == null) {
            throw new RuntimeException("AsyncDataService is already shutdown");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Current active thread number: " + this.executor.getActiveCount() + " queue size: " + this.executor.getQueue().size() + " scheduled task number: " + this.executor.getTaskCount()));
        }
        this.executor.execute(task);
    }

    synchronized void shutdown() {
        if (this.executor == null) {
            LOG.warn((Object)"AsyncDataService has already shut down.");
        } else {
            LOG.info((Object)"Shutting down all async data service threads...");
            this.executor.shutdown();
            this.executor = null;
            LOG.info((Object)"All async data service threads have been shut down");
        }
    }

    void writeAsync(OpenFileCtx openFileCtx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scheduling write back task for fileId: " + openFileCtx.getLatestAttr().getFileId()));
        }
        WriteBackTask wbTask = new WriteBackTask(openFileCtx);
        this.execute((Runnable)wbTask);
    }

    static /* synthetic */ ThreadGroup access$000(AsyncDataService x0) {
        return x0.threadGroup;
    }
}

