/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3;
import org.apache.hadoop.hdfs.nfs.nfs3.OffsetRange;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteManager;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.request.CREATE3Request;
import org.apache.hadoop.nfs.nfs3.request.READ3Request;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.nfs.nfs3.response.CREATE3Response;
import org.apache.hadoop.nfs.nfs3.response.READ3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.SecurityHandler;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.apache.hadoop.security.ShellBasedIdMapping;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.jboss.netty.channel.Channel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestWrites {
    @Test
    public void testAlterWriteRequest() throws IOException {
        int len = 20;
        byte[] data = new byte[len];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        for (int i = 0; i < len; ++i) {
            buffer.put((byte)i);
        }
        buffer.flip();
        int originalCount = buffer.array().length;
        WRITE3Request request = new WRITE3Request(new FileHandle(), 0L, data.length, Nfs3Constant.WriteStableHow.UNSTABLE, buffer);
        WriteCtx writeCtx1 = new WriteCtx(request.getHandle(), request.getOffset(), request.getCount(), -1, request.getStableHow(), request.getData(), null, 1, false, WriteCtx.DataState.NO_DUMP);
        Assert.assertTrue((writeCtx1.getData().array().length == originalCount ? 1 : 0) != 0);
        OpenFileCtx.alterWriteRequest((WRITE3Request)request, (long)12L);
        WriteCtx writeCtx2 = new WriteCtx(request.getHandle(), request.getOffset(), request.getCount(), originalCount, request.getStableHow(), request.getData(), null, 2, false, WriteCtx.DataState.NO_DUMP);
        ByteBuffer appendedData = writeCtx2.getData();
        int position = appendedData.position();
        int limit = appendedData.limit();
        Assert.assertTrue((position == 12 ? 1 : 0) != 0);
        Assert.assertTrue((limit - position == 8 ? 1 : 0) != 0);
        Assert.assertTrue((appendedData.get(position) == 12 ? 1 : 0) != 0);
        Assert.assertTrue((appendedData.get(position + 1) == 13 ? 1 : 0) != 0);
        Assert.assertTrue((appendedData.get(position + 2) == 14 ? 1 : 0) != 0);
        Assert.assertTrue((appendedData.get(position + 7) == 19 ? 1 : 0) != 0);
        buffer.position(0);
        request = new WRITE3Request(new FileHandle(), 0L, data.length, Nfs3Constant.WriteStableHow.UNSTABLE, buffer);
        OpenFileCtx.alterWriteRequest((WRITE3Request)request, (long)1L);
        WriteCtx writeCtx3 = new WriteCtx(request.getHandle(), request.getOffset(), request.getCount(), originalCount, request.getStableHow(), request.getData(), null, 2, false, WriteCtx.DataState.NO_DUMP);
        appendedData = writeCtx3.getData();
        position = appendedData.position();
        limit = appendedData.limit();
        Assert.assertTrue((position == 1 ? 1 : 0) != 0);
        Assert.assertTrue((limit - position == 19 ? 1 : 0) != 0);
        Assert.assertTrue((appendedData.get(position) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((appendedData.get(position + 18) == 19 ? 1 : 0) != 0);
        buffer.position(0);
        request = new WRITE3Request(new FileHandle(), 0L, data.length, Nfs3Constant.WriteStableHow.UNSTABLE, buffer);
        OpenFileCtx.alterWriteRequest((WRITE3Request)request, (long)19L);
        WriteCtx writeCtx4 = new WriteCtx(request.getHandle(), request.getOffset(), request.getCount(), originalCount, request.getStableHow(), request.getData(), null, 2, false, WriteCtx.DataState.NO_DUMP);
        appendedData = writeCtx4.getData();
        position = appendedData.position();
        limit = appendedData.limit();
        Assert.assertTrue((position == 19 ? 1 : 0) != 0);
        Assert.assertTrue((limit - position == 1 ? 1 : 0) != 0);
        Assert.assertTrue((appendedData.get(position) == 19 ? 1 : 0) != 0);
    }

    @Test
    public void testCheckCommit() throws IOException {
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)0L);
        NfsConfiguration conf = new NfsConfiguration();
        conf.setBoolean("nfs.large.file.upload", false);
        OpenFileCtx ctx = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, (IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)conf), false, conf);
        ctx.setActiveStatusForTest(false);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        OpenFileCtx.COMMIT_STATUS ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_CTX ? 1 : 0) != 0);
        ctx.getPendingWritesForTest().put(new OffsetRange(5L, 10L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_WITH_PENDING_WRITE ? 1 : 0) != 0);
        ctx.setActiveStatusForTest(true);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)10L);
        ctx.setNextOffsetForTest(10L);
        OpenFileCtx.COMMIT_STATUS status = ctx.checkCommitInternal(5L, null, 1, attr, false);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_DO_SYNC ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 5L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED ? 1 : 0) != 0);
        status = ctx.checkCommitInternal(10L, ch, 1, attr, false);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_DO_SYNC ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 10L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED ? 1 : 0) != 0);
        ConcurrentNavigableMap commits = ctx.getPendingCommitsForTest();
        Assert.assertTrue((commits.size() == 0 ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 11L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_WAIT ? 1 : 0) != 0);
        Assert.assertTrue((commits.size() == 1 ? 1 : 0) != 0);
        long key = (Long)commits.firstKey();
        Assert.assertTrue((key == 11L ? 1 : 0) != 0);
        commits.remove(new Long(11L));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_WAIT ? 1 : 0) != 0);
        Assert.assertTrue((commits.size() == 1 ? 1 : 0) != 0);
        key = (Long)commits.firstKey();
        Assert.assertTrue((key == 9L ? 1 : 0) != 0);
        ctx.getPendingWritesForTest().remove(new OffsetRange(5L, 10L));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED ? 1 : 0) != 0);
    }

    @Test
    public void testCheckCommitLargeFileUpload() throws IOException {
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)0L);
        NfsConfiguration conf = new NfsConfiguration();
        conf.setBoolean("nfs.large.file.upload", true);
        OpenFileCtx ctx = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, (IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)conf), false, conf);
        ctx.setActiveStatusForTest(false);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        OpenFileCtx.COMMIT_STATUS ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_CTX ? 1 : 0) != 0);
        ctx.getPendingWritesForTest().put(new OffsetRange(10L, 15L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_WITH_PENDING_WRITE ? 1 : 0) != 0);
        ctx.setActiveStatusForTest(true);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)8L);
        ctx.setNextOffsetForTest(10L);
        OpenFileCtx.COMMIT_STATUS status = ctx.checkCommitInternal(5L, null, 1, attr, false);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_DO_SYNC ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 5L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED ? 1 : 0) != 0);
        status = ctx.checkCommitInternal(10L, ch, 1, attr, false);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 10L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT ? 1 : 0) != 0);
        ConcurrentNavigableMap commits = ctx.getPendingCommitsForTest();
        Assert.assertTrue((commits.size() == 1 ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 16L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((commits.size() == 1 ? 1 : 0) != 0);
        commits.remove(new Long(10L));
        ret = ctx.checkCommitInternal(0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT ? 1 : 0) != 0);
        ret = ctx.checkCommitInternal(9L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT ? 1 : 0) != 0);
        Assert.assertTrue((commits.size() == 2 ? 1 : 0) != 0);
        ctx.getPendingWritesForTest().remove(new OffsetRange(10L, 15L));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT ? 1 : 0) != 0);
        ctx.setNextOffsetForTest(8L);
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, false);
        Assert.assertTrue((ret == OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED ? 1 : 0) != 0);
    }

    @Test
    public void testCheckCommitAixCompatMode() throws IOException {
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        NfsConfiguration conf = new NfsConfiguration();
        conf.setBoolean("nfs.large.file.upload", false);
        OpenFileCtx ctx = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, (IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)new NfsConfiguration()), true, conf);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)2L);
        OpenFileCtx.COMMIT_STATUS status = ctx.checkCommitInternal(5L, null, 1, attr, false);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED ? 1 : 0) != 0);
        ctx.getPendingWritesForTest().put(new OffsetRange(0L, 10L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        Mockito.when((Object)fos.getPos()).thenReturn((Object)10L);
        ctx.setNextOffsetForTest(10L);
        status = ctx.checkCommitInternal(5L, null, 1, attr, false);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_DO_SYNC ? 1 : 0) != 0);
    }

    @Test
    public void testCheckCommitFromRead() throws IOException {
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)0L);
        NfsConfiguration config = new NfsConfiguration();
        config.setBoolean("nfs.large.file.upload", false);
        OpenFileCtx ctx = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, (IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)config), false, config);
        FileHandle h = new FileHandle(1L);
        WriteManager wm = new WriteManager((IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)config), config, false);
        Assert.assertTrue((boolean)wm.addOpenFileStream(h, ctx));
        ctx.setActiveStatusForTest(false);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        OpenFileCtx.COMMIT_STATUS ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_CTX, (Object)ret);
        Assert.assertEquals((long)0L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
        ctx.getPendingWritesForTest().put(new OffsetRange(10L, 15L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_WITH_PENDING_WRITE, (Object)ret);
        Assert.assertEquals((long)5L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
        ctx.setActiveStatusForTest(true);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)10L);
        ctx.setNextOffsetForTest(10L);
        OpenFileCtx.COMMIT_STATUS status = ctx.checkCommitInternal(5L, ch, 1, attr, false);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_DO_SYNC, (Object)status);
        ret = ctx.checkCommit(dfsClient, 5L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED, (Object)ret);
        Assert.assertEquals((long)0L, (long)wm.commitBeforeRead(dfsClient, h, 5L));
        status = ctx.checkCommitInternal(10L, ch, 1, attr, true);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_DO_SYNC ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 10L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED, (Object)ret);
        Assert.assertEquals((long)0L, (long)wm.commitBeforeRead(dfsClient, h, 10L));
        ConcurrentNavigableMap commits = ctx.getPendingCommitsForTest();
        Assert.assertTrue((commits.size() == 0 ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 11L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_WAIT, (Object)ret);
        Assert.assertEquals((long)0L, (long)commits.size());
        Assert.assertEquals((long)10008L, (long)wm.commitBeforeRead(dfsClient, h, 11L));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_WAIT, (Object)ret);
        Assert.assertEquals((long)0L, (long)commits.size());
        Assert.assertEquals((long)10008L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
        ctx.getPendingWritesForTest().remove(new OffsetRange(10L, 15L));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED, (Object)ret);
        Assert.assertEquals((long)0L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
    }

    @Test
    public void testCheckCommitFromReadLargeFileUpload() throws IOException {
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)0L);
        NfsConfiguration config = new NfsConfiguration();
        config.setBoolean("nfs.large.file.upload", true);
        OpenFileCtx ctx = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, (IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)config), false, config);
        FileHandle h = new FileHandle(1L);
        WriteManager wm = new WriteManager((IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)config), config, false);
        Assert.assertTrue((boolean)wm.addOpenFileStream(h, ctx));
        ctx.setActiveStatusForTest(false);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        OpenFileCtx.COMMIT_STATUS ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_CTX, (Object)ret);
        Assert.assertEquals((long)0L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
        ctx.getPendingWritesForTest().put(new OffsetRange(10L, 15L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_INACTIVE_WITH_PENDING_WRITE, (Object)ret);
        Assert.assertEquals((long)5L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
        ctx.setActiveStatusForTest(true);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)6L);
        ctx.setNextOffsetForTest(10L);
        OpenFileCtx.COMMIT_STATUS status = ctx.checkCommitInternal(5L, ch, 1, attr, false);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_DO_SYNC, (Object)status);
        ret = ctx.checkCommit(dfsClient, 5L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_FINISHED, (Object)ret);
        Assert.assertEquals((long)0L, (long)wm.commitBeforeRead(dfsClient, h, 5L));
        status = ctx.checkCommitInternal(9L, ch, 1, attr, true);
        Assert.assertTrue((status == OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 9L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT, (Object)ret);
        Assert.assertEquals((long)10008L, (long)wm.commitBeforeRead(dfsClient, h, 9L));
        ConcurrentNavigableMap commits = ctx.getPendingCommitsForTest();
        Assert.assertTrue((commits.size() == 0 ? 1 : 0) != 0);
        ret = ctx.checkCommit(dfsClient, 16L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_SUCCESS, (Object)ret);
        Assert.assertEquals((long)0L, (long)commits.size());
        Assert.assertEquals((long)0L, (long)wm.commitBeforeRead(dfsClient, h, 16L));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT, (Object)ret);
        Assert.assertEquals((long)0L, (long)commits.size());
        Assert.assertEquals((long)10008L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
        ctx.getPendingWritesForTest().remove(new OffsetRange(10L, 15L));
        ret = ctx.checkCommit(dfsClient, 0L, ch, 1, attr, true);
        Assert.assertEquals((Object)OpenFileCtx.COMMIT_STATUS.COMMIT_SPECIAL_WAIT, (Object)ret);
        Assert.assertEquals((long)10008L, (long)wm.commitBeforeRead(dfsClient, h, 0L));
    }

    private void waitWrite(RpcProgramNfs3 nfsd, FileHandle handle, int maxWaitTime) throws InterruptedException {
        int waitedTime = 0;
        OpenFileCtx ctx = nfsd.getWriteManager().getOpenFileCtxCache().get(handle);
        Assert.assertTrue((ctx != null ? 1 : 0) != 0);
        do {
            Thread.sleep(3000L);
            waitedTime += 3000;
            if (ctx.getPendingWritesForTest().size() != 0) continue;
            return;
        } while (waitedTime < maxWaitTime);
        Assert.fail((String)"Write can't finish.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteStableHow() throws IOException, InterruptedException {
        NfsConfiguration config = new NfsConfiguration();
        DFSClient client = null;
        MiniDFSCluster cluster = null;
        SecurityHandler securityHandler = (SecurityHandler)Mockito.mock(SecurityHandler.class);
        Mockito.when((Object)securityHandler.getUser()).thenReturn((Object)System.getProperty("user.name"));
        String currentUser = System.getProperty("user.name");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(currentUser), "*");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(currentUser), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)config);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
            cluster.waitActive();
            client = new DFSClient(NameNode.getAddress((Configuration)config), (Configuration)config);
            config.setInt("nfs3.mountd.port", 0);
            config.setInt("nfs3.server.port", 0);
            Nfs3 nfs3 = new Nfs3(config);
            nfs3.startServiceInternal(false);
            RpcProgramNfs3 nfsd = (RpcProgramNfs3)nfs3.getRpcProgram();
            HdfsFileStatus status = client.getFileInfo("/");
            FileHandle rootHandle = new FileHandle(status.getFileId());
            CREATE3Request createReq = new CREATE3Request(rootHandle, "file1", 0, new SetAttr3(), 0L);
            XDR createXdr = new XDR();
            createReq.serialize(createXdr);
            CREATE3Response createRsp = nfsd.create(createXdr.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            FileHandle handle = createRsp.getObjHandle();
            byte[] buffer = new byte[10];
            for (int i = 0; i < 10; ++i) {
                buffer[i] = (byte)i;
            }
            WRITE3Request writeReq = new WRITE3Request(handle, 0L, 10, Nfs3Constant.WriteStableHow.DATA_SYNC, ByteBuffer.wrap(buffer));
            XDR writeXdr = new XDR();
            writeReq.serialize(writeXdr);
            nfsd.write(writeXdr.asReadOnlyWrap(), null, 1, securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            this.waitWrite(nfsd, handle, 60000);
            READ3Request readReq = new READ3Request(handle, 0L, 10);
            XDR readXdr = new XDR();
            readReq.serialize(readXdr);
            READ3Response readRsp = nfsd.read(readXdr.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            Assert.assertTrue((boolean)Arrays.equals(buffer, readRsp.getData().array()));
            CREATE3Request createReq2 = new CREATE3Request(rootHandle, "file2", 0, new SetAttr3(), 0L);
            XDR createXdr2 = new XDR();
            createReq2.serialize(createXdr2);
            CREATE3Response createRsp2 = nfsd.create(createXdr2.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            FileHandle handle2 = createRsp2.getObjHandle();
            WRITE3Request writeReq2 = new WRITE3Request(handle2, 0L, 10, Nfs3Constant.WriteStableHow.FILE_SYNC, ByteBuffer.wrap(buffer));
            XDR writeXdr2 = new XDR();
            writeReq2.serialize(writeXdr2);
            nfsd.write(writeXdr2.asReadOnlyWrap(), null, 1, securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            this.waitWrite(nfsd, handle2, 60000);
            READ3Request readReq2 = new READ3Request(handle2, 0L, 10);
            XDR readXdr2 = new XDR();
            readReq2.serialize(readXdr2);
            READ3Response readRsp2 = nfsd.read(readXdr2.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            Assert.assertTrue((boolean)Arrays.equals(buffer, readRsp2.getData().array()));
            status = client.getFileInfo("/file2");
            Assert.assertTrue((status.getLen() == 10L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOOOWrites() throws IOException, InterruptedException {
        NfsConfiguration config = new NfsConfiguration();
        MiniDFSCluster cluster = null;
        int bufSize = 32;
        int numOOO = 3;
        SecurityHandler securityHandler = (SecurityHandler)Mockito.mock(SecurityHandler.class);
        Mockito.when((Object)securityHandler.getUser()).thenReturn((Object)System.getProperty("user.name"));
        String currentUser = System.getProperty("user.name");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(currentUser), "*");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(currentUser), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)config);
        config.setInt("nfs3.mountd.port", 0);
        config.setInt("nfs3.server.port", 0);
        try {
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
            cluster.waitActive();
            Nfs3 nfs3 = new Nfs3(config);
            nfs3.startServiceInternal(false);
            RpcProgramNfs3 nfsd = (RpcProgramNfs3)nfs3.getRpcProgram();
            DFSClient dfsClient = new DFSClient(NameNode.getAddress((Configuration)config), (Configuration)config);
            HdfsFileStatus status = dfsClient.getFileInfo("/");
            FileHandle rootHandle = new FileHandle(status.getFileId());
            CREATE3Request createReq = new CREATE3Request(rootHandle, "out-of-order-write" + System.currentTimeMillis(), 0, new SetAttr3(), 0L);
            XDR createXdr = new XDR();
            createReq.serialize(createXdr);
            CREATE3Response createRsp = nfsd.create(createXdr.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            FileHandle handle = createRsp.getObjHandle();
            byte[][] oooBuf = new byte[3][32];
            for (i = 0; i < 3; ++i) {
                Arrays.fill(oooBuf[i], (byte)i);
            }
            for (i = 0; i < 3; ++i) {
                long offset = (2 - i) * 32;
                WRITE3Request writeReq = new WRITE3Request(handle, offset, 32, Nfs3Constant.WriteStableHow.UNSTABLE, ByteBuffer.wrap(oooBuf[i]));
                XDR writeXdr = new XDR();
                writeReq.serialize(writeXdr);
                nfsd.write(writeXdr.asReadOnlyWrap(), null, 1, securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
            }
            this.waitWrite(nfsd, handle, 60000);
            READ3Request readReq = new READ3Request(handle, 32L, 32);
            XDR readXdr = new XDR();
            readReq.serialize(readXdr);
            READ3Response readRsp = nfsd.read(readXdr.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", config.getInt("nfs.server.port", 2049)));
            Assert.assertTrue((boolean)Arrays.equals(oooBuf[1], readRsp.getData().array()));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testCheckSequential() throws IOException {
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)0L);
        NfsConfiguration config = new NfsConfiguration();
        config.setBoolean("nfs.large.file.upload", false);
        OpenFileCtx ctx = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, (IdMappingServiceProvider)new ShellBasedIdMapping((Configuration)config), false, config);
        ctx.getPendingWritesForTest().put(new OffsetRange(5L, 10L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        ctx.getPendingWritesForTest().put(new OffsetRange(10L, 15L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        ctx.getPendingWritesForTest().put(new OffsetRange(20L, 25L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        Assert.assertTrue((!ctx.checkSequential(5L, 4L) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ctx.checkSequential(9L, 5L));
        Assert.assertTrue((boolean)ctx.checkSequential(10L, 5L));
        Assert.assertTrue((boolean)ctx.checkSequential(14L, 5L));
        Assert.assertTrue((!ctx.checkSequential(15L, 5L) ? 1 : 0) != 0);
        Assert.assertTrue((!ctx.checkSequential(20L, 5L) ? 1 : 0) != 0);
        Assert.assertTrue((!ctx.checkSequential(25L, 5L) ? 1 : 0) != 0);
        Assert.assertTrue((!ctx.checkSequential(999L, 5L) ? 1 : 0) != 0);
    }
}

