/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.AsyncDataService;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtxCache;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteManager;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.nfs.nfs3.response.COMMIT3Response;
import org.apache.hadoop.nfs.nfs3.response.WRITE3Response;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.jboss.netty.channel.Channel;

public class WriteManager {
    public static final Log LOG = LogFactory.getLog(WriteManager.class);
    private final NfsConfiguration config;
    private final IdMappingServiceProvider iug;
    private AsyncDataService asyncDataService;
    private boolean asyncDataServiceStarted = false;
    private final int maxStreams;
    private final boolean aixCompatMode;
    private long streamTimeout;
    private final OpenFileCtxCache fileContextCache;

    boolean addOpenFileStream(FileHandle h, OpenFileCtx ctx) {
        return this.fileContextCache.put(h, ctx);
    }

    WriteManager(IdMappingServiceProvider iug, NfsConfiguration config, boolean aixCompatMode) {
        this.iug = iug;
        this.config = config;
        this.aixCompatMode = aixCompatMode;
        this.streamTimeout = config.getLong("nfs.stream.timeout", 600000L);
        LOG.info((Object)("Stream timeout is " + this.streamTimeout + "ms."));
        if (this.streamTimeout < 10000L) {
            LOG.info((Object)"Reset stream timeout to minimum value 10000ms.");
            this.streamTimeout = 10000L;
        }
        this.maxStreams = config.getInt("nfs.max.open.files", 256);
        LOG.info((Object)("Maximum open streams is " + this.maxStreams));
        this.fileContextCache = new OpenFileCtxCache(config, this.streamTimeout);
    }

    void startAsyncDataService() {
        if (this.asyncDataServiceStarted) {
            return;
        }
        this.fileContextCache.start();
        this.asyncDataService = new AsyncDataService();
        this.asyncDataServiceStarted = true;
    }

    void shutdownAsyncDataService() {
        if (!this.asyncDataServiceStarted) {
            return;
        }
        this.asyncDataServiceStarted = false;
        this.asyncDataService.shutdown();
        this.fileContextCache.shutdown();
    }

    void handleWrite(DFSClient dfsClient, WRITE3Request request, Channel channel, int xid, Nfs3FileAttributes preOpAttr) throws IOException {
        FileHandle fileHandle;
        OpenFileCtx openFileCtx;
        int count = request.getCount();
        byte[] data = request.getData().array();
        if (data.length < count) {
            WRITE3Response response = new WRITE3Response(22);
            Nfs3Utils.writeChannel((Channel)channel, (XDR)response.serialize(new XDR(), xid, (Verifier)new VerifierNone()), (int)xid);
            return;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("handleWrite " + request));
        }
        if ((openFileCtx = this.fileContextCache.get(fileHandle = request.getHandle())) == null) {
            LOG.info((Object)("No opened stream for fileId: " + fileHandle.getFileId()));
            String fileIdPath = Nfs3Utils.getFileIdPath((long)fileHandle.getFileId());
            HdfsDataOutputStream fos = null;
            Nfs3FileAttributes latestAttr = null;
            try {
                int bufferSize = this.config.getInt("io.file.buffer.size", 4096);
                fos = dfsClient.append(fileIdPath, bufferSize, EnumSet.of(CreateFlag.APPEND), null, null);
                latestAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdMappingServiceProvider)this.iug);
            }
            catch (RemoteException e) {
                IOException io = e.unwrapRemoteException();
                if (io instanceof AlreadyBeingCreatedException) {
                    LOG.warn((Object)("Can't append file: " + fileIdPath + ". Possibly the file is being closed. Drop the request: " + request + ", wait for the client to retry..."));
                    return;
                }
                throw e;
            }
            catch (IOException e) {
                LOG.error((Object)("Can't append to file: " + fileIdPath), (Throwable)e);
                if (fos != null) {
                    fos.close();
                }
                WccData fileWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr), preOpAttr);
                WRITE3Response response = new WRITE3Response(5, fileWcc, count, request.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel((Channel)channel, (XDR)response.serialize(new XDR(), xid, (Verifier)new VerifierNone()), (int)xid);
                return;
            }
            String writeDumpDir = this.config.get("nfs.file.dump.dir", "/tmp/.hdfs-nfs");
            openFileCtx = new OpenFileCtx(fos, latestAttr, writeDumpDir + "/" + fileHandle.getFileId(), dfsClient, this.iug, this.aixCompatMode, this.config);
            if (!this.addOpenFileStream(fileHandle, openFileCtx)) {
                LOG.info((Object)"Can't add new stream. Close it. Tell client to retry.");
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't close stream for fileId: " + handle.getFileId()), (Throwable)e);
                }
                WccData fileWcc = new WccData(latestAttr.getWccAttr(), latestAttr);
                WRITE3Response response = new WRITE3Response(10008, fileWcc, 0, request.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel((Channel)channel, (XDR)response.serialize(new XDR(), xid, (Verifier)new VerifierNone()), (int)xid);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opened stream for appending file: " + fileHandle.getFileId()));
            }
        }
        openFileCtx.receivedNewWrite(dfsClient, request, channel, xid, this.asyncDataService, this.iug);
    }

    int commitBeforeRead(DFSClient dfsClient, FileHandle fileHandle, long commitOffset) {
        int status;
        OpenFileCtx openFileCtx = this.fileContextCache.get(fileHandle);
        if (openFileCtx == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No opened stream for fileId: " + fileHandle.getFileId() + " commitOffset=" + commitOffset + ". Return success in this case."));
            }
            status = 0;
        } else {
            OpenFileCtx.COMMIT_STATUS ret = openFileCtx.checkCommit(dfsClient, commitOffset, null, 0, null, true);
            switch (1.$SwitchMap$org$apache$hadoop$hdfs$nfs$nfs3$OpenFileCtx$COMMIT_STATUS[ret.ordinal()]) {
                case 1: 
                case 2: {
                    status = 0;
                    break;
                }
                case 3: 
                case 4: {
                    status = 5;
                    break;
                }
                case 5: 
                case 6: {
                    status = 10008;
                    break;
                }
                case 7: {
                    status = 0;
                    break;
                }
                default: {
                    LOG.error((Object)("Should not get commit return code: " + ret.name()));
                    throw new RuntimeException("Should not get commit return code: " + ret.name());
                }
            }
        }
        return status;
    }

    void handleCommit(DFSClient dfsClient, FileHandle fileHandle, long commitOffset, Channel channel, int xid, Nfs3FileAttributes preOpAttr) {
        int status;
        long startTime = System.nanoTime();
        OpenFileCtx openFileCtx = this.fileContextCache.get(fileHandle);
        if (openFileCtx == null) {
            LOG.info((Object)("No opened stream for fileId: " + fileHandle.getFileId() + " commitOffset=" + commitOffset + ". Return success in this case."));
            status = 0;
        } else {
            OpenFileCtx.COMMIT_STATUS ret = openFileCtx.checkCommit(dfsClient, commitOffset, channel, xid, preOpAttr, false);
            switch (1.$SwitchMap$org$apache$hadoop$hdfs$nfs$nfs3$OpenFileCtx$COMMIT_STATUS[ret.ordinal()]) {
                case 1: 
                case 2: {
                    status = 0;
                    break;
                }
                case 3: 
                case 4: {
                    status = 5;
                    break;
                }
                case 5: {
                    return;
                }
                case 6: {
                    status = 10008;
                    break;
                }
                case 7: {
                    status = 0;
                    break;
                }
                default: {
                    LOG.error((Object)("Should not get commit return code: " + ret.name()));
                    throw new RuntimeException("Should not get commit return code: " + ret.name());
                }
            }
        }
        Nfs3FileAttributes postOpAttr = null;
        try {
            postOpAttr = this.getFileAttr(dfsClient, new FileHandle(preOpAttr.getFileId()), this.iug);
        }
        catch (IOException e1) {
            LOG.info((Object)("Can't get postOpAttr for fileId: " + preOpAttr.getFileId()), (Throwable)e1);
        }
        WccData fileWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr), postOpAttr);
        COMMIT3Response response = new COMMIT3Response(status, fileWcc, Nfs3Constant.WRITE_COMMIT_VERF);
        RpcProgramNfs3.metrics.addCommit(Nfs3Utils.getElapsedTime((long)startTime));
        Nfs3Utils.writeChannelCommit((Channel)channel, (XDR)response.serialize(new XDR(), xid, (Verifier)new VerifierNone()), (int)xid);
    }

    Nfs3FileAttributes getFileAttr(DFSClient client, FileHandle fileHandle, IdMappingServiceProvider iug) throws IOException {
        OpenFileCtx openFileCtx;
        String fileIdPath = Nfs3Utils.getFileIdPath((FileHandle)fileHandle);
        Nfs3FileAttributes attr = Nfs3Utils.getFileAttr((DFSClient)client, (String)fileIdPath, (IdMappingServiceProvider)iug);
        if (attr != null && (openFileCtx = this.fileContextCache.get(fileHandle)) != null) {
            attr.setSize(openFileCtx.getNextOffset());
            attr.setUsed(openFileCtx.getNextOffset());
        }
        return attr;
    }

    Nfs3FileAttributes getFileAttr(DFSClient client, FileHandle dirHandle, String fileName) throws IOException {
        OpenFileCtx openFileCtx;
        String fileIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle) + "/" + fileName;
        Nfs3FileAttributes attr = Nfs3Utils.getFileAttr((DFSClient)client, (String)fileIdPath, (IdMappingServiceProvider)this.iug);
        if (attr != null && attr.getType() == NfsFileType.NFSREG.toValue() && (openFileCtx = this.fileContextCache.get(new FileHandle(attr.getFileId()))) != null) {
            attr.setSize(openFileCtx.getNextOffset());
            attr.setUsed(openFileCtx.getNextOffset());
        }
        return attr;
    }

    @VisibleForTesting
    OpenFileCtxCache getOpenFileCtxCache() {
        return this.fileContextCache;
    }
}

