/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.response.READDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIRPLUS3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.SecurityHandler;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestReaddir {
    static NfsConfiguration config = new NfsConfiguration();
    static MiniDFSCluster cluster = null;
    static DistributedFileSystem hdfs;
    static NameNode nn;
    static RpcProgramNfs3 nfsd;
    static String testdir;
    static SecurityHandler securityHandler;

    @BeforeClass
    public static void setup() throws Exception {
        String currentUser = System.getProperty("user.name");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(currentUser), "*");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(currentUser), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)config);
        cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
        nn = cluster.getNameNode();
        config.setInt("nfs3.mountd.port", 0);
        config.setInt("nfs3.server.port", 0);
        Nfs3 nfs3 = new Nfs3(config);
        nfs3.startServiceInternal(false);
        nfsd = (RpcProgramNfs3)nfs3.getRpcProgram();
        securityHandler = (SecurityHandler)Mockito.mock(SecurityHandler.class);
        Mockito.when((Object)securityHandler.getUser()).thenReturn((Object)System.getProperty("user.name"));
    }

    @AfterClass
    public static void shutdown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void createFiles() throws IllegalArgumentException, IOException {
        hdfs.delete(new Path(testdir), true);
        hdfs.mkdirs(new Path(testdir));
        DFSTestUtil.createFile((FileSystem)hdfs, (Path)new Path(testdir + "/f1"), (long)0L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)hdfs, (Path)new Path(testdir + "/f2"), (long)0L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)hdfs, (Path)new Path(testdir + "/f3"), (long)0L, (short)1, (long)0L);
    }

    @Test
    public void testReaddirBasic() throws IOException {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        handle.serialize(xdr_req);
        xdr_req.writeLongAsHyper(0L);
        xdr_req.writeLongAsHyper(0L);
        xdr_req.writeInt(100);
        READDIR3Response response = nfsd.readdir(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        List dirents = response.getDirList().getEntries();
        Assert.assertTrue((dirents.size() == 5 ? 1 : 0) != 0);
        status = nn.getRpcServer().getFileInfo(testdir + "/f2");
        long f2Id = status.getFileId();
        xdr_req = new XDR();
        handle = new FileHandle(dirId);
        handle.serialize(xdr_req);
        xdr_req.writeLongAsHyper(f2Id);
        xdr_req.writeLongAsHyper(0L);
        xdr_req.writeInt(100);
        response = nfsd.readdir(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        dirents = response.getDirList().getEntries();
        Assert.assertTrue((dirents.size() == 1 ? 1 : 0) != 0);
        READDIR3Response.Entry3 entry = (READDIR3Response.Entry3)dirents.get(0);
        Assert.assertTrue((boolean)entry.getName().equals("f3"));
        hdfs.delete(new Path(testdir + "/f2"), false);
        response = nfsd.readdir(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        dirents = response.getDirList().getEntries();
        Assert.assertTrue((dirents.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testReaddirPlus() throws IOException {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        handle.serialize(xdr_req);
        xdr_req.writeLongAsHyper(0L);
        xdr_req.writeLongAsHyper(0L);
        xdr_req.writeInt(100);
        xdr_req.writeInt(1000);
        READDIRPLUS3Response responsePlus = nfsd.readdirplus(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        List direntPlus = responsePlus.getDirListPlus().getEntries();
        Assert.assertTrue((direntPlus.size() == 5 ? 1 : 0) != 0);
        status = nn.getRpcServer().getFileInfo(testdir + "/f2");
        long f2Id = status.getFileId();
        xdr_req = new XDR();
        handle = new FileHandle(dirId);
        handle.serialize(xdr_req);
        xdr_req.writeLongAsHyper(f2Id);
        xdr_req.writeLongAsHyper(0L);
        xdr_req.writeInt(100);
        xdr_req.writeInt(1000);
        responsePlus = nfsd.readdirplus(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        direntPlus = responsePlus.getDirListPlus().getEntries();
        Assert.assertTrue((direntPlus.size() == 1 ? 1 : 0) != 0);
        READDIRPLUS3Response.EntryPlus3 entryPlus = (READDIRPLUS3Response.EntryPlus3)direntPlus.get(0);
        Assert.assertTrue((boolean)entryPlus.getName().equals("f3"));
        hdfs.delete(new Path(testdir + "/f2"), false);
        responsePlus = nfsd.readdirplus(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        direntPlus = responsePlus.getDirListPlus().getEntries();
        Assert.assertTrue((direntPlus.size() == 2 ? 1 : 0) != 0);
    }

    static {
        testdir = "/tmp";
    }
}

