/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.base.Preconditions;
import java.util.Comparator;

public class OffsetRange {
    public static final Comparator<OffsetRange> ReverseComparatorOnMin = new Comparator<OffsetRange>(){

        @Override
        public int compare(OffsetRange o1, OffsetRange o2) {
            if (o1.getMin() == o2.getMin()) {
                return o1.getMax() < o2.getMax() ? 1 : (o1.getMax() > o2.getMax() ? -1 : 0);
            }
            return o1.getMin() < o2.getMin() ? 1 : -1;
        }
    };
    private final long min;
    private final long max;

    OffsetRange(long min, long max) {
        Preconditions.checkArgument((min >= 0L && max >= 0L && min < max ? 1 : 0) != 0);
        this.min = min;
        this.max = max;
    }

    long getMin() {
        return this.min;
    }

    long getMax() {
        return this.max;
    }

    public int hashCode() {
        return (int)(this.min ^ this.max);
    }

    public boolean equals(Object o) {
        if (o instanceof OffsetRange) {
            OffsetRange range = (OffsetRange)o;
            return this.min == range.getMin() && this.max == range.getMax();
        }
        return false;
    }

    public String toString() {
        return "[" + this.getMin() + ", " + this.getMax() + ")";
    }
}

