/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouterResolver<K, V>
implements OrderedResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RouterResolver.class);
    public static final String MIN_UPDATE_PERIOD_KEY = "dfs.federation.router.router-resolver.update-period";
    private static final long MIN_UPDATE_PERIOD_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private final Router router;
    private final long minUpdateTime;
    private Map<K, V> subclusterMapping = null;
    private long lastUpdated;

    public RouterResolver(Configuration conf, Router routerService) {
        this.minUpdateTime = conf.getTimeDuration(MIN_UPDATE_PERIOD_KEY, MIN_UPDATE_PERIOD_DEFAULT, TimeUnit.MILLISECONDS);
        this.router = routerService;
    }

    @Override
    public String getFirstNamespace(String path, PathLocation loc) {
        this.updateSubclusterMapping();
        return this.chooseFirstNamespace(path, loc);
    }

    protected abstract Map<K, V> getSubclusterInfo(MembershipStore var1);

    protected abstract String chooseFirstNamespace(String var1, PathLocation var2);

    private synchronized void updateSubclusterMapping() {
        if (this.subclusterMapping == null || Time.monotonicNow() - this.lastUpdated > this.minUpdateTime) {
            Thread updater = new Thread(new Runnable(){

                @Override
                public void run() {
                    MembershipStore membershipStore = RouterResolver.this.getMembershipStore();
                    if (membershipStore == null) {
                        LOG.error("Cannot access the Membership store.");
                        return;
                    }
                    RouterResolver.this.subclusterMapping = RouterResolver.this.getSubclusterInfo(membershipStore);
                    RouterResolver.this.lastUpdated = Time.monotonicNow();
                }
            });
            updater.start();
            if (this.subclusterMapping == null) {
                try {
                    LOG.debug("Wait to get the mapping for the first time");
                    updater.join();
                }
                catch (InterruptedException e) {
                    LOG.error("Cannot wait for the updater to finish");
                }
            }
        }
    }

    protected RouterRpcServer getRpcServer() {
        if (this.router == null) {
            return null;
        }
        return this.router.getRpcServer();
    }

    protected MembershipStore getMembershipStore() {
        StateStoreService stateStore = this.router.getStateStore();
        if (stateStore == null) {
            return null;
        }
        return stateStore.getRegisteredRecordStore(MembershipStore.class);
    }

    protected Map<K, V> getSubclusterMapping() {
        return this.subclusterMapping;
    }
}

