/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.impl.pb.PBRecord;
import org.apache.hadoop.util.ReflectionUtils;

public final class StateStoreSerializerPBImpl
extends StateStoreSerializer {
    private static final String PB_IMPL_PACKAGE_SUFFIX = "impl.pb";
    private static final String PB_IMPL_CLASS_SUFFIX = "PBImpl";
    private Configuration localConf = new Configuration();

    private StateStoreSerializerPBImpl() {
    }

    @Override
    public <T> T newRecordInstance(Class<T> clazz) {
        try {
            String clazzPBImpl = this.getPBImplClassName(clazz);
            Class pbClazz = this.localConf.getClassByName(clazzPBImpl);
            Object retObject = ReflectionUtils.newInstance((Class)pbClazz, (Configuration)this.localConf);
            return (T)retObject;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPBImplClassName(Class<?> clazz) {
        String srcPackagePart = this.getPackageName(clazz);
        String srcClassName = this.getClassName(clazz);
        String destPackagePart = srcPackagePart + "." + PB_IMPL_PACKAGE_SUFFIX;
        String destClassPart = srcClassName + PB_IMPL_CLASS_SUFFIX;
        return destPackagePart + "." + destClassPart;
    }

    private String getClassName(Class<?> clazz) {
        String fqName = clazz.getName();
        return fqName.substring(fqName.lastIndexOf(".") + 1, fqName.length());
    }

    private String getPackageName(Class<?> clazz) {
        return clazz.getPackage().getName();
    }

    @Override
    public byte[] serialize(BaseRecord record) {
        byte[] byteArray64 = null;
        if (record instanceof PBRecord) {
            PBRecord recordPB = (PBRecord)((Object)record);
            Message msg = recordPB.getProto();
            byte[] byteArray = msg.toByteArray();
            byteArray64 = Base64.encodeBase64((byte[])byteArray, (boolean)false);
        }
        return byteArray64;
    }

    @Override
    public String serializeString(BaseRecord record) {
        byte[] byteArray64 = this.serialize(record);
        String base64Encoded = StringUtils.newStringUtf8((byte[])byteArray64);
        return base64Encoded;
    }

    @Override
    public <T extends BaseRecord> T deserialize(byte[] byteArray, Class<T> clazz) throws IOException {
        BaseRecord record = (BaseRecord)StateStoreSerializerPBImpl.newRecord(clazz);
        if (record instanceof PBRecord) {
            PBRecord pbRecord = (PBRecord)((Object)record);
            byte[] byteArray64 = Base64.encodeBase64((byte[])byteArray, (boolean)false);
            String base64Encoded = StringUtils.newStringUtf8((byte[])byteArray64);
            pbRecord.readInstance(base64Encoded);
        }
        return (T)record;
    }

    @Override
    public <T extends BaseRecord> T deserialize(String data, Class<T> clazz) throws IOException {
        byte[] byteArray64 = Base64.decodeBase64((String)data);
        return this.deserialize(byteArray64, clazz);
    }
}

