/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.hadoop.util.Time;

public abstract class BaseRecord
implements Comparable<BaseRecord> {
    public static final String ERROR_MSG_CREATION_TIME_NEGATIVE = "The creation time for the record cannot be negative.";
    public static final String ERROR_MSG_MODIFICATION_TIME_NEGATIVE = "The modification time for the record cannot be negative.";

    public abstract void setDateModified(long var1);

    public abstract long getDateModified();

    public abstract void setDateCreated(long var1);

    public abstract long getDateCreated();

    public abstract long getExpirationMs();

    public abstract Map<String, String> getPrimaryKeys();

    public void init() {
        this.initDefaultTimes();
    }

    private void initDefaultTimes() {
        long now = Time.now();
        this.setDateCreated(now);
        this.setDateModified(now);
    }

    public String getPrimaryKey() {
        return BaseRecord.generateMashupKey(this.getPrimaryKeys());
    }

    @VisibleForTesting
    public boolean hasOtherFields() {
        return true;
    }

    protected static String generateMashupKey(Map<String, String> keys) {
        StringBuilder builder = new StringBuilder();
        for (String value : keys.values()) {
            if (builder.length() > 0) {
                builder.append("-");
            }
            builder.append((Object)value);
        }
        return builder.toString();
    }

    public boolean like(BaseRecord other) {
        if (other == null) {
            return false;
        }
        Map<String, String> thisKeys = this.getPrimaryKeys();
        Map<String, String> otherKeys = other.getPrimaryKeys();
        if (thisKeys == null) {
            return otherKeys == null;
        }
        return thisKeys.equals(otherKeys);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseRecord)) {
            return false;
        }
        BaseRecord baseObject = (BaseRecord)obj;
        Map<String, String> keyset1 = this.getPrimaryKeys();
        Map<String, String> keyset2 = baseObject.getPrimaryKeys();
        return keyset1.equals(keyset2);
    }

    public int hashCode() {
        Map<String, String> keyset = this.getPrimaryKeys();
        return keyset.hashCode();
    }

    @Override
    public int compareTo(BaseRecord record) {
        if (record == null) {
            return -1;
        }
        return (int)(record.getDateModified() - this.getDateModified());
    }

    public boolean checkExpired(long currentTime) {
        long expiration = this.getExpirationMs();
        if (this.getDateModified() > 0L && expiration > 0L) {
            return this.getDateModified() + expiration < currentTime;
        }
        return false;
    }

    public void validate() {
        if (this.getDateCreated() <= 0L) {
            throw new IllegalArgumentException(ERROR_MSG_CREATION_TIME_NEGATIVE);
        }
        if (this.getDateModified() <= 0L) {
            throw new IllegalArgumentException(ERROR_MSG_MODIFICATION_TIME_NEGATIVE);
        }
    }

    public String toString() {
        return this.getPrimaryKey();
    }
}

