/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.fs.XAttrCodec;

public class XAttrEncodingParam extends EnumParam<XAttrCodec> {
  /** Parameter name. */
  public static final String NAME = "encoding";
  /** Default parameter value. */
  public static final String DEFAULT = "";
  
  private static final Domain<XAttrCodec> DOMAIN = 
      new Domain<XAttrCodec>(NAME, XAttrCodec.class);
  
  public XAttrEncodingParam(final XAttrCodec encoding) {
    super(DOMAIN, encoding);
  }
  
  /**
   * Constructor.
   * @param str a string representation of the parameter value.
   */
  public XAttrEncodingParam(final String str) {
    super(DOMAIN, str != null && !str.isEmpty() ? DOMAIN.parse(str) : null);
  }

  @Override
  public String getName() {
    return NAME;
  }
  
  @Override
  public String getValueString() {
    return value.toString();
  }
  
  public XAttrCodec getEncoding() {
    return getValue();
  }
}
