/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.NativeCodeLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestScrLazyPersistFiles
extends LazyPersistTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void init() {
        DomainSocket.disableBindPathValidation();
    }

    @Before
    public void before() {
        Assume.assumeThat((Object)(NativeCodeLoader.isNativeCodeLoaded() && !Path.WINDOWS ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRamDiskShortCircuitRead() throws IOException, InterruptedException {
        this.startUpCluster(1, new StorageType[]{StorageType.RAM_DISK, StorageType.DEFAULT}, 0x9FFFFFL, true);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        int SEED = 1027565;
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeRandomTestFile(path, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        Thread.sleep(3000L);
        FSDataInputStream fis = this.fs.open(path);
        try {
            fis = this.fs.open(path);
            byte[] buf = new byte[4096];
            fis.read(0L, buf, 0, 4096);
            HdfsDataInputStream dfsis = (HdfsDataInputStream)fis;
            Assert.assertEquals((long)4096L, (long)dfsis.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)4096L, (long)dfsis.getReadStatistics().getTotalShortCircuitBytesRead());
        }
        finally {
            fis.close();
            fis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRamDiskEvictionWithShortCircuitReadHandle() throws IOException, InterruptedException {
        this.startUpCluster(1, new StorageType[]{StorageType.RAM_DISK, StorageType.DEFAULT}, 0x1DFFFFFL, true);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        int SEED = 1027565;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        Thread.sleep(3000L);
        FSDataInputStream fis = this.fs.open(path1);
        try {
            byte[] buf = new byte[4096];
            fis.read(0L, buf, 0, 4096);
            this.makeTestFile(path2, 0xA00000L, true);
            this.ensureFileReplicasOnStorageType(path2, StorageType.RAM_DISK);
            fis.read(fis.getPos(), buf, 0, 4096);
            HdfsDataInputStream dfsis = (HdfsDataInputStream)fis;
            Assert.assertEquals((long)8192L, (long)dfsis.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)8192L, (long)dfsis.getReadStatistics().getTotalShortCircuitBytesRead());
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        this.triggerBlockReport();
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
    }

    @Test
    public void testShortCircuitReadAfterEviction() throws IOException, InterruptedException {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        this.startUpCluster(true, 2, true, false);
        this.doShortCircuitReadAfterEvictionTest();
    }

    @Test
    public void testLegacyShortCircuitReadAfterEviction() throws IOException, InterruptedException {
        this.startUpCluster(true, 2, true, true);
        this.doShortCircuitReadAfterEvictionTest();
    }

    private void doShortCircuitReadAfterEvictionTest() throws IOException, InterruptedException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        int SEED = 1027565;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        File metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        Assert.assertTrue((metaFile.length() <= (long)BlockMetadataHeader.getHeaderSize() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
        Thread.sleep(3000L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        Assert.assertTrue((metaFile.length() <= (long)BlockMetadataHeader.getHeaderSize() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
        this.makeRandomTestFile(path2, 0x500000L, true, 1027565L);
        Thread.sleep(3000L);
        this.triggerBlockReport();
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        Assert.assertTrue((metaFile.length() > (long)BlockMetadataHeader.getHeaderSize() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
        ClientContext clientContext = this.client.getClientContext();
        if (clientContext.getUseLegacyBlockReaderLocal()) {
            Assert.assertFalse((boolean)clientContext.getDisableLegacyBlockReaderLocal());
        }
    }

    @Test
    public void testShortCircuitReadBlockFileCorruption() throws IOException, InterruptedException {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        this.startUpCluster(true, 2, true, false);
        this.doShortCircuitReadBlockFileCorruptionTest();
    }

    @Test
    public void testLegacyShortCircuitReadBlockFileCorruption() throws IOException, InterruptedException {
        this.startUpCluster(true, 2, true, true);
        this.doShortCircuitReadBlockFileCorruptionTest();
    }

    public void doShortCircuitReadBlockFileCorruptionTest() throws IOException, InterruptedException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        int SEED = 1027565;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.makeRandomTestFile(path2, 0x500000L, true, 1027565L);
        Thread.sleep(3000L);
        this.triggerBlockReport();
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        this.cluster.corruptReplica(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        this.exception.expect(ChecksumException.class);
        DFSTestUtil.readFileBuffer((FileSystem)this.fs, path1);
    }

    @Test
    public void testShortCircuitReadMetaFileCorruption() throws IOException, InterruptedException {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        this.startUpCluster(true, 2, true, false);
        this.doShortCircuitReadMetaFileCorruptionTest();
    }

    @Test
    public void testLegacyShortCircuitReadMetaFileCorruption() throws IOException, InterruptedException {
        this.startUpCluster(true, 2, true, true);
        this.doShortCircuitReadMetaFileCorruptionTest();
    }

    public void doShortCircuitReadMetaFileCorruptionTest() throws IOException, InterruptedException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        int SEED = 1027565;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.makeRandomTestFile(path2, 0x500000L, true, 1027565L);
        Thread.sleep(3000L);
        this.triggerBlockReport();
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        File metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        MiniDFSCluster.corruptBlock(metaFile);
        this.exception.expect(ChecksumException.class);
        DFSTestUtil.readFileBuffer((FileSystem)this.fs, path1);
    }
}

