/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;

public class TestDiskspaceQuotaUpdate {
    private static final int BLOCKSIZE = 1024;
    private static final short REPLICATION = 4;
    static final long seed = 0L;
    private static final Path BASE_DIR = new Path("/TestQuotaUpdate");
    private static Configuration conf;
    private static MiniDFSCluster cluster;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        conf.setLong("dfs.blocksize", 1024L);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        cluster.waitActive();
    }

    @Before
    public void resetCluster() throws Exception {
        if (!cluster.isClusterUp()) {
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
            cluster.waitActive();
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private Path getParent(String testName) {
        return new Path(BASE_DIR, testName);
    }

    private FSDirectory getFSDirectory() {
        return cluster.getNamesystem().getFSDirectory();
    }

    private DistributedFileSystem getDFS() throws IOException {
        return cluster.getFileSystem();
    }

    @Test(timeout=60000L)
    public void testQuotaUpdateWithFileCreate() throws Exception {
        Path foo = new Path(this.getParent(GenericTestUtils.getMethodName()), "foo");
        Path createdFile = new Path(foo, "created_file.data");
        this.getDFS().mkdirs(foo);
        this.getDFS().setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        long fileLen = 2560L;
        DFSTestUtil.createFile((FileSystem)this.getDFS(), createdFile, 64, fileLen, 1024L, (short)4, 0L);
        INode fnode = this.getFSDirectory().getINode4Write(foo.toString());
        Assert.assertTrue((boolean)fnode.isDirectory());
        Assert.assertTrue((boolean)fnode.isQuotaSet());
        QuotaCounts cnt = fnode.asDirectory().getDirectoryWithQuotaFeature().getSpaceConsumed();
        Assert.assertEquals((long)2L, (long)cnt.getNameSpace());
        Assert.assertEquals((long)(fileLen * 4L), (long)cnt.getStorageSpace());
    }

    @Test(timeout=60000L)
    public void testUpdateQuotaForAppend() throws Exception {
        Path foo = new Path(this.getParent(GenericTestUtils.getMethodName()), "foo");
        Path bar = new Path(foo, "bar");
        long currentFileLen = 1024L;
        DFSTestUtil.createFile((FileSystem)this.getDFS(), bar, currentFileLen, (short)4, 0L);
        this.getDFS().setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        DFSTestUtil.appendFile((FileSystem)this.getDFS(), bar, 512);
        currentFileLen += 512L;
        INodeDirectory fooNode = this.getFSDirectory().getINode4Write(foo.toString()).asDirectory();
        Assert.assertTrue((boolean)fooNode.isQuotaSet());
        QuotaCounts quota = fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed();
        long ns = quota.getNameSpace();
        long ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(currentFileLen * 4L), (long)ds);
        ContentSummary c = this.getDFS().getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.getDFS(), bar, 1024);
        quota = fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed();
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)((currentFileLen += 1024L) * 4L), (long)ds);
        c = this.getDFS().getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.getDFS(), bar, 3200);
        quota = fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed();
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)((currentFileLen += 3200L) * 4L), (long)ds);
        c = this.getDFS().getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
    }

    @Test(timeout=60000L)
    public void testUpdateQuotaForFSync() throws Exception {
        Path foo = new Path(this.getParent(GenericTestUtils.getMethodName()), "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)this.getDFS(), bar, 1024L, (short)4, 0L);
        this.getDFS().setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        FSDataOutputStream out = this.getDFS().append(bar);
        out.write(new byte[256]);
        ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        INodeDirectory fooNode = this.getFSDirectory().getINode4Write(foo.toString()).asDirectory();
        QuotaCounts quota = fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed();
        long ns = quota.getNameSpace();
        long ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)8192L, (long)ds);
        out.write(new byte[256]);
        out.close();
        fooNode = this.getFSDirectory().getINode4Write(foo.toString()).asDirectory();
        quota = fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed();
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)6144L, (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.getDFS(), bar, 1024);
        quota = fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed();
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)10240L, (long)ds);
    }

    @Test(timeout=60000L)
    public void testAppendOverStorageQuota() throws Exception {
        Path dir = this.getParent(GenericTestUtils.getMethodName());
        Path file = new Path(dir, "file");
        this.getDFS().mkdirs(dir);
        DFSTestUtil.createFile((FileSystem)this.getDFS(), file, 512L, (short)4, 0L);
        this.getDFS().setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 1L);
        INodeDirectory dirNode = this.getFSDirectory().getINode4Write(dir.toString()).asDirectory();
        long spaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
        try {
            DFSTestUtil.appendFile((FileSystem)this.getDFS(), file, 1024);
            Assert.fail((String)"append didn't fail");
        }
        catch (DSQuotaExceededException dSQuotaExceededException) {
            // empty catch block
        }
        INodeFile inode = this.getFSDirectory().getINode(file.toString()).asFile();
        Assert.assertNotNull((Object)inode);
        Assert.assertFalse((String)"should not be UC", (boolean)inode.isUnderConstruction());
        Assert.assertNull((String)"should not have a lease", (Object)cluster.getNamesystem().getLeaseManager().getLeaseByPath(file.toString()));
        long newSpaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)newSpaceUsed);
        this.getDFS().recoverLease(file);
        cluster.restartNameNode(true);
    }

    @Test(timeout=60000L)
    public void testAppendOverTypeQuota() throws Exception {
        Path dir = this.getParent(GenericTestUtils.getMethodName());
        Path file = new Path(dir, "file");
        this.getDFS().mkdirs(dir);
        this.getDFS().setStoragePolicy(dir, "ONE_SSD");
        DFSTestUtil.createFile((FileSystem)this.getDFS(), file, 512L, (short)4, 0L);
        this.getDFS().setQuotaByStorageType(dir, StorageType.SSD, 1L);
        INodeDirectory dirNode = this.getFSDirectory().getINode4Write(dir.toString()).asDirectory();
        long spaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
        try {
            DFSTestUtil.appendFile((FileSystem)this.getDFS(), file, 1024);
            Assert.fail((String)"append didn't fail");
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)e.getClassName().contains("QuotaByStorageTypeExceededException"));
        }
        INodeFile inode = this.getFSDirectory().getINode(file.toString()).asFile();
        Assert.assertNotNull((Object)inode);
        Assert.assertFalse((String)"should not be UC", (boolean)inode.isUnderConstruction());
        Assert.assertNull((String)"should not have a lease", (Object)cluster.getNamesystem().getLeaseManager().getLeaseByPath(file.toString()));
        long newSpaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)newSpaceUsed);
        this.getDFS().recoverLease(file);
        cluster.restartNameNode(true);
    }

    @Test(timeout=60000L)
    public void testTruncateOverQuota() throws Exception {
        Path dir = this.getParent(GenericTestUtils.getMethodName());
        Path file = new Path(dir, "file");
        this.getDFS().mkdirs(dir);
        DFSTestUtil.createFile((FileSystem)this.getDFS(), file, 512L, (short)4, 0L);
        this.getDFS().setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 1L);
        INodeDirectory dirNode = this.getFSDirectory().getINode4Write(dir.toString()).asDirectory();
        long spaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
        try {
            this.getDFS().truncate(file, 511L);
            Assert.fail((String)"truncate didn't fail");
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)e.getClassName().contains("DSQuotaExceededException"));
        }
        INodeFile inode = this.getFSDirectory().getINode(file.toString()).asFile();
        Assert.assertNotNull((Object)inode);
        Assert.assertFalse((String)"should not be UC", (boolean)inode.isUnderConstruction());
        Assert.assertNull((String)"should not have a lease", (Object)cluster.getNamesystem().getLeaseManager().getLeaseByPath(file.toString()));
        long newSpaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)newSpaceUsed);
        this.getDFS().recoverLease(file);
        cluster.restartNameNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testQuotaIssuesWhileCommitting() throws Exception {
        ArrayList<MiniDFSCluster.DataNodeProperties> dnprops = new ArrayList<MiniDFSCluster.DataNodeProperties>();
        try {
            for (int i = 3; i > 0; --i) {
                dnprops.add(cluster.stopDataNode(i));
            }
            DatanodeProtocolClientSideTranslatorPB nnSpy = DataNodeTestUtils.spyOnBposToNN(cluster.getDataNodes().get(0), cluster.getNameNode());
            this.testQuotaIssuesWhileCommittingHelper(nnSpy, (short)1, (short)4);
            this.testQuotaIssuesWhileCommittingHelper(nnSpy, (short)4, (short)1);
            this.testQuotaIssuesWhileCommittingHelper(nnSpy, (short)1, (short)1);
        }
        finally {
            for (MiniDFSCluster.DataNodeProperties dnprop : dnprops) {
                cluster.restartDataNode(dnprop, true);
            }
            cluster.waitActive();
        }
    }

    private void testQuotaIssuesWhileCommittingHelper(DatanodeProtocolClientSideTranslatorPB nnSpy, final short initialReplication, final short finalReplication) throws Exception {
        String logStmt = "BUG: Inconsistent storagespace for directory";
        final Path dir = new Path(this.getParent(GenericTestUtils.getMethodName()), String.format("%d-%d", initialReplication, finalReplication));
        final Path file = new Path(dir, "testfile");
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((org.apache.log4j.Logger)GenericTestUtils.toLog4j((Logger)NameNode.LOG));
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                if (finalReplication != initialReplication) {
                    TestDiskspaceQuotaUpdate.this.getDFS().setReplication(file, finalReplication);
                }
                TestDiskspaceQuotaUpdate.this.getDFS().getContentSummary(dir);
                invocation.callRealMethod();
                return null;
            }
        }).when((Object)nnSpy)).blockReceivedAndDeleted((DatanodeRegistration)Mockito.anyObject(), Mockito.anyString(), (StorageReceivedDeletedBlocks[])Mockito.anyObject());
        this.getDFS().mkdirs(dir);
        this.getDFS().setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        DFSTestUtil.createFile((FileSystem)this.getDFS(), file, 512L, initialReplication, 1L);
        this.getDFS().getContentSummary(dir);
        Assert.assertFalse((boolean)logs.getOutput().contains("BUG: Inconsistent storagespace for directory"));
    }

    private void testQuotaIssuesBeforeCommitting(short initialReplication, short finalReplication) throws Exception {
        String logStmt = "BUG: Inconsistent storagespace for directory";
        Path dir = new Path(this.getParent(GenericTestUtils.getMethodName()), String.format("%d-%d", initialReplication, finalReplication));
        Path file = new Path(dir, "testfile");
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((org.apache.log4j.Logger)GenericTestUtils.toLog4j((Logger)NameNode.LOG));
        this.getDFS().mkdirs(dir);
        this.getDFS().setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        FSDataOutputStream out = TestFileCreation.createFile((FileSystem)this.getDFS(), file, initialReplication);
        TestFileCreation.writeFile(out, 512);
        out.hflush();
        this.getDFS().getContentSummary(dir);
        if (finalReplication != initialReplication) {
            this.getDFS().setReplication(file, finalReplication);
        }
        out.close();
        this.getDFS().getContentSummary(dir);
        Assert.assertFalse((boolean)logs.getOutput().contains("BUG: Inconsistent storagespace for directory"));
    }

    @Test(timeout=60000L)
    public void testCachedComputedSizesAgreeBeforeCommitting() throws Exception {
        this.testQuotaIssuesBeforeCommitting((short)1, (short)1);
    }

    @Test(timeout=60000L)
    public void testDecreaseReplicationBeforeCommitting() throws Exception {
        this.testQuotaIssuesBeforeCommitting((short)4, (short)1);
    }

    @Test(timeout=60000L)
    public void testIncreaseReplicationBeforeCommitting() throws Exception {
        this.testQuotaIssuesBeforeCommitting((short)1, (short)4);
    }
}

