/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDFSOutputStream {
    static MiniDFSCluster cluster;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).build();
    }

    @Test
    public void testCloseTwice() throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        AtomicReference ex = (AtomicReference)Whitebox.getInternalState((Object)dos, (String)"lastException");
        Assert.assertEquals(null, ex.get());
        dos.close();
        IOException dummy = new IOException("dummy");
        ex.set(dummy);
        try {
            dos.close();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)e, (Object)dummy);
        }
        Assert.assertEquals(null, ex.get());
        dos.close();
    }

    @Test
    public void testComputePacketChunkSize() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        int packetSize = 65536;
        int bytesPerChecksum = 512;
        Method method = dos.getClass().getDeclaredMethod("computePacketChunkSize", Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        method.invoke((Object)dos, 65536, 512);
        Field field = dos.getClass().getDeclaredField("packetSize");
        field.setAccessible(true);
        Assert.assertTrue(((Integer)field.get(dos) + 33 < 65536 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)field.get(dos) + 257 < 65536 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testPreventOverflow() throws IOException, NoSuchFieldException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        int defaultWritePacketSize = 65536;
        int configuredWritePacketSize = 65536;
        int finalWritePacketSize = 65536;
        this.runAdjustChunkBoundary(configuredWritePacketSize, finalWritePacketSize);
        configuredWritePacketSize = 1048576000;
        finalWritePacketSize = 0x1000000;
        this.runAdjustChunkBoundary(configuredWritePacketSize, finalWritePacketSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAdjustChunkBoundary(int configuredWritePacketSize, int finalWritePacketSize) throws IOException, NoSuchFieldException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        boolean appendChunk = false;
        long blockSize = 0xC000001CL;
        long bytesCurBlock = 0x40000000L;
        int bytesPerChecksum = 512;
        int checksumSize = 4;
        int chunkSize = 516;
        int packateMaxHeaderLength = 33;
        MiniDFSCluster dfsCluster = null;
        File baseDir = new File(PathUtils.getTestDir(this.getClass()), GenericTestUtils.getMethodName());
        try {
            Configuration dfsConf = new Configuration();
            dfsConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
            dfsConf.setInt("dfs.client-write-packet-size", configuredWritePacketSize);
            dfsCluster = new MiniDFSCluster.Builder(dfsConf).numDataNodes(1).build();
            dfsCluster.waitActive();
            FSDataOutputStream os = dfsCluster.getFileSystem().create(new Path(baseDir.getAbsolutePath(), "testPreventOverflow"));
            DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
            Method setAppendChunkMethod = dos.getClass().getDeclaredMethod("setAppendChunk", Boolean.TYPE);
            setAppendChunkMethod.setAccessible(true);
            setAppendChunkMethod.invoke((Object)dos, false);
            Method setBytesCurBlockMethod = dos.getClass().getDeclaredMethod("setBytesCurBlock", Long.TYPE);
            setBytesCurBlockMethod.setAccessible(true);
            setBytesCurBlockMethod.invoke((Object)dos, 0x40000000L);
            Field blockSizeField = dos.getClass().getDeclaredField("blockSize");
            blockSizeField.setAccessible(true);
            blockSizeField.setLong(dos, 0xC000001CL);
            Method method = dos.getClass().getDeclaredMethod("adjustChunkBoundary", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)dos, new Object[0]);
            Field writePacketSizeField = dos.getClass().getDeclaredField("writePacketSize");
            writePacketSizeField.setAccessible(true);
            Assert.assertEquals((long)writePacketSizeField.getInt(dos), (long)finalWritePacketSize);
            Field chunksPerPacketField = dos.getClass().getDeclaredField("chunksPerPacket");
            chunksPerPacketField.setAccessible(true);
            Assert.assertEquals((long)chunksPerPacketField.getInt(dos), (long)((finalWritePacketSize - 33) / 516));
            Field packetSizeField = dos.getClass().getDeclaredField("packetSize");
            packetSizeField.setAccessible(true);
            Assert.assertEquals((long)packetSizeField.getInt(dos), (long)(chunksPerPacketField.getInt(dos) * 516));
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }
}

