/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.hdfs.KeyProviderCache;
import org.junit.Assert;
import org.junit.Test;

public class TestKeyProviderCache {
    @Test
    public void testCache() throws Exception {
        KeyProviderCache kpCache = new KeyProviderCache(10000L);
        Configuration conf = new Configuration();
        conf.set("dfs.encryption.key.provider.uri", "dummy://foo:bar@test_provider1");
        KeyProvider keyProvider1 = kpCache.get(conf);
        Assert.assertNotNull((String)"Returned Key Provider is null !!", (Object)keyProvider1);
        conf.set("dfs.encryption.key.provider.uri", "dummy://foo:bar@test_provider1");
        KeyProvider keyProvider2 = kpCache.get(conf);
        Assert.assertTrue((String)"Different KeyProviders returned !!", (keyProvider1 == keyProvider2 ? 1 : 0) != 0);
        conf.set("dfs.encryption.key.provider.uri", "dummy://test_provider3");
        KeyProvider keyProvider3 = kpCache.get(conf);
        Assert.assertFalse((String)"Same KeyProviders returned !!", (keyProvider1 == keyProvider3 ? 1 : 0) != 0);
        conf.set("dfs.encryption.key.provider.uri", "dummy://hello:there@test_provider1");
        KeyProvider keyProvider4 = kpCache.get(conf);
        Assert.assertFalse((String)"Same KeyProviders returned !!", (keyProvider1 == keyProvider4 ? 1 : 0) != 0);
    }

    public static class Factory
    extends KeyProviderFactory {
        public KeyProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if ("dummy".equals(providerName.getScheme())) {
                return new DummyKeyProvider(conf);
            }
            return null;
        }
    }

    public static class DummyKeyProvider
    extends KeyProvider {
        public DummyKeyProvider(Configuration conf) {
            super(conf);
        }

        public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
            return null;
        }

        public List<String> getKeys() throws IOException {
            return null;
        }

        public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
            return null;
        }

        public KeyProvider.Metadata getMetadata(String name) throws IOException {
            return null;
        }

        public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
            return null;
        }

        public void deleteKey(String name) throws IOException {
        }

        public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
            return null;
        }

        public void flush() throws IOException {
        }
    }
}

