/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.resources.ExceptionHandler;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mortbay.util.ajax.JSON;

public class TestDelegationTokensWithHA {
    private static final Configuration conf = new Configuration();
    private static final Log LOG = LogFactory.getLog(TestDelegationTokensWithHA.class);
    private static MiniDFSCluster cluster;
    private static NameNode nn0;
    private static NameNode nn1;
    private static FileSystem fs;
    private static DelegationTokenSecretManager dtSecretManager;
    private static DistributedFileSystem dfs;
    private volatile boolean catchup = false;

    @Before
    public void setupCluster() throws Exception {
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        cluster.waitActive();
        String logicalName = HATestUtil.getLogicalHostname(cluster);
        HATestUtil.setFailoverConfigurations(cluster, conf, logicalName, 0);
        nn0 = cluster.getNameNode(0);
        nn1 = cluster.getNameNode(1);
        fs = HATestUtil.configureFailoverFs(cluster, conf);
        dfs = (DistributedFileSystem)fs;
        cluster.transitionToActive(0);
        dtSecretManager = NameNodeAdapter.getDtSecretManager(nn0.getNamesystem());
    }

    @After
    public void shutdownCluster() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=300000L)
    public void testDelegationTokenDFSApi() throws Exception {
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(fs, "JobTracker");
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        LOG.info((Object)"A valid token should have non-null password, and should be renewed successfully");
        Assert.assertTrue((null != dtSecretManager.retrievePassword(identifier) ? 1 : 0) != 0);
        dtSecretManager.renewToken(token, "JobTracker");
        Configuration clientConf = dfs.getConf();
        TestDelegationTokensWithHA.doRenewOrCancel(token, clientConf, TokenTestAction.RENEW);
        Configuration emptyConf = new Configuration();
        try {
            TestDelegationTokensWithHA.doRenewOrCancel(token, emptyConf, TokenTestAction.RENEW);
            Assert.fail((String)"Did not throw trying to renew with an empty conf!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Unable to map logical nameservice URI", (Throwable)ioe);
        }
        cluster.transitionToStandby(0);
        cluster.transitionToActive(1);
        TestDelegationTokensWithHA.doRenewOrCancel(token, clientConf, TokenTestAction.RENEW);
        TestDelegationTokensWithHA.doRenewOrCancel(token, clientConf, TokenTestAction.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDelegationTokenDuringNNFailover() throws Exception {
        EditLogTailer editLogTailer = nn1.getNamesystem().getEditLogTailer();
        editLogTailer.stop();
        Configuration conf = (Configuration)Whitebox.getInternalState((Object)editLogTailer, (String)"conf");
        nn1.getNamesystem().setEditLogTailerForTests((EditLogTailer)new EditLogTailerForTest(nn1.getNamesystem(), conf));
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(fs, "JobTracker");
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        LOG.info((Object)"A valid token should have non-null password, and should be renewed successfully");
        Assert.assertTrue((null != dtSecretManager.retrievePassword(identifier) ? 1 : 0) != 0);
        dtSecretManager.renewToken(token, "JobTracker");
        cluster.transitionToStandby(0);
        try {
            cluster.getNameNodeRpc(0).renewDelegationToken(token);
            Assert.fail((String)"StandbyException is expected since nn0 is in standby state");
        }
        catch (StandbyException e) {
            GenericTestUtils.assertExceptionContains((String)HAServiceProtocol.HAServiceState.STANDBY.toString(), (Throwable)e);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    cluster.transitionToActive(1);
                }
                catch (Exception e) {
                    LOG.error((Object)"Transition nn1 to active failed", (Throwable)e);
                }
            }
        }.start();
        Thread.sleep(1000L);
        try {
            nn1.getNamesystem().verifyToken((DelegationTokenIdentifier)token.decodeIdentifier(), token.getPassword());
            Assert.fail((String)"RetriableException/StandbyException is expected since nn1 is in transition");
        }
        catch (IOException e) {
            Assert.assertTrue((e instanceof StandbyException || e instanceof RetriableException ? 1 : 0) != 0);
            LOG.info((Object)"Got expected exception", (Throwable)e);
        }
        this.catchup = true;
        TestDelegationTokensWithHA e = this;
        synchronized (e) {
            this.notifyAll();
        }
        Configuration clientConf = dfs.getConf();
        TestDelegationTokensWithHA.doRenewOrCancel(token, clientConf, TokenTestAction.RENEW);
        TestDelegationTokensWithHA.doRenewOrCancel(token, clientConf, TokenTestAction.CANCEL);
    }

    @Test(timeout=300000L)
    public void testDelegationTokenWithDoAs() throws Exception {
        final Token<DelegationTokenIdentifier> token = this.getDelegationToken(fs, "JobTracker");
        UserGroupInformation longUgi = UserGroupInformation.createRemoteUser((String)"JobTracker/foo.com@FOO.COM");
        UserGroupInformation shortUgi = UserGroupInformation.createRemoteUser((String)"JobTracker");
        longUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                token.renew(conf);
                return null;
            }
        });
        shortUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                token.renew(conf);
                return null;
            }
        });
        longUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                token.cancel(conf);
                return null;
            }
        });
    }

    @Test(timeout=300000L)
    public void testHAUtilClonesDelegationTokens() throws Exception {
        Token token2;
        Text ipcDtService;
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(fs, "JobTracker");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test");
        URI haUri = new URI("hdfs://my-ha-uri/");
        token.setService(HAUtil.buildTokenServiceForLogicalUri((URI)haUri, (String)"hdfs"));
        ugi.addToken(token);
        HashSet<InetSocketAddress> nnAddrs = new HashSet<InetSocketAddress>();
        nnAddrs.add(new InetSocketAddress("localhost", nn0.getNameNodeAddress().getPort()));
        nnAddrs.add(new InetSocketAddress("localhost", nn1.getNameNodeAddress().getPort()));
        HAUtil.cloneDelegationTokenForLogicalUri((UserGroupInformation)ugi, (URI)haUri, nnAddrs);
        Collection tokens = ugi.getTokens();
        Assert.assertEquals((long)3L, (long)tokens.size());
        LOG.info((Object)("Tokens:\n" + Joiner.on((String)"\n").join((Iterable)tokens)));
        DelegationTokenSelector dts = new DelegationTokenSelector();
        for (InetSocketAddress addr : nnAddrs) {
            ipcDtService = SecurityUtil.buildTokenService((InetSocketAddress)addr);
            token2 = dts.selectToken(ipcDtService, ugi.getTokens());
            Assert.assertNotNull((Object)token2);
            Assert.assertArrayEquals((byte[])token.getIdentifier(), (byte[])token2.getIdentifier());
            Assert.assertArrayEquals((byte[])token.getPassword(), (byte[])token2.getPassword());
        }
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        for (InetSocketAddress addr : nnAddrs) {
            ipcDtService = SecurityUtil.buildTokenService((InetSocketAddress)addr);
            token2 = dts.selectToken(ipcDtService, ugi.getTokens());
            Assert.assertNull((Object)token2);
        }
        HAUtil.cloneDelegationTokenForLogicalUri((UserGroupInformation)ugi, (URI)haUri, nnAddrs);
        for (InetSocketAddress addr : nnAddrs) {
            ipcDtService = SecurityUtil.buildTokenService((InetSocketAddress)addr);
            token2 = dts.selectToken(ipcDtService, ugi.getTokens());
            Assert.assertNotNull((Object)token2);
            Assert.assertArrayEquals((byte[])token.getIdentifier(), (byte[])token2.getIdentifier());
            Assert.assertArrayEquals((byte[])token.getPassword(), (byte[])token2.getPassword());
        }
    }

    @Test(timeout=300000L)
    public void testDFSGetCanonicalServiceName() throws Exception {
        URI hAUri = HATestUtil.getLogicalUri(cluster);
        String haService = HAUtil.buildTokenServiceForLogicalUri((URI)hAUri, (String)"hdfs").toString();
        Assert.assertEquals((Object)haService, (Object)dfs.getCanonicalServiceName());
        String renewer = UserGroupInformation.getCurrentUser().getShortUserName();
        Token<DelegationTokenIdentifier> token = this.getDelegationToken((FileSystem)dfs, renewer);
        Assert.assertEquals((Object)haService, (Object)token.getService().toString());
        token.renew(dfs.getConf());
        token.cancel(dfs.getConf());
    }

    @Test(timeout=300000L)
    public void testHdfsGetCanonicalServiceName() throws Exception {
        Configuration conf = dfs.getConf();
        URI haUri = HATestUtil.getLogicalUri(cluster);
        AbstractFileSystem afs = AbstractFileSystem.createFileSystem((URI)haUri, (Configuration)conf);
        String haService = HAUtil.buildTokenServiceForLogicalUri((URI)haUri, (String)"hdfs").toString();
        Assert.assertEquals((Object)haService, (Object)afs.getCanonicalServiceName());
        Token token = (Token)afs.getDelegationTokens(UserGroupInformation.getCurrentUser().getShortUserName()).get(0);
        Assert.assertEquals((Object)haService, (Object)token.getService().toString());
        token.renew(conf);
        token.cancel(conf);
    }

    @Test(timeout=300000L)
    public void testDelegationTokenStandbyNNAppearFirst() throws Exception {
        cluster.transitionToStandby(0);
        cluster.transitionToActive(1);
        DelegationTokenSecretManager stSecretManager = NameNodeAdapter.getDtSecretManager(nn1.getNamesystem());
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(fs, "JobTracker");
        final DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        Assert.assertTrue((null != stSecretManager.retrievePassword(identifier) ? 1 : 0) != 0);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"JobTracker");
        ugi.addToken(token);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() {
                try {
                    try {
                        byte[] tmppw = dtSecretManager.retrievePassword(identifier);
                        Assert.fail((String)"InvalidToken with cause StandbyException is expected since nn0 is standby");
                        return tmppw;
                    }
                    catch (IOException e) {
                        throw new SecurityException("Failed to obtain user group information: " + e, e);
                    }
                }
                catch (Exception oe) {
                    HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
                    ExceptionHandler eh = new ExceptionHandler();
                    eh.initResponse(response);
                    Response resp = eh.toResponse(oe);
                    Map m = (Map)JSON.parse((String)resp.getEntity().toString());
                    RemoteException re = JsonUtil.toRemoteException((Map)m);
                    IOException unwrapped = re.unwrapRemoteException(new Class[]{StandbyException.class});
                    Assert.assertTrue((boolean)(unwrapped instanceof StandbyException));
                    return null;
                }
            }
        });
    }

    private Token<DelegationTokenIdentifier> getDelegationToken(FileSystem fs, String renewer) throws IOException {
        Token[] tokens = fs.addDelegationTokens(renewer, null);
        Assert.assertEquals((long)1L, (long)tokens.length);
        return tokens[0];
    }

    private static void doRenewOrCancel(final Token<DelegationTokenIdentifier> token, final Configuration conf, final TokenTestAction action) throws IOException, InterruptedException {
        UserGroupInformation.createRemoteUser((String)"JobTracker").doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                switch (action) {
                    case RENEW: {
                        token.renew(conf);
                        break;
                    }
                    case CANCEL: {
                        token.cancel(conf);
                        break;
                    }
                    default: {
                        Assert.fail((String)("bad action:" + (Object)((Object)action)));
                    }
                }
                return null;
            }
        });
    }

    static enum TokenTestAction {
        RENEW,
        CANCEL;

    }

    private class EditLogTailerForTest
    extends EditLogTailer {
        public EditLogTailerForTest(FSNamesystem namesystem, Configuration conf) {
            super(namesystem, conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void catchupDuringFailover() throws IOException {
            TestDelegationTokensWithHA testDelegationTokensWithHA = TestDelegationTokensWithHA.this;
            synchronized (testDelegationTokensWithHA) {
                while (!TestDelegationTokensWithHA.this.catchup) {
                    try {
                        LOG.info((Object)"The editlog tailer is waiting to catchup...");
                        TestDelegationTokensWithHA.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            super.catchupDuringFailover();
        }
    }
}

