/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSUpgradeFromImage;
import org.junit.Test;

public class TestDatanodeLayoutUpgrade {
    private static final String HADOOP_DATANODE_DIR_TXT = "hadoop-datanode-dir.txt";
    private static final String HADOOP24_DATANODE = "hadoop-24-datanode-dir.tgz";

    @Test
    public void testUpgradeToIdBasedLayout() throws IOException {
        TestDFSUpgradeFromImage upgrade = new TestDFSUpgradeFromImage();
        upgrade.unpackStorage(HADOOP24_DATANODE, HADOOP_DATANODE_DIR_TXT);
        Configuration conf = new Configuration(TestDFSUpgradeFromImage.upgradeConf);
        conf.set("dfs.datanode.data.dir", System.getProperty("test.build.data") + File.separator + "dfs" + File.separator + "data");
        conf.set("dfs.namenode.name.dir", System.getProperty("test.build.data") + File.separator + "dfs" + File.separator + "name");
        upgrade.upgradeAndVerify(new MiniDFSCluster.Builder(conf).numDataNodes(1).manageDataDfsDirs(false).manageNameDfsDirs(false), null);
    }
}

