/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.junit.Assert;
import org.junit.Test;

public class TestDeleteBlockPool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteBlockPool() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            conf.set("dfs.nameservices", "namesServerId1,namesServerId2");
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(conf.get("dfs.nameservices"))).numDataNodes(2).build();
            cluster.waitActive();
            DistributedFileSystem fs1 = cluster.getFileSystem(0);
            DistributedFileSystem fs2 = cluster.getFileSystem(1);
            DFSTestUtil.createFile((FileSystem)fs1, new Path("/alpha"), 1024L, (short)2, 54L);
            DFSTestUtil.createFile((FileSystem)fs2, new Path("/beta"), 1024L, (short)2, 54L);
            DataNode dn1 = cluster.getDataNodes().get(0);
            DataNode dn2 = cluster.getDataNodes().get(1);
            String bpid1 = cluster.getNamesystem(0).getBlockPoolId();
            String bpid2 = cluster.getNamesystem(1).getBlockPoolId();
            File dn1StorageDir1 = cluster.getInstanceStorageDir(0, 0);
            File dn1StorageDir2 = cluster.getInstanceStorageDir(0, 1);
            File dn2StorageDir1 = cluster.getInstanceStorageDir(1, 0);
            File dn2StorageDir2 = cluster.getInstanceStorageDir(1, 1);
            try {
                dn1.deleteBlockPool(bpid1, true);
                Assert.fail((String)"Must not delete a running block pool");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Configuration nn1Conf = cluster.getConfiguration(1);
            nn1Conf.set("dfs.nameservices", "namesServerId2");
            dn1.refreshNamenodes(nn1Conf);
            Assert.assertEquals((long)1L, (long)dn1.getAllBpOs().length);
            try {
                dn1.deleteBlockPool(bpid1, false);
                Assert.fail((String)"Must not delete if any block files exist unless force is true");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.verifyBlockPoolDirectories(true, dn1StorageDir1, bpid1);
            this.verifyBlockPoolDirectories(true, dn1StorageDir2, bpid1);
            dn1.deleteBlockPool(bpid1, true);
            this.verifyBlockPoolDirectories(false, dn1StorageDir1, bpid1);
            this.verifyBlockPoolDirectories(false, dn1StorageDir2, bpid1);
            fs1.delete(new Path("/alpha"), true);
            File finalDir1 = MiniDFSCluster.getFinalizedDir(dn2StorageDir1, bpid1);
            File finalDir2 = MiniDFSCluster.getFinalizedDir(dn2StorageDir1, bpid2);
            while (!DatanodeUtil.dirNoFilesRecursive((File)finalDir1) || !DatanodeUtil.dirNoFilesRecursive((File)finalDir2)) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
            cluster.shutdownNameNode(0);
            try {
                dn2.deleteBlockPool(bpid1, true);
                Assert.fail((String)"Must not delete a running block pool");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dn2.refreshNamenodes(nn1Conf);
            Assert.assertEquals((long)1L, (long)dn2.getAllBpOs().length);
            this.verifyBlockPoolDirectories(true, dn2StorageDir1, bpid1);
            this.verifyBlockPoolDirectories(true, dn2StorageDir2, bpid1);
            dn2.deleteBlockPool(bpid1, false);
            this.verifyBlockPoolDirectories(false, dn2StorageDir1, bpid1);
            this.verifyBlockPoolDirectories(false, dn2StorageDir2, bpid1);
            this.verifyBlockPoolDirectories(true, dn1StorageDir1, bpid2);
            this.verifyBlockPoolDirectories(true, dn1StorageDir2, bpid2);
            this.verifyBlockPoolDirectories(true, dn2StorageDir1, bpid2);
            this.verifyBlockPoolDirectories(true, dn2StorageDir2, bpid2);
            Path gammaFile = new Path("/gamma");
            DFSTestUtil.createFile((FileSystem)fs2, gammaFile, 1024L, (short)1, 55L);
            fs2.setReplication(gammaFile, (short)2);
            DFSTestUtil.waitReplication((FileSystem)fs2, gammaFile, (short)2);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDfsAdminDeleteBlockPool() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            conf.set("dfs.nameservices", "namesServerId1,namesServerId2");
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(conf.get("dfs.nameservices"))).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs1 = cluster.getFileSystem(0);
            DistributedFileSystem fs2 = cluster.getFileSystem(1);
            DFSTestUtil.createFile((FileSystem)fs1, new Path("/alpha"), 1024L, (short)1, 54L);
            DFSTestUtil.createFile((FileSystem)fs2, new Path("/beta"), 1024L, (short)1, 54L);
            DataNode dn1 = cluster.getDataNodes().get(0);
            String bpid1 = cluster.getNamesystem(0).getBlockPoolId();
            String bpid2 = cluster.getNamesystem(1).getBlockPoolId();
            File dn1StorageDir1 = cluster.getInstanceStorageDir(0, 0);
            File dn1StorageDir2 = cluster.getInstanceStorageDir(0, 1);
            Configuration nn1Conf = cluster.getConfiguration(0);
            nn1Conf.set("dfs.nameservices", "namesServerId1");
            dn1.refreshNamenodes(nn1Conf);
            Assert.assertEquals((long)1L, (long)dn1.getAllBpOs().length);
            DFSAdmin admin = new DFSAdmin(nn1Conf);
            String dn1Address = dn1.getDatanodeId().getIpAddr() + ":" + dn1.getIpcPort();
            String[] args = new String[]{"-deleteBlockPool", dn1Address, bpid2};
            int ret = admin.run(args);
            Assert.assertFalse((0 == ret ? 1 : 0) != 0);
            this.verifyBlockPoolDirectories(true, dn1StorageDir1, bpid2);
            this.verifyBlockPoolDirectories(true, dn1StorageDir2, bpid2);
            String[] forceArgs = new String[]{"-deleteBlockPool", dn1Address, bpid2, "force"};
            ret = admin.run(forceArgs);
            Assert.assertEquals((long)0L, (long)ret);
            this.verifyBlockPoolDirectories(false, dn1StorageDir1, bpid2);
            this.verifyBlockPoolDirectories(false, dn1StorageDir2, bpid2);
            this.verifyBlockPoolDirectories(true, dn1StorageDir1, bpid1);
            this.verifyBlockPoolDirectories(true, dn1StorageDir2, bpid1);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void verifyBlockPoolDirectories(boolean shouldExist, File storageDir, String bpid) throws IOException {
        File bpDir = new File(storageDir, "current/" + bpid);
        if (!shouldExist) {
            Assert.assertFalse((boolean)bpDir.exists());
        } else {
            File bpCurrentDir = new File(bpDir, "current");
            File finalizedDir = new File(bpCurrentDir, "finalized");
            File rbwDir = new File(bpCurrentDir, "rbw");
            File versionFile = new File(bpCurrentDir, "VERSION");
            Assert.assertTrue((boolean)finalizedDir.isDirectory());
            Assert.assertTrue((boolean)rbwDir.isDirectory());
            Assert.assertTrue((boolean)versionFile.exists());
        }
    }
}

