/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NamenodeFsck;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestFsck {
    static final String auditLogFile = System.getProperty("test.build.dir", "build/test") + "/TestFsck-audit.log";
    static final Pattern fsckPattern = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=fsck\\ssrc=\\/\\sdst=null\\sperm=null\\sproto=.*");
    static final Pattern getfileinfoPattern = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=getfileinfo\\ssrc=\\/\\sdst=null\\sperm=null\\sproto=.*");
    static final Pattern numCorruptBlocksPattern = Pattern.compile(".*Corrupt blocks:\t\t([0123456789]*).*");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    static String runFsck(Configuration conf, int expectedErrCode, boolean checkErrorCode, String ... path) throws Exception {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        ((Log4JLogger)FSPermissionChecker.LOG).getLogger().setLevel(Level.ALL);
        int errCode = ToolRunner.run((Tool)new DFSck(conf, out), (String[])path);
        if (checkErrorCode) {
            Assert.assertEquals((long)expectedErrCode, (long)errCode);
        }
        ((Log4JLogger)FSPermissionChecker.LOG).getLogger().setLevel(Level.INFO);
        FSImage.LOG.error((Object)("OUTPUT = " + bStream.toString()));
        return bStream.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsck() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(20).build();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            long precision = 1L;
            conf.setLong("dfs.namenode.accesstime.precision", 1L);
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            fs = cluster.getFileSystem();
            String fileName = "/srcdat";
            util.createFiles((FileSystem)fs, "/srcdat");
            util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
            Path file = new Path("/srcdat");
            long aTime = fs.getFileStatus(file).getAccessTime();
            Thread.sleep(1L);
            this.setupAuditLogs();
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            this.verifyAuditLogs();
            Assert.assertEquals((long)aTime, (long)fs.getFileStatus(file).getAccessTime());
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/");
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
            System.out.println(outStr);
            cluster.startDataNodes((Configuration)conf, 4, true, null, null);
            cluster.waitActive();
            cluster.waitClusterUp();
            fs = cluster.getFileSystem();
            util.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void setupAuditLogs() throws IOException {
        File file = new File(auditLogFile);
        if (file.exists()) {
            file.delete();
        }
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%m%n");
        RollingFileAppender appender = new RollingFileAppender((Layout)layout, auditLogFile);
        logger.addAppender((Appender)appender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAuditLogs() throws IOException {
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.OFF);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(auditLogFile));
            for (int i = 0; i < 2; ++i) {
                line = reader.readLine();
                Assert.assertNotNull((Object)line);
                Assert.assertTrue((String)"Expected getfileinfo event not found in audit log", (boolean)getfileinfoPattern.matcher(line).matches());
            }
            line = reader.readLine();
            Assert.assertNotNull((Object)line);
            Assert.assertTrue((String)"Expected fsck event not found in audit log", (boolean)fsckPattern.matcher(line).matches());
            Assert.assertNull((String)"Unexpected event in audit log", (Object)reader.readLine());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (logger != null) {
                logger.removeAllAppenders();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckNonExistent() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(20).build();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            fs = cluster.getFileSystem();
            util.createFiles((FileSystem)fs, "/srcdat");
            util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/non-existent");
            Assert.assertEquals((long)-1L, (long)outStr.indexOf("is HEALTHY"));
            System.out.println(outStr);
            util.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckPermission() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(20).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        MiniDFSCluster cluster = null;
        try {
            MiniDFSCluster c2 = cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            String dir = "/dfsck";
            Path dirpath = new Path("/dfsck");
            DistributedFileSystem fs = c2.getFileSystem();
            util.createFiles((FileSystem)fs, "/dfsck");
            util.waitReplication((FileSystem)fs, "/dfsck", (short)3);
            fs.setPermission(dirpath, new FsPermission(448));
            UserGroupInformation fakeUGI = UserGroupInformation.createUserForTesting((String)"ProbablyNotARealUserName", (String[])new String[]{"ShangriLa"});
            fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf){
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$conf = configuration;
                }

                @Override
                public Object run() throws Exception {
                    System.out.println(TestFsck.runFsck(this.val$conf, -1, true, "/dfsck"));
                    return null;
                }
            });
            fs.setPermission(dirpath, new FsPermission(511));
            fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf){
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$conf = configuration;
                }

                @Override
                public Object run() throws Exception {
                    String outStr = TestFsck.runFsck(this.val$conf, 0, true, "/dfsck");
                    System.out.println(outStr);
                    Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
                    return null;
                }
            });
            util.cleanup((FileSystem)fs, "/dfsck");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckMove() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int DFS_BLOCK_SIZE = 1024;
        int NUM_DATANODES = 4;
        conf.setLong("dfs.blocksize", 1024L);
        conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DFSTestUtil util = new DFSTestUtil("TestFsck", 5, 3, 6143, 5120);
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            String topDir = "/srcdat";
            fs = cluster.getFileSystem();
            cluster.waitActive();
            util.createFiles((FileSystem)fs, topDir);
            util.waitReplication((FileSystem)fs, topDir, (short)3);
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            String[] fileNames = util.getFileNames(topDir);
            CorruptedTestFile[] ctFiles = new CorruptedTestFile[]{new CorruptedTestFile(fileNames[0], Sets.newHashSet((Object[])new Integer[]{0}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[1], Sets.newHashSet((Object[])new Integer[]{2, 3}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[2], Sets.newHashSet((Object[])new Integer[]{4}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[3], Sets.newHashSet((Object[])new Integer[]{0, 1, 2, 3}), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[4], Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4}), dfsClient, 4, 1024)};
            int totalMissingBlocks = 0;
            for (CorruptedTestFile ctFile : ctFiles) {
                totalMissingBlocks += ctFile.getTotalMissingBlocks();
            }
            for (CorruptedTestFile ctFile : ctFiles) {
                ctFile.removeBlocks(cluster);
            }
            while (true) {
                outStr = TestFsck.runFsck((Configuration)conf, 1, false, "/");
                String numCorrupt = null;
                String[] stringArray = outStr.split(LINE_SEPARATOR);
                int n = stringArray.length;
                for (int ctFile = 0; ctFile < n; ++ctFile) {
                    String line = stringArray[ctFile];
                    Matcher m = numCorruptBlocksPattern.matcher(line);
                    if (!m.matches()) continue;
                    numCorrupt = m.group(1);
                    break;
                }
                if (numCorrupt == null) {
                    throw new IOException("failed to find number of corrupt blocks in fsck output.");
                }
                if (numCorrupt.equals(Integer.toString(totalMissingBlocks))) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
            outStr = TestFsck.runFsck((Configuration)conf, 1, false, "/", "-move");
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
            for (CorruptedTestFile ctFile : ctFiles) {
                ctFile.checkSalvagedRemains();
            }
            outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/", "-delete");
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            util.cleanup((FileSystem)fs, topDir);
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckMoveAndDelete() throws Exception {
        int MAX_MOVE_TRIES = 5;
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsckMoveAndDelete").setNumFiles(5).build();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            int i2;
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            String topDir = "/srcdat";
            fs = cluster.getFileSystem();
            cluster.waitActive();
            util.createFiles((FileSystem)fs, topDir);
            util.waitReplication((FileSystem)fs, topDir, (short)3);
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            String[] fileNames = util.getFileNames(topDir);
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            String corruptFileName = fileNames[0];
            ExtendedBlock block = dfsClient.getNamenode().getBlockLocations(corruptFileName, 0L, Long.MAX_VALUE).get(0).getBlock();
            for (i2 = 0; i2 < 4; ++i2) {
                File blockFile = cluster.getBlockFile(i2, block);
                if (blockFile == null || !blockFile.exists()) continue;
                Assert.assertTrue((boolean)blockFile.delete());
            }
            outStr = TestFsck.runFsck((Configuration)conf, 1, false, "/");
            while (!outStr.contains("is CORRUPT")) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException i2) {
                    // empty catch block
                }
                outStr = TestFsck.runFsck((Configuration)conf, 1, false, "/");
            }
            for (i2 = 0; i2 < 5; ++i2) {
                outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/", "-move");
                Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
                String[] newFileNames = util.getFileNames(topDir);
                boolean found = false;
                for (String f : newFileNames) {
                    if (!f.equals(corruptFileName)) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((boolean)found);
            }
            outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/", "-move", "-delete");
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            util.cleanup((FileSystem)fs, topDir);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cluster.shutdown();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckOpenFiles() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(4).build();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            String topDir = "/srcdat";
            String randomString = "HADOOP  ";
            fs = cluster.getFileSystem();
            cluster.waitActive();
            util.createFiles((FileSystem)fs, topDir);
            util.waitReplication((FileSystem)fs, topDir, (short)3);
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Path openFile = new Path(topDir + "/openFile");
            FSDataOutputStream out = fs.create(openFile);
            for (int writeCount = 0; writeCount != 100; ++writeCount) {
                out.write(randomString.getBytes());
            }
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, topDir);
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Assert.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, topDir, "-openforwrite");
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("OPENFORWRITE"));
            Assert.assertTrue((boolean)outStr.contains("openFile"));
            out.close();
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, topDir);
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Assert.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
            util.cleanup((FileSystem)fs, topDir);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cluster.shutdown();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptBlock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.client.retry.window.base", 10);
        DistributedFileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        int factor = 1;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path file1 = new Path("/testCorruptBlock");
            DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, (short)factor, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, file1, (short)factor);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file1);
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            File blockFile = cluster.getBlockFile(0, block);
            if (blockFile != null && blockFile.exists()) {
                RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
                FileChannel channel = raFile.getChannel();
                String badString = "BADBAD";
                int rand = random.nextInt((int)channel.size() / 2);
                raFile.seek(rand);
                raFile.write(badString.getBytes());
                raFile.close();
            }
            try {
                IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
            while (replicaCount != factor) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
                replicaCount = blocks.get(0).getLocations().length;
            }
            Assert.assertTrue((boolean)blocks.get(0).isCorrupt());
            outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/");
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
            Assert.assertTrue((boolean)outStr.contains("testCorruptBlock"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnderMinReplicatedBlock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.client.retry.window.base", 10);
        short minReplication = 2;
        conf.setInt("dfs.namenode.replication.min", (int)minReplication);
        DistributedFileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        int factor = 1;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path file1 = new Path("/testUnderMinReplicatedBlock");
            DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, minReplication, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, file1, minReplication);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file1);
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            File blockFile = cluster.getBlockFile(0, block);
            if (blockFile != null && blockFile.exists()) {
                RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
                FileChannel channel = raFile.getChannel();
                String badString = "BADBAD";
                int rand = random.nextInt((int)channel.size() / 2);
                raFile.seek(rand);
                raFile.write(badString.getBytes());
                raFile.close();
            }
            dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
            while (replicaCount != factor) {
                try {
                    Thread.sleep(100L);
                    try {
                        IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    System.out.println("sleep in try: replicaCount=" + replicaCount + "  factor=" + factor);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
                replicaCount = blocks.get(0).getLocations().length;
            }
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Assert.assertTrue((boolean)outStr.contains("UNDER MIN REPL'D BLOCKS:\t1 (100.0 %)"));
            Assert.assertTrue((boolean)outStr.contains("dfs.namenode.replication.min:\t2"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckError() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            String fileName = "/test.txt";
            Path filePath = new Path(fileName);
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
            INodeFile node = (INodeFile)cluster.getNamesystem().dir.getINode(fileName, true);
            BlockInfoContiguous[] blocks = node.getBlocks();
            Assert.assertEquals((long)blocks.length, (long)1L);
            blocks[0].setNumBytes(-1L);
            String outStr = TestFsck.runFsck((Configuration)conf, -1, true, fileName);
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("FAILED"));
            fs.delete(filePath, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckListCorruptFilesBlocks() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "/corruptData", (short)1);
            util.waitReplication((FileSystem)fs, "/corruptData", (short)1);
            String outStr = TestFsck.runFsck(conf, 0, false, "/corruptData", "-list-corruptfileblocks");
            System.out.println("1. good fsck out: " + outStr);
            Assert.assertTrue((boolean)outStr.contains("has 0 CORRUPT files"));
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = cluster.getInstanceStorageDir(i, j);
                    File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                    List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                    if (metadataFiles == null) continue;
                    for (File metadataFile : metadataFiles) {
                        File blockFile = Block.metaToBlockFile((File)metadataFile);
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)blockFile.delete());
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)metadataFile.delete());
                    }
                }
            }
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            CorruptFileBlocks corruptFileBlocks = namenode.listCorruptFileBlocks("/corruptData", null);
            int numCorrupt = corruptFileBlocks.getFiles().length;
            while (numCorrupt == 0) {
                Thread.sleep(1000L);
                corruptFileBlocks = namenode.listCorruptFileBlocks("/corruptData", null);
                numCorrupt = corruptFileBlocks.getFiles().length;
            }
            outStr = TestFsck.runFsck(conf, -1, true, "/corruptData", "-list-corruptfileblocks");
            System.out.println("2. bad fsck out: " + outStr);
            Assert.assertTrue((boolean)outStr.contains("has 3 CORRUPT files"));
            util.createFiles((FileSystem)fs, "/goodData");
            outStr = TestFsck.runFsck(conf, 0, true, "/goodData", "-list-corruptfileblocks");
            System.out.println("3. good fsck out: " + outStr);
            Assert.assertTrue((boolean)outStr.contains("has 0 CORRUPT files"));
            util.cleanup((FileSystem)fs, "/corruptData");
            util.cleanup((FileSystem)fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToCheckTheFsckCommandOnIllegalArguments() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            String fileName = "/test.txt";
            Path filePath = new Path(fileName);
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
            String outStr = TestFsck.runFsck((Configuration)conf, -1, true, fileName, "-thisIsNotAValidFlag");
            System.out.println(outStr);
            Assert.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
            outStr = TestFsck.runFsck((Configuration)conf, -1, true, "/", fileName);
            System.out.println(outStr);
            Assert.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
            fs.delete(filePath, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckMissingReplicas() throws IOException {
        int REPL_FACTOR = 2;
        boolean NUM_REPLICAS = true;
        int NUM_BLOCKS = 3;
        long blockSize = 512L;
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 512L);
        MiniDFSCluster cluster = null;
        DistributedFileSystem dfs = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            Assert.assertNotNull((String)"Failed Cluster Creation", (Object)cluster);
            cluster.waitClusterUp();
            dfs = cluster.getFileSystem();
            Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
            String pathString = new String("/testfile");
            Path path = new Path(pathString);
            long fileLen = 1536L;
            DFSTestUtil.createFile((FileSystem)dfs, path, fileLen, (short)2, 1L);
            NameNode namenode = cluster.getNameNode();
            NetworkTopology nettop = cluster.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology();
            HashMap pmap = new HashMap();
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)result, true);
            InetAddress remoteAddress = InetAddress.getLocalHost();
            NamenodeFsck fsck = new NamenodeFsck(conf, namenode, nettop, pmap, out, 1, remoteAddress);
            HdfsFileStatus file = namenode.getRpcServer().getFileInfo(pathString);
            Assert.assertNotNull((Object)file);
            NamenodeFsck.Result res = new NamenodeFsck.Result(conf);
            fsck.check(pathString, file, res);
            System.out.println(((Object)result).toString());
            Assert.assertEquals((long)res.missingReplicas, (long)3L);
            Assert.assertEquals((long)res.numExpectedReplicas, (long)6L);
        }
        finally {
            if (dfs != null) {
                dfs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckMisPlacedReplicas() throws IOException {
        int REPL_FACTOR = 2;
        int NUM_DN = 2;
        int NUM_BLOCKS = 3;
        long blockSize = 512L;
        String[] racks = new String[]{"/rack1", "/rack1"};
        String[] hosts = new String[]{"host1", "host2"};
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 512L);
        MiniDFSCluster cluster = null;
        DistributedFileSystem dfs = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(NUM_DN).hosts(hosts).racks(racks).build();
            Assert.assertNotNull((String)"Failed Cluster Creation", (Object)cluster);
            cluster.waitClusterUp();
            dfs = cluster.getFileSystem();
            Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
            String pathString = new String("/testfile");
            Path path = new Path(pathString);
            long fileLen = 1536L;
            DFSTestUtil.createFile((FileSystem)dfs, path, fileLen, (short)2, 1L);
            NameNode namenode = cluster.getNameNode();
            NetworkTopology nettop = cluster.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology();
            nettop.add((Node)DFSTestUtil.getDatanodeDescriptor("/rack2", "/host3"));
            NUM_DN = (short)(NUM_DN + 1);
            HashMap pmap = new HashMap();
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)result, true);
            InetAddress remoteAddress = InetAddress.getLocalHost();
            NamenodeFsck fsck = new NamenodeFsck(conf, namenode, nettop, pmap, out, NUM_DN, remoteAddress);
            HdfsFileStatus file = namenode.getRpcServer().getFileInfo(pathString);
            Assert.assertNotNull((Object)file);
            NamenodeFsck.Result res = new NamenodeFsck.Result(conf);
            fsck.check(pathString, file, res);
            Assert.assertEquals((long)res.numMisReplicatedBlocks, (long)3L);
        }
        finally {
            if (dfs != null) {
                dfs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testFsckFileNotFound() throws Exception {
        boolean NUM_REPLICAS = true;
        Configuration conf = new Configuration();
        NameNode namenode = (NameNode)Mockito.mock(NameNode.class);
        NetworkTopology nettop = (NetworkTopology)Mockito.mock(NetworkTopology.class);
        HashMap pmap = new HashMap();
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)result, true);
        InetAddress remoteAddress = InetAddress.getLocalHost();
        FSNamesystem fsName = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        BlockManager blockManager = (BlockManager)Mockito.mock(BlockManager.class);
        DatanodeManager dnManager = (DatanodeManager)Mockito.mock(DatanodeManager.class);
        Mockito.when((Object)namenode.getNamesystem()).thenReturn((Object)fsName);
        Mockito.when((Object)fsName.getBlockLocations((FSPermissionChecker)Matchers.any(FSPermissionChecker.class), Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new FileNotFoundException()});
        Mockito.when((Object)fsName.getBlockManager()).thenReturn((Object)blockManager);
        Mockito.when((Object)blockManager.getDatanodeManager()).thenReturn((Object)dnManager);
        NamenodeFsck fsck = new NamenodeFsck(conf, namenode, nettop, pmap, out, 1, remoteAddress);
        String pathString = "/tmp/testFile";
        long length = 123L;
        boolean isDir = false;
        int blockReplication = 1;
        long blockSize = 131072L;
        long modTime = 123123123L;
        long accessTime = 123123120L;
        FsPermission perms = FsPermission.getDefault();
        String owner = "foo";
        String group = "bar";
        byte[] symlink = null;
        byte[] path = new byte[128];
        path = DFSUtil.string2Bytes((String)pathString);
        long fileId = 312321L;
        int numChildren = 1;
        byte storagePolicy = 0;
        HdfsFileStatus file = new HdfsFileStatus(length, isDir, blockReplication, blockSize, modTime, accessTime, perms, owner, group, symlink, path, fileId, numChildren, null, storagePolicy);
        NamenodeFsck.Result res = new NamenodeFsck.Result(conf);
        try {
            fsck.check(pathString, file, res);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        Assert.assertTrue((boolean)res.toString().contains("HEALTHY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckSymlink() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            long precision = 1L;
            conf.setLong("dfs.namenode.accesstime.precision", 1L);
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            fs = cluster.getFileSystem();
            String fileName = "/srcdat";
            util.createFiles((FileSystem)fs, "/srcdat");
            FileContext fc = FileContext.getFileContext((Configuration)cluster.getConfiguration(0));
            Path file = new Path("/srcdat");
            Path symlink = new Path("/srcdat-symlink");
            fc.createSymlink(file, symlink, false);
            util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
            long aTime = fc.getFileStatus(symlink).getAccessTime();
            Thread.sleep(1L);
            this.setupAuditLogs();
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            this.verifyAuditLogs();
            Assert.assertEquals((long)aTime, (long)fc.getFileStatus(symlink).getAccessTime());
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Assert.assertTrue((boolean)outStr.contains("Total symlinks:\t\t1"));
            util.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckForSnapshotFiles() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            String runFsck = TestFsck.runFsck((Configuration)conf, 0, true, "/", "-includeSnapshots", "-files");
            Assert.assertTrue((boolean)runFsck.contains("HEALTHY"));
            String fileName = "/srcdat";
            DistributedFileSystem hdfs = cluster.getFileSystem();
            Path file1 = new Path("/srcdat");
            DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)1, 1000L);
            hdfs.allowSnapshot(new Path("/"));
            hdfs.createSnapshot(new Path("/"), "mySnapShot");
            runFsck = TestFsck.runFsck((Configuration)conf, 0, true, "/", "-includeSnapshots", "-files");
            Assert.assertTrue((boolean)runFsck.contains("/.snapshot/mySnapShot/srcdat"));
            runFsck = TestFsck.runFsck((Configuration)conf, 0, true, "/", "-files");
            Assert.assertFalse((boolean)runFsck.contains("mySnapShot"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockIdCK() throws Exception {
        int REPL_FACTOR = 2;
        int NUM_DN = 2;
        long blockSize = 512L;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 512L);
        conf.setInt("dfs.replication", 2);
        MiniDFSCluster cluster = null;
        DistributedFileSystem dfs = null;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(NUM_DN).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)cluster);
        cluster.waitClusterUp();
        dfs = cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)2, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)2);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        try {
            String runFsckResult = TestFsck.runFsck(conf, 0, true, "/", "-blockId", "not_a_block_id");
            Assert.assertTrue((boolean)runFsckResult.contains("Incorrect blockId format:"));
            runFsckResult = TestFsck.runFsck(conf, 0, true, "/", "-blockId", sb.toString());
            Assert.assertTrue((boolean)runFsckResult.contains(bIds[0]));
            Assert.assertTrue((boolean)runFsckResult.contains(bIds[1]));
            Assert.assertTrue((boolean)runFsckResult.contains("Block replica on datanode/rack: host1/rack1 is HEALTHY"));
            Assert.assertTrue((boolean)runFsckResult.contains("Block replica on datanode/rack: host2/rack2 is HEALTHY"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockIdCKDecommission() throws Exception {
        boolean REPL_FACTOR = true;
        int NUM_DN = 2;
        long blockSize = 512L;
        boolean checkDecommissionInProgress = false;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 512L);
        conf.setInt("dfs.replication", 2);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(NUM_DN).hosts(hosts).racks(racks).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)cluster);
        cluster.waitClusterUp();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = new String("/testfile");
        Path path = new Path(pathString);
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        try {
            String fsckOut;
            String outStr = TestFsck.runFsck(conf, 0, true, "/", "-blockId", bIds[0]);
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            ExtendedBlock eb = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
            DatanodeDescriptor dn = cluster.getNameNode().getNamesystem().getBlockManager().getBlockCollection(eb.getLocalBlock()).getBlocks()[0].getDatanode(0);
            cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDecomManager().startDecommission(dn);
            String dnName = dn.getXferAddr();
            DatanodeInfo datanodeInfo = null;
            boolean count = false;
            do {
                Thread.sleep(2000L);
                for (DatanodeInfo info : dfs.getDataNodeStats()) {
                    if (!dnName.equals(info.getXferAddr())) continue;
                    datanodeInfo = info;
                }
                if (checkDecommissionInProgress || datanodeInfo == null || !datanodeInfo.isDecommissionInProgress()) continue;
                fsckOut = TestFsck.runFsck(conf, 3, true, "/", "-blockId", bIds[0]);
                Assert.assertTrue((boolean)fsckOut.contains("is DECOMMISSIONING"));
                checkDecommissionInProgress = true;
            } while (datanodeInfo != null && !datanodeInfo.isDecommissioned());
            fsckOut = TestFsck.runFsck(conf, 2, true, "/", "-blockId", bIds[0]);
            Assert.assertTrue((boolean)fsckOut.contains("is DECOMMISSIONED"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockIdCKCorruption() throws Exception {
        int NUM_DN = 1;
        long blockSize = 512L;
        Random random = new Random();
        short repFactor = 1;
        String[] racks = new String[]{"/rack1"};
        String[] hosts = new String[]{"host1"};
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.client.retry.window.base", 10);
        conf.setLong("dfs.blocksize", 512L);
        conf.setInt("dfs.replication", 1);
        MiniDFSCluster cluster = null;
        DistributedFileSystem dfs = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(NUM_DN).hosts(hosts).racks(racks).build();
            Assert.assertNotNull((String)"Failed Cluster Creation", (Object)cluster);
            cluster.waitClusterUp();
            dfs = cluster.getFileSystem();
            Assert.assertNotNull((String)"Failed to get FileSystem", (Object)dfs);
            DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
            String pathString = new String("/testfile");
            Path path = new Path(pathString);
            DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, repFactor, 1000L);
            DFSTestUtil.waitReplication((FileSystem)dfs, path, repFactor);
            StringBuilder sb = new StringBuilder();
            for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
                sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
            }
            String[] bIds = sb.toString().split(" ");
            String outStr = TestFsck.runFsck(conf, 0, true, "/", "-blockId", bIds[0]);
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
            File blockFile = cluster.getBlockFile(0, block);
            if (blockFile != null && blockFile.exists()) {
                RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
                FileChannel channel = raFile.getChannel();
                String badString = "BADBAD";
                int rand = random.nextInt((int)channel.size() / 2);
                raFile.seek(rand);
                raFile.write(badString.getBytes());
                raFile.close();
            }
            DFSTestUtil.waitCorruptReplicas((FileSystem)dfs, cluster.getNamesystem(), path, block, 1);
            outStr = TestFsck.runFsck(conf, 1, false, "/", "-blockId", block.getBlockName());
            System.out.println(outStr);
            Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void writeFile(DistributedFileSystem dfs, Path dir, String fileName) throws IOException {
        Path filePath = new Path(dir.toString() + "/" + fileName);
        FSDataOutputStream out = dfs.create(filePath);
        out.writeChars("teststring");
        out.close();
    }

    private void writeFile(DistributedFileSystem dfs, String dirName, String fileName, String StoragePolicy) throws IOException {
        Path dirPath = new Path(dirName);
        dfs.mkdirs(dirPath);
        dfs.setStoragePolicy(dirPath, StoragePolicy);
        this.writeFile(dfs, dirPath, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoragePoliciesCK() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            this.writeFile(dfs, "/testhot", "file", "HOT");
            this.writeFile(dfs, "/testwarm", "file", "WARM");
            this.writeFile(dfs, "/testcold", "file", "COLD");
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/", "-storagepolicies");
            Assert.assertTrue((boolean)outStr.contains("DISK:3(HOT)"));
            Assert.assertTrue((boolean)outStr.contains("DISK:1,ARCHIVE:2(WARM)"));
            Assert.assertTrue((boolean)outStr.contains("ARCHIVE:3(COLD)"));
            Assert.assertTrue((boolean)outStr.contains("All blocks satisfy specified storage policy."));
            dfs.setStoragePolicy(new Path("/testhot"), "COLD");
            dfs.setStoragePolicy(new Path("/testwarm"), "COLD");
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/", "-storagepolicies");
            Assert.assertTrue((boolean)outStr.contains("DISK:3(HOT)"));
            Assert.assertTrue((boolean)outStr.contains("DISK:1,ARCHIVE:2(WARM)"));
            Assert.assertTrue((boolean)outStr.contains("ARCHIVE:3(COLD)"));
            Assert.assertFalse((boolean)outStr.contains("All blocks satisfy specified storage policy."));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testFsckCorruptWhenOneReplicaIsCorrupt() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(2).build();
        try {
            cluster.waitActive();
            FileSystem fs = HATestUtil.configureFailoverFs(cluster, (Configuration)conf);
            cluster.transitionToActive(0);
            String filePath = "/appendTest";
            Path fileName = new Path(filePath);
            DFSTestUtil.createFile(fs, fileName, 512L, (short)2, 0L);
            DFSTestUtil.waitReplication(fs, fileName, (short)2);
            Assert.assertTrue((String)"File not created", (boolean)fs.exists(fileName));
            cluster.getDataNodes().get(1).shutdown();
            DFSTestUtil.appendFile(fs, fileName, "appendCorruptBlock");
            cluster.restartDataNode(1, true);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return cluster.getNameNode(0).getNamesystem().getCorruptReplicaBlocks() > 0L;
                }
            }, (int)100, (int)5000);
            DFSTestUtil.appendFile(fs, fileName, "appendCorruptBlock");
            TestFsck.runFsck(cluster.getConfiguration(0), 0, true, "/");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static class CorruptedTestFile {
        private final String name;
        private final Set<Integer> blocksToCorrupt;
        private final DFSClient dfsClient;
        private final int numDataNodes;
        private final int blockSize;
        private final byte[] initialContents;

        public CorruptedTestFile(String name, Set<Integer> blocksToCorrupt, DFSClient dfsClient, int numDataNodes, int blockSize) throws IOException {
            this.name = name;
            this.blocksToCorrupt = blocksToCorrupt;
            this.dfsClient = dfsClient;
            this.numDataNodes = numDataNodes;
            this.blockSize = blockSize;
            this.initialContents = this.cacheInitialContents();
        }

        public int getTotalMissingBlocks() {
            return this.blocksToCorrupt.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] cacheInitialContents() throws IOException {
            HdfsFileStatus status = this.dfsClient.getFileInfo(this.name);
            byte[] content = new byte[(int)status.getLen()];
            try (DFSInputStream in = null;){
                in = this.dfsClient.open(this.name);
                IOUtils.readFully((InputStream)in, (byte[])content, (int)0, (int)content.length);
            }
            return content;
        }

        public void removeBlocks(MiniDFSCluster cluster) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            for (int corruptIdx : this.blocksToCorrupt) {
                ExtendedBlock block = this.dfsClient.getNamenode().getBlockLocations(this.name, (long)(this.blockSize * corruptIdx), Long.MAX_VALUE).get(0).getBlock();
                for (int i = 0; i < this.numDataNodes; ++i) {
                    File blockFile = cluster.getBlockFile(i, block);
                    if (blockFile == null || !blockFile.exists()) continue;
                    Assert.assertTrue((boolean)blockFile.delete());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkSalvagedRemains() throws IOException {
            int chainIdx = 0;
            HdfsFileStatus status = this.dfsClient.getFileInfo(this.name);
            long length = status.getLen();
            int numBlocks = (int)((length + (long)this.blockSize - 1L) / (long)this.blockSize);
            DFSInputStream in = null;
            byte[] blockBuffer = new byte[this.blockSize];
            try {
                for (int blockIdx = 0; blockIdx < numBlocks; ++blockIdx) {
                    if (this.blocksToCorrupt.contains(blockIdx)) {
                        if (in == null) continue;
                        in.close();
                        in = null;
                        continue;
                    }
                    if (in == null) {
                        in = this.dfsClient.open("/lost+found" + this.name + "/" + chainIdx);
                        ++chainIdx;
                    }
                    int len = blockBuffer.length;
                    if (blockIdx == numBlocks - 1 && (len = (int)(in.getFileLength() % (long)this.blockSize)) == 0) {
                        len = blockBuffer.length;
                    }
                    IOUtils.readFully(in, (byte[])blockBuffer, (int)0, (int)len);
                    int startIdx = blockIdx * this.blockSize;
                    for (int i = 0; i < len; ++i) {
                        if (this.initialContents[startIdx + i] == blockBuffer[i]) continue;
                        throw new IOException("salvaged file " + this.name + " differed from what we expected on block " + blockIdx);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
        }
    }
}

