/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFileSystemWithXAttrs {
    private static MiniDFSCluster cluster;
    private static Configuration clusterConf;
    private static FileSystem fHdfs;
    private static FileSystem fHdfs2;
    private FileSystem fsView;
    private Configuration fsViewConf;
    private FileSystem fsTarget;
    private FileSystem fsTarget2;
    private Path targetTestRoot;
    private Path targetTestRoot2;
    private Path mountOnNn1;
    private Path mountOnNn2;
    private FileSystemTestHelper fileSystemTestHelper = new FileSystemTestHelper("/tmp/TestViewFileSystemWithXAttrs");
    protected static final String name1 = "user.a1";
    protected static final byte[] value1;
    protected static final String name2 = "user.a2";
    protected static final byte[] value2;

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException {
        cluster = new MiniDFSCluster.Builder(clusterConf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem(0);
        fHdfs2 = cluster.getFileSystem(1);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        cluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        this.fsTarget2 = fHdfs2;
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.targetTestRoot2 = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget2);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget2.delete(this.targetTestRoot2, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
        this.fsTarget2.mkdirs(this.targetTestRoot2);
        this.fsViewConf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        this.fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.fsViewConf);
    }

    private void setupMountPoints() {
        this.mountOnNn1 = new Path("/mountOnNn1");
        this.mountOnNn2 = new Path("/mountOnNn2");
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn1.toString(), (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn2.toString(), (URI)this.targetTestRoot2.toUri());
    }

    @After
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
        this.fsTarget2.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget2), true);
    }

    @Test
    public void testXAttrOnMountEntry() throws Exception {
        this.fsView.setXAttr(this.mountOnNn1, name1, value1);
        this.fsView.setXAttr(this.mountOnNn1, name2, value2);
        Assert.assertEquals((long)2L, (long)this.fsView.getXAttrs(this.mountOnNn1).size());
        Assert.assertArrayEquals((byte[])value1, (byte[])this.fsView.getXAttr(this.mountOnNn1, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])this.fsView.getXAttr(this.mountOnNn1, name2));
        Assert.assertArrayEquals((byte[])value1, (byte[])fHdfs.getXAttr(this.targetTestRoot, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])fHdfs.getXAttr(this.targetTestRoot, name2));
        Assert.assertEquals((long)0L, (long)this.fsView.getXAttrs(this.mountOnNn2).size());
        Assert.assertEquals((long)0L, (long)fHdfs2.getXAttrs(this.targetTestRoot2).size());
        this.fsView.removeXAttr(this.mountOnNn1, name1);
        this.fsView.removeXAttr(this.mountOnNn1, name2);
        Assert.assertEquals((long)0L, (long)this.fsView.getXAttrs(this.mountOnNn1).size());
        Assert.assertEquals((long)0L, (long)fHdfs.getXAttrs(this.targetTestRoot).size());
        this.fsView.setXAttr(this.mountOnNn2, name1, value1);
        this.fsView.setXAttr(this.mountOnNn2, name2, value2);
        Assert.assertEquals((long)2L, (long)this.fsView.getXAttrs(this.mountOnNn2).size());
        Assert.assertArrayEquals((byte[])value1, (byte[])this.fsView.getXAttr(this.mountOnNn2, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])this.fsView.getXAttr(this.mountOnNn2, name2));
        Assert.assertArrayEquals((byte[])value1, (byte[])fHdfs2.getXAttr(this.targetTestRoot2, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])fHdfs2.getXAttr(this.targetTestRoot2, name2));
        this.fsView.removeXAttr(this.mountOnNn2, name1);
        this.fsView.removeXAttr(this.mountOnNn2, name2);
        Assert.assertEquals((long)0L, (long)this.fsView.getXAttrs(this.mountOnNn2).size());
        Assert.assertEquals((long)0L, (long)fHdfs2.getXAttrs(this.targetTestRoot2).size());
    }

    static {
        clusterConf = new Configuration();
        value1 = new byte[]{49, 50, 51};
        value2 = new byte[]{55, 56, 57};
    }
}

