/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSClientSocketSize {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSClientSocketSize.class);
    private final Configuration conf = new Configuration();
    private MiniDFSCluster cluster;
    private Socket socket;

    @Test
    public void testDefaultSendBufferSize() throws IOException {
        this.socket = this.createSocket();
        Assert.assertEquals((String)"Send buffer size should be the default value.", (long)131072L, (long)this.socket.getSendBufferSize());
    }

    @Test
    public void testSpecifiedSendBufferSize() throws IOException {
        int mySendBufferSize = 65536;
        this.conf.setInt("dfs.client.socket.send.buffer.size", 65536);
        this.socket = this.createSocket();
        Assert.assertEquals((String)"Send buffer size should be the customized value.", (long)65536L, (long)this.socket.getSendBufferSize());
    }

    @Test
    public void testAutoTuningSendBufferSize() throws IOException {
        this.conf.setInt("dfs.client.socket.send.buffer.size", 0);
        this.socket = this.createSocket();
        LOG.info("The auto tuned send buffer size is: {}", (Object)this.socket.getSendBufferSize());
        Assert.assertTrue((String)"Send buffer size should be non-negative value which is determined by system (kernel).", (this.socket.getSendBufferSize() > 0 ? 1 : 0) != 0);
    }

    @After
    public void tearDown() throws Exception {
        if (this.socket != null) {
            LOG.info("Closing the DFSClient socket.");
        }
        if (this.cluster != null) {
            LOG.info("Shutting down MiniDFSCluster.");
            this.cluster.shutdown();
        }
    }

    private Socket createSocket() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        LOG.info("MiniDFSCluster started.");
        return DFSOutputStream.createSocketForPipeline((DatanodeInfo)new DatanodeInfo(this.cluster.dataNodes.get((int)0).datanode.getDatanodeId()), (int)1, (DFSClient)this.cluster.getFileSystem().getClient());
    }

    static {
        GenericTestUtils.setLogLevel((Log)DFSClient.LOG, (Level)Level.ALL);
    }
}

