/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.ipc.metrics.RetryCacheMetrics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeRetryCacheMetrics {
    private MiniDFSCluster cluster;
    private FSNamesystem namesystem;
    private DistributedFileSystem filesystem;
    private final int namenodeId = 0;
    private Configuration conf;
    private RetryCacheMetrics metrics;
    private DFSClient client;

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.namenode.enable.retrycache", true);
        this.conf.setInt("dfs.client.test.drop.namenode.response.number", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
        HATestUtil.setFailoverConfigurations(this.cluster, this.conf);
        this.filesystem = (DistributedFileSystem)HATestUtil.configureFailoverFs(this.cluster, this.conf);
        this.namesystem = this.cluster.getNamesystem(0);
        this.metrics = this.namesystem.getRetryCache().getMetricsForTests();
    }

    @After
    public void cleanup() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testRetryCacheMetrics() throws IOException {
        this.checkMetrics(0L, 0L, 0L);
        this.trySaveNamespace();
        this.checkMetrics(2L, 0L, 1L);
        this.namesystem.close();
        this.checkMetrics(2L, 1L, 1L);
    }

    private void checkMetrics(long hit, long cleared, long updated) {
        Assert.assertEquals((String)"CacheHit", (long)hit, (long)this.metrics.getCacheHit());
        Assert.assertEquals((String)"CacheCleared", (long)cleared, (long)this.metrics.getCacheCleared());
        Assert.assertEquals((String)"CacheUpdated", (long)updated, (long)this.metrics.getCacheUpdated());
    }

    private void trySaveNamespace() throws IOException {
        this.filesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.filesystem.saveNamespace();
        this.filesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
    }
}

