/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ReadStripedFileWithDecodingHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestReadStripedFileWithDecodingCorruptData {
    static final Logger LOG = LoggerFactory.getLogger(TestReadStripedFileWithDecodingCorruptData.class);
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);
    private int fileLength;
    private int dataDelNum;
    private int parityDelNum;

    @BeforeClass
    public static void setup() throws IOException {
        cluster = ReadStripedFileWithDecodingHelper.initializeCluster();
        dfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        ReadStripedFileWithDecodingHelper.tearDownCluster(cluster);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return ReadStripedFileWithDecodingHelper.getParameters();
    }

    public TestReadStripedFileWithDecodingCorruptData(int fileLength, int dataDelNum, int parityDelNum) {
        this.fileLength = fileLength;
        this.dataDelNum = dataDelNum;
        this.parityDelNum = parityDelNum;
    }

    @Test
    public void testReadCorruptedData() throws IOException {
        String src = "/corrupted_" + this.dataDelNum + "_" + this.parityDelNum;
        ReadStripedFileWithDecodingHelper.testReadWithBlockCorrupted(cluster, dfs, src, this.fileLength, this.dataDelNum, this.parityDelNum, false);
    }
}

