/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestRollingUpgrade;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.junit.Assert;
import org.junit.Test;

public class TestRollingUpgradeRollback {
    private static final int NUM_JOURNAL_NODES = 3;
    private static final String JOURNAL_ID = "myjournal";

    private static boolean fileExists(List<File> files) {
        for (File file : files) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private void checkNNStorage(NNStorage storage, long imageTxId, long trashEndTxId) {
        List finalizedEdits = storage.getFiles((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, NNStorage.getFinalizedEditsFileName((long)1L, (long)imageTxId));
        Assert.assertTrue((boolean)TestRollingUpgradeRollback.fileExists(finalizedEdits));
        List inprogressEdits = storage.getFiles((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, NNStorage.getInProgressEditsFileName((long)(imageTxId + 1L)));
        Assert.assertTrue((boolean)TestRollingUpgradeRollback.fileExists(inprogressEdits));
        if (trashEndTxId > 0L) {
            List trashedEdits = storage.getFiles((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, NNStorage.getFinalizedEditsFileName((long)(imageTxId + 1L), (long)trashEndTxId) + ".trash");
            Assert.assertTrue((boolean)TestRollingUpgradeRollback.fileExists(trashedEdits));
        }
        String imageFileName = trashEndTxId > 0L ? NNStorage.getImageFileName((long)imageTxId) : NNStorage.getRollbackImageFileName((long)imageTxId);
        List imageFiles = storage.getFiles((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE, imageFileName);
        Assert.assertTrue((boolean)TestRollingUpgradeRollback.fileExists(imageFiles));
    }

    private void checkJNStorage(File dir, long discardStartTxId, long discardEndTxId) {
        File finalizedEdits = new File(dir, NNStorage.getFinalizedEditsFileName((long)1L, (long)(discardStartTxId - 1L)));
        Assert.assertTrue((boolean)finalizedEdits.exists());
        File trashEdits = new File(dir, NNStorage.getFinalizedEditsFileName((long)discardStartTxId, (long)discardEndTxId) + ".trash");
        Assert.assertTrue((boolean)trashEdits.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackCommand() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        Path foo = new Path("/foo");
        Path bar = new Path("/bar");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            dfs.mkdirs(foo);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            Assert.assertEquals((long)0L, (long)dfsadmin.run(new String[]{"-rollingUpgrade", "prepare"}));
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            dfs.mkdirs(bar);
            NNStorage storage = cluster.getNamesystem().getFSImage().getStorage();
            this.checkNNStorage(storage, 3L, -1L);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        NameNode nn = null;
        try {
            nn = NameNode.createNameNode((String[])new String[]{"-rollingUpgrade", "rollback"}, (Configuration)conf);
            INode fooNode = nn.getNamesystem().getFSDirectory().getINode4Write(foo.toString());
            Assert.assertNotNull((Object)fooNode);
            INode barNode = nn.getNamesystem().getFSDirectory().getINode4Write(bar.toString());
            Assert.assertNull((Object)barNode);
            NNStorage storage = nn.getNamesystem().getFSImage().getStorage();
            this.checkNNStorage(storage, 3L, 7L);
        }
        finally {
            if (nn != null) {
                nn.stop();
                nn.join();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackWithQJM() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniJournalCluster mjc = null;
        MiniDFSCluster cluster = null;
        Path foo = new Path("/foo");
        Path bar = new Path("/bar");
        try {
            mjc = new MiniJournalCluster.Builder((Configuration)conf).numJournalNodes(3).build();
            mjc.waitActive();
            conf.set("dfs.namenode.edits.dir", mjc.getQuorumJournalURI(JOURNAL_ID).toString());
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            dfs.mkdirs(foo);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            Assert.assertEquals((long)0L, (long)dfsadmin.run(new String[]{"-rollingUpgrade", "prepare"}));
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            dfs.mkdirs(bar);
            dfs.close();
            cluster.restartNameNode("-rollingUpgrade", "rollback");
            dfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertFalse((boolean)dfs.exists(bar));
            for (int i = 0; i < 3; ++i) {
                File dir = mjc.getCurrentDir(0, JOURNAL_ID);
                this.checkJNStorage(dir, 4L, 7L);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            if (mjc != null) {
                mjc.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackWithHAQJM() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = null;
        Path foo = new Path("/foo");
        Path bar = new Path("/bar");
        try {
            cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.getConfiguration(1).setInt("dfs.ha.tail-edits.period", 1);
            dfsCluster.restartNameNode(1);
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            dfs.mkdirs(foo);
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            dfs.mkdirs(bar);
            dfs.close();
            dfs = dfsCluster.getFileSystem(0);
            TestRollingUpgrade.queryForPreparation(dfs);
            Assert.assertTrue((boolean)dfsCluster.getNameNode(0).getFSImage().hasRollbackFSImage());
            Assert.assertTrue((boolean)dfsCluster.getNameNode(1).getFSImage().hasRollbackFSImage());
            dfsCluster.restartNameNode(0, true, "-rollingUpgrade", "rollback");
            dfsCluster.shutdownNameNode(1);
            dfsCluster.transitionToActive(0);
            dfs = dfsCluster.getFileSystem(0);
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertFalse((boolean)dfs.exists(bar));
            NNStorage storage = dfsCluster.getNamesystem(0).getFSImage().getStorage();
            this.checkNNStorage(storage, 4L, 7L);
            for (int i = 0; i < 3; ++i) {
                File dir = cluster.getJournalCluster().getCurrentDir(0, "ns1");
                this.checkJNStorage(dir, 5L, 7L);
            }
            dfsCluster.restartNameNode(0);
            dfsCluster.transitionToActive(0);
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

