/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.ThrottledAsyncChecker;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestThrottledAsyncChecker {
    public static final Logger LOG = LoggerFactory.getLogger(TestThrottledAsyncChecker.class);
    private static final long MIN_ERROR_CHECK_GAP = 1000L;

    @Test(timeout=60000L)
    public void testScheduler() throws Exception {
        NoOpCheckable target1 = new NoOpCheckable();
        NoOpCheckable target2 = new NoOpCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 1000L, 0L, this.getExecutorService());
        Assert.assertTrue((boolean)checker.schedule((Checkable)target1, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target1, 1L);
        Assert.assertFalse((boolean)checker.schedule((Checkable)target1, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target1, 1L);
        Assert.assertTrue((boolean)checker.schedule((Checkable)target2, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target2, 1L);
        timer.advance(999L);
        Assert.assertFalse((boolean)checker.schedule((Checkable)target1, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target1, 1L);
        Assert.assertFalse((boolean)checker.schedule((Checkable)target2, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target2, 1L);
        timer.advance(1000L);
        Assert.assertTrue((boolean)checker.schedule((Checkable)target1, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target1, 2L);
        Assert.assertTrue((boolean)checker.schedule((Checkable)target2, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target2, 2L);
    }

    @Test(timeout=60000L)
    public void testConcurrentChecks() throws Exception {
        StalledCheckable target = new StalledCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 1000L, 0L, this.getExecutorService());
        Optional olf1 = checker.schedule((Checkable)target, (Object)true);
        Optional olf2 = checker.schedule((Checkable)target, (Object)true);
        Assert.assertTrue((boolean)olf1.isPresent());
        Assert.assertFalse((boolean)olf2.isPresent());
    }

    @Test(timeout=60000L)
    public void testContextIsPassed() throws Exception {
        NoOpCheckable target1 = new NoOpCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 1000L, 0L, this.getExecutorService());
        Assert.assertTrue((boolean)checker.schedule((Checkable)target1, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target1, 1L);
        timer.advance(1001L);
        Assert.assertTrue((boolean)checker.schedule((Checkable)target1, (Object)false).isPresent());
        this.waitTestCheckableCheckCount(target1, 2L);
    }

    private void waitTestCheckableCheckCount(final TestCheckableBase target, final long expectedChecks) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return target.getTotalChecks() == expectedChecks;
            }
        }, (int)100, (int)10000);
    }

    @Test(timeout=60000L)
    public void testExceptionIsPropagated() throws Exception {
        ThrowingCheckable target = new ThrowingCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 1000L, 0L, this.getExecutorService());
        Optional olf = checker.schedule((Checkable)target, (Object)true);
        Assert.assertTrue((boolean)olf.isPresent());
        try {
            ((ListenableFuture)olf.get()).get();
            Assert.fail((String)"Failed to get expected ExecutionException");
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof DummyException));
        }
    }

    @Test(timeout=60000L)
    public void testExceptionCaching() throws Exception {
        ThrowingCheckable target1 = new ThrowingCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 1000L, 0L, this.getExecutorService());
        Assert.assertTrue((boolean)checker.schedule((Checkable)target1, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target1, 1L);
        Assert.assertFalse((boolean)checker.schedule((Checkable)target1, (Object)true).isPresent());
        this.waitTestCheckableCheckCount(target1, 1L);
    }

    private ExecutorService getExecutorService() {
        return new ScheduledThreadPoolExecutor(1);
    }

    private static class StalledCheckable
    implements Checkable<Boolean, Boolean> {
        private StalledCheckable() {
        }

        public Boolean check(Boolean ignored) throws InterruptedException {
            Thread.sleep(Long.MAX_VALUE);
            return false;
        }
    }

    private static class DummyException
    extends Exception {
        private DummyException() {
        }
    }

    private static class ThrowingCheckable
    extends TestCheckableBase {
        private ThrowingCheckable() {
        }

        public Boolean check(Boolean context) throws DummyException {
            this.incrTotalChecks();
            throw new DummyException();
        }
    }

    private static class NoOpCheckable
    extends TestCheckableBase {
        private NoOpCheckable() {
        }

        public Boolean check(Boolean context) {
            this.incrTotalChecks();
            return context;
        }
    }

    private static abstract class TestCheckableBase
    implements Checkable<Boolean, Boolean> {
        protected final AtomicLong numChecks = new AtomicLong(0L);

        private TestCheckableBase() {
        }

        public long getTotalChecks() {
            return this.numChecks.get();
        }

        public void incrTotalChecks() {
            this.numChecks.incrementAndGet();
        }
    }
}

