/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommitBlockWithInvalidGenStamp {
    private static final int BLOCK_SIZE = 1024;
    private MiniDFSCluster cluster;
    private FSDirectory dir;
    private DistributedFileSystem dfs;

    @Before
    public void setUp() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(conf).build();
        this.cluster.waitActive();
        this.dir = this.cluster.getNamesystem().getFSDirectory();
        this.dfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommitWithInvalidGenStamp() throws Exception {
        Path file = new Path("/file");
        FSDataOutputStream out = null;
        try {
            out = this.dfs.create(file, (short)1);
            INodeFile fileNode = this.dir.getINode4Write(file.toString()).asFile();
            ExtendedBlock previous = null;
            Block newBlock = DFSTestUtil.addBlockToFile(false, this.cluster.getDataNodes(), this.dfs, this.cluster.getNamesystem(), file.toString(), fileNode, this.dfs.getClient().getClientName(), previous, 0, 100);
            Block newBlockClone = new Block(newBlock);
            previous = new ExtendedBlock(this.cluster.getNamesystem().getBlockPoolId(), newBlockClone);
            previous.setGenerationStamp(123L);
            try {
                this.dfs.getClient().getNamenode().complete(file.toString(), this.dfs.getClient().getClientName(), previous, fileNode.getId());
                Assert.fail((String)"should throw exception because invalid genStamp");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.toString().contains("Commit block with mismatching GS. NN has " + newBlock + ", client submits " + newBlockClone));
            }
            previous = new ExtendedBlock(this.cluster.getNamesystem().getBlockPoolId(), newBlock);
            boolean complete = this.dfs.getClient().getNamenode().complete(file.toString(), this.dfs.getClient().getClientName(), previous, fileNode.getId());
            Assert.assertTrue((String)"should complete successfully", (boolean)complete);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }
}

